/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util.test;

import edu.mines.jtk.util.Units;
import edu.mines.jtk.util.UnitsFormatException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class UnitsTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(UnitsTest.class);
        TestRunner.run((Test)suite);
    }

    public void testDefine() {
        boolean defined = false;
        try {
            defined = Units.define("degrees F", false, "degF");
            UnitsTest.assertTrue((boolean)defined);
            defined = Units.define("degrees C", false, "degC");
            UnitsTest.assertTrue((boolean)defined);
            defined = Units.define("cubic_inches", false, "in^3");
            UnitsTest.assertTrue((boolean)defined);
            defined = Units.isDefined("m");
            UnitsTest.assertTrue((boolean)defined);
            defined = Units.define("m", false, "meters");
            UnitsTest.assertTrue((!defined ? 1 : 0) != 0);
            defined = true;
        }
        catch (UnitsFormatException e) {
            UnitsTest.assertTrue((boolean)false);
        }
        defined = true;
        try {
            Units.define("foo_inches", false, "foo inches");
        }
        catch (UnitsFormatException e) {
            defined = false;
        }
        UnitsTest.assertTrue((!defined ? 1 : 0) != 0);
    }

    public void testConversion() {
        try {
            Units.define("degrees F", false, "degF");
            Units.define("degrees C", false, "degC");
            Units.define("cubic_inches", false, "in^3");
        }
        catch (UnitsFormatException e) {
            UnitsTest.assertTrue((boolean)false);
        }
        String[][] conversions = new String[][]{{"m", "foo", "invalid", "invalid"}, {"foo", "m", "invalid", "invalid"}, {"s", "m", "incompatible", "incompatible"}, {"m", "meters", "0", "1"}, {"-1 cm", "m", "0", "-0.01"}, {"degC", "degF", "32", "1.8"}, {"degrees C", "degrees F", "32", "1.8"}, {"degrees_Celsius", "degrees_Fahrenheit", "32", "1.8"}, {"10^-2 m^2", "(0.1 m)^2", "0", "1"}, {"ft/s", "m/s", "0", "0.3048"}, {"ampere hour", "coulomb", "0", "3600"}, {"cubic_inches/min", "m^3/s", "0", "2.73117733333E-7"}, {"avoirdupois_ounce/ft^2", "kg/m^2", "0", "0.305151693637"}, {"kgf*s^2/m", "kg", "0", "9.80665"}, {"kilogram*meter/second^2", "kilogram*meter/second/second", "0", "1.0"}};
        for (int i = 0; i < conversions.length; ++i) {
            String from = conversions[i][0];
            String to = conversions[i][1];
            Units fromUnits = null;
            Units toUnits = null;
            try {
                fromUnits = new Units(from);
                toUnits = new Units(to);
            }
            catch (UnitsFormatException e) {
                UnitsTest.assertTrue((boolean)conversions[i][2].equals("invalid"));
                continue;
            }
            if (fromUnits.haveDimensionsOf(toUnits)) {
                float shift = toUnits.floatShiftFrom(fromUnits);
                float scale = toUnits.floatScaleFrom(fromUnits);
                float shiftExpected = Float.parseFloat(conversions[i][2]);
                float scaleExpected = Float.parseFloat(conversions[i][3]);
                UnitsTest.assertTrue((shift == shiftExpected ? 1 : 0) != 0);
                UnitsTest.assertTrue((scale == scaleExpected ? 1 : 0) != 0);
                continue;
            }
            UnitsTest.assertTrue((boolean)conversions[i][2].equals("incompatible"));
        }
    }

    public void testSpecification() {
        try {
            Units.define("degrees F", false, "degF");
        }
        catch (UnitsFormatException e) {
            UnitsTest.assertTrue((boolean)false);
        }
        String[][] specifications = new String[][]{{"", ""}, {"foo", "invalid"}, {"%", "0.01"}, {"kHz", "1000.0 second^-1"}, {"kgf*s^2/m", "9.80665 kilogram"}, {"degrees F", "0.5555555555555556 kelvin - 459.67"}};
        for (int i = 0; i < specifications.length; ++i) {
            String sd = null;
            try {
                sd = new Units(specifications[i][0]).standardDefinition();
                UnitsTest.assertTrue((boolean)sd.equals(specifications[i][1]));
                continue;
            }
            catch (UnitsFormatException e) {
                UnitsTest.assertTrue((boolean)specifications[i][1].equals("invalid"));
            }
        }
    }
}

