/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util.test;

import edu.mines.jtk.util.RandomFloat;
import edu.mines.jtk.util.Stopwatch;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RandomFloatTest
extends TestCase {
    public static void main(String[] args) {
        if (args.length > 0 && args[0].equals("bench")) {
            RandomFloatTest.bench();
        }
        TestSuite suite = new TestSuite(RandomFloatTest.class);
        TestRunner.run((Test)suite);
    }

    public void testNothing() {
    }

    public static void bench() {
        Random r = new Random();
        RandomFloat rf = new RandomFloat();
        Stopwatch sw = new Stopwatch();
        for (int ntrial = 0; ntrial < 3; ++ntrial) {
            System.out.println();
            System.out.println("java.util.Random:");
            sw.restart();
            float sum = 0.0f;
            int nf = 0;
            while (sw.time() < 1.0) {
                sum += r.nextFloat();
                ++nf;
            }
            sw.stop();
            double rate = (double)nf / sw.time();
            System.out.println("  uniform: float/s=" + rate + " sum=" + sum);
            sw.restart();
            sum = 0.0f;
            nf = 0;
            while (sw.time() < 1.0) {
                sum += (float)r.nextGaussian();
                ++nf;
            }
            sw.stop();
            rate = (double)nf / sw.time();
            System.out.println("   normal: float/s=" + rate + " sum=" + sum);
            System.out.println();
            System.out.println("edu.mines.jtk.util.RandomFloat:");
            sw.restart();
            sum = 0.0f;
            nf = 0;
            while (sw.time() < 1.0) {
                sum += rf.uniform();
                ++nf;
            }
            sw.stop();
            rate = (double)nf / sw.time();
            System.out.println("  uniform: float/s=" + rate + " sum=" + sum);
            sw.restart();
            sum = 0.0f;
            nf = 0;
            while (sw.time() < 1.0) {
                sum += rf.normal();
                ++nf;
            }
            sw.stop();
            rate = (double)nf / sw.time();
            System.out.println("   normal: float/s=" + rate + " sum=" + sum);
        }
    }
}

