/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util.test;

import edu.mines.jtk.util.MathPlus;
import edu.mines.jtk.util.RTree;
import edu.mines.jtk.util.Stopwatch;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class RTreeTest
extends TestCase {
    private static Random _random = new Random();

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(RTreeTest.class);
        TestRunner.run((Test)suite);
    }

    public void testRandom() {
        RTree rt = new RTree(3, 4, 12);
        STree st = new STree(3);
        int n = 1000;
        for (int i = 0; i < n; ++i) {
            RTree.Box box = this.randomBox(0.2f);
            rt.add(box);
            st.add(box);
            RTreeTest.assertEquals((int)rt.size(), (int)st.size());
        }
        rt.validate();
        while (rt.size() > 0) {
            RTree.Box box = this.randomBox(0.4f);
            Object[] rb = rt.findOverlapping(box);
            Object[] sb = st.findOverlapping(box);
            RTreeTest.assertEquals((int)rb.length, (int)sb.length);
            for (int ib = 0; ib < rb.length; ++ib) {
                RTree.Box rbi = (RTree.Box)rb[ib];
                RTree.Box sbi = (RTree.Box)sb[ib];
                rt.remove(rbi);
                st.remove(sbi);
                RTreeTest.assertEquals((int)rt.size(), (int)st.size());
            }
        }
    }

    public void testNearest() {
        RTree rt = new RTree(3, 4, 12);
        STree st = new STree(3);
        int n = 100;
        for (int i = 0; i < n; ++i) {
            RTree.Box box = this.randomBox(0.2f);
            rt.add(box);
            st.add(box);
        }
        rt.validate();
        int k = 3;
        for (int i = 0; i < n; ++i) {
            float[] point = this.randomPoint();
            Object[] rb = rt.findNearest(k, point);
            Object[] sb = st.findNearest(k, point);
            RTreeTest.assertEquals((int)k, (int)rb.length);
            RTreeTest.assertEquals((int)k, (int)sb.length);
            for (int j = 0; j < k; ++j) {
                float rd = ((RTree.Box)rb[j]).getDistanceSquared(point);
                float sd = ((RTree.Box)sb[j]).getDistanceSquared(point);
                RTreeTest.assertEquals((float)sd, (float)rd, (float)0.0f);
            }
        }
    }

    public void testIterator() {
        RTree rt = new RTree(3, 4, 12);
        int n = 100;
        for (int i = 0; i < n; ++i) {
            rt.add(this.randomBox(0.2f));
        }
        Iterator<Object> rti = rt.iterator();
        Object box = rti.next();
        rt.remove(box);
        rt.add(box);
        boolean cmeThrown = false;
        try {
            rti.next();
        }
        catch (ConcurrentModificationException cme) {
            cmeThrown = true;
        }
        RTreeTest.assertTrue((boolean)cmeThrown);
        Object[] boxs = rt.toArray();
        int nbox = boxs.length;
        for (int ibox = 0; ibox < nbox; ++ibox) {
            boolean removed = rt.remove(boxs[ibox]);
            RTreeTest.assertTrue((boolean)removed);
        }
    }

    public void xtestTriangle() {
        int it;
        int nt;
        RTree rt = new RTree(3, 6, 12);
        STree st = new STree(3);
        int nsurf = 5;
        int nx = 100;
        int ny = 100;
        int np = nt = nsurf * 2 * nx * ny;
        float radius = 2.0f / (float)nx;
        Object[] ts = this.makeSurfaceTriangles(nsurf, nx, ny);
        Point[] ps = this.makeSurfacePoints(nsurf, np);
        Point[] pr = this.makeRandomPoints(np);
        Point[][] psr = new Point[][]{ps, pr};
        System.out.println();
        Stopwatch sw = new Stopwatch();
        double time = 3.0;
        float[] point = new float[3];
        boolean pack = true;
        sw.restart();
        if (pack) {
            rt.addPacked(ts);
        } else {
            for (it = 0; it < nt; ++it) {
                rt.add(ts[it]);
            }
        }
        sw.stop();
        System.out.println("RTree added " + rt.size() + " triangles at " + (int)((double)rt.size() / sw.time()) + " triangle/sec");
        System.out.println("  leaf area=" + rt.getLeafArea() + " volume=" + rt.getLeafVolume());
        sw.restart();
        for (it = 0; it < nt; ++it) {
            st.add((RTree.Boxed)ts[it]);
        }
        sw.stop();
        System.out.println("STree added " + st.size() + " triangles at " + (int)((double)st.size() / sw.time()) + " triangle/sec");
        RTreeTest.assertEquals((int)rt.size(), (int)st.size());
        for (int ip = 0; ip < 100; ++ip) {
            Point p = ps[ip % np];
            point[0] = p.x;
            point[1] = p.y;
            point[2] = p.z;
            Object[] rb = rt.findInSphere(point, radius);
            Object[] sb = st.findInSphere(point, radius);
            RTreeTest.assertEquals((int)sb.length, (int)rb.length);
        }
        System.out.println("RTree has " + rt.size() + " objects in " + rt.getLevels() + " levels.");
        for (int isr = 0; isr < 2; ++isr) {
            Point p;
            Point[] pp = psr[isr];
            if (isr == 0) {
                System.out.println("Points on surfaces:");
            } else {
                System.out.println("Random points:");
            }
            int nr = 0;
            sw.restart();
            while (sw.time() < time) {
                Point p2 = pp[nr % np];
                point[0] = p2.x;
                point[1] = p2.y;
                point[2] = p2.z;
                rt.findNearest(point);
                ++nr;
            }
            sw.stop();
            System.out.println("  RTree findNearest/sec = " + (int)((double)nr / sw.time()));
            int ns = 0;
            sw.restart();
            while (sw.time() < time) {
                p = pp[nr % np];
                point[0] = p.x;
                point[1] = p.y;
                point[2] = p.z;
                st.findNearest(point);
                ++ns;
            }
            sw.stop();
            System.out.println("  STree findNearest/sec = " + (int)((double)ns / sw.time()));
            nr = 0;
            sw.restart();
            while (sw.time() < time) {
                p = ps[nr % np];
                point[0] = p.x;
                point[1] = p.y;
                point[2] = p.z;
                rt.findInSphere(point, radius);
                ++nr;
            }
            sw.stop();
            System.out.println("  RTree findInSphere/sec = " + (int)((double)nr / sw.time()));
            ns = 0;
            sw.restart();
            while (sw.time() < time) {
                p = ps[nr % np];
                point[0] = p.x;
                point[1] = p.y;
                point[2] = p.z;
                st.findInSphere(point, radius);
                ++ns;
            }
            sw.stop();
            System.out.println("  STree findInSphere/sec = " + (int)((double)ns / sw.time()));
        }
    }

    public void xtestPoint() {
        int i;
        RTree rt = new RTree(3, 6, 12);
        STree st = new STree(3);
        int n = 100000;
        Point[] ps = new Point[n];
        for (int i2 = 0; i2 < n; ++i2) {
            ps[i2] = new Point();
        }
        System.out.println();
        Stopwatch sw = new Stopwatch();
        sw.restart();
        for (i = 0; i < n; ++i) {
            rt.add(ps[i]);
        }
        sw.stop();
        System.out.println("RTree add points/sec=" + (int)((double)n / sw.time()));
        sw.restart();
        for (i = 0; i < n; ++i) {
            st.add(ps[i]);
        }
        sw.stop();
        float radius = 0.1f;
        System.out.println("STree add points/sec=" + (int)((double)n / sw.time()));
        for (int i3 = 0; i3 < 100; ++i3) {
            float[] point = this.randomPoint();
            Object[] rb = rt.findInSphere(point, radius);
            Object[] sb = st.findInSphere(point, radius);
            RTreeTest.assertEquals((int)sb.length, (int)rb.length);
        }
        double time = 3.0;
        float[] point = new float[3];
        int nr = 0;
        sw.restart();
        while (sw.time() < time) {
            Point p = ps[nr % n];
            point[0] = p.x;
            point[1] = p.y;
            point[2] = p.z;
            rt.findInSphere(point, radius);
            ++nr;
        }
        sw.stop();
        System.out.println("RTree findInSphere/sec = " + (int)((double)nr / sw.time()));
        int ns = 0;
        sw.restart();
        while (sw.time() < time) {
            Point p = ps[nr % n];
            point[0] = p.x;
            point[1] = p.y;
            point[2] = p.z;
            st.findInSphere(point, radius);
            ++ns;
        }
        sw.stop();
        System.out.println("STree findInSphere/sec = " + (int)((double)ns / sw.time()));
    }

    private RTree.Box randomBox(float size) {
        float xmin = (1.0f - size) * _random.nextFloat();
        float ymin = (1.0f - size) * _random.nextFloat();
        float zmin = (1.0f - size) * _random.nextFloat();
        float xmax = xmin + size * _random.nextFloat();
        float ymax = ymin + size * _random.nextFloat();
        float zmax = zmin + size * _random.nextFloat();
        return new RTree.Box(xmin, ymin, zmin, xmax, ymax, zmax);
    }

    private float[] randomPoint() {
        float x = _random.nextFloat();
        float y = _random.nextFloat();
        float z = _random.nextFloat();
        return new float[]{x, y, z};
    }

    private Triangle[] makeSurfaceTriangles(int nsurf, int nx, int ny) {
        int nt = nsurf * 2 * nx * ny;
        Triangle[] t = new Triangle[nt];
        float dx = 1.0f / (float)nx;
        float dy = 1.0f / (float)ny;
        int it = 0;
        for (int isurf = 0; isurf < nsurf; ++isurf) {
            for (int ix = 0; ix < nx; ++ix) {
                float x = (float)ix * dx;
                for (int iy = 0; iy < ny; ++iy) {
                    float y = (float)iy * dy;
                    Point pa = this.pointOnSurface(isurf, x, y);
                    Point pb = this.pointOnSurface(isurf, x + dx, y);
                    Point pc = this.pointOnSurface(isurf, x + dx, y + dy);
                    Point pd = this.pointOnSurface(isurf, x, y + dy);
                    t[it++] = new Triangle(pa.x, pa.y, pa.z, pb.x, pb.y, pb.z, pd.x, pd.y, pd.z);
                    t[it++] = new Triangle(pb.x, pb.y, pb.z, pc.x, pc.y, pc.z, pd.x, pd.y, pd.z);
                }
            }
        }
        return t;
    }

    private Point[] makeSurfacePoints(int nsurf, int np) {
        Point[] p = new Point[np];
        for (int ip = 0; ip < np; ++ip) {
            float x = _random.nextFloat();
            float y = _random.nextFloat();
            int isurf = _random.nextInt(nsurf);
            p[ip] = this.pointOnSurface(isurf, x, y);
        }
        return p;
    }

    private Point pointOnSurface(int isurf, float x, float y) {
        float z = 0.1f + (float)isurf * 0.1f + 0.05f * MathPlus.sin(20.0f * x + 20.0f * y);
        return new Point(x, y, z);
    }

    private Point[] makeRandomPoints(int np) {
        Point[] p = new Point[np];
        for (int ip = 0; ip < np; ++ip) {
            p[ip] = new Point();
        }
        return p;
    }

    static {
        int seed = _random.nextInt();
        _random.setSeed(seed);
    }

    private static class Triangle
    implements RTree.Boxed {
        float x0;
        float y0;
        float z0;
        float x1;
        float y1;
        float z1;
        float x2;
        float y2;
        float z2;

        Triangle(float size) {
            this.x0 = (1.0f - size) * _random.nextFloat();
            this.y0 = (1.0f - size) * _random.nextFloat();
            this.z0 = (1.0f - size) * _random.nextFloat();
            this.x1 = this.x0 + size * _random.nextFloat();
            this.y1 = this.y0 + size * _random.nextFloat();
            this.z1 = this.z0 + size * _random.nextFloat();
            this.x2 = this.x0 + size * _random.nextFloat();
            this.y2 = this.y0 + size * _random.nextFloat();
            this.z2 = this.z0 + size * _random.nextFloat();
        }

        Triangle(float x0, float y0, float z0, float x1, float y1, float z1, float x2, float y2, float z2) {
            this.x0 = x0;
            this.y0 = y0;
            this.z0 = z0;
            this.x1 = x1;
            this.y1 = y1;
            this.z1 = z1;
            this.x2 = x2;
            this.y2 = y2;
            this.z2 = z2;
        }

        public void getBounds(float[] min, float[] max) {
            float f = this.x0 <= this.x1 ? (this.x0 <= this.x2 ? this.x0 : this.x2) : (min[0] = this.x1 <= this.x2 ? this.x1 : this.x2);
            float f2 = this.y0 <= this.y1 ? (this.y0 <= this.y2 ? this.y0 : this.y2) : (min[1] = this.y1 <= this.y2 ? this.y1 : this.y2);
            float f3 = this.z0 <= this.z1 ? (this.z0 <= this.z2 ? this.z0 : this.z2) : (min[2] = this.z1 <= this.z2 ? this.z1 : this.z2);
            float f4 = this.x0 >= this.x1 ? (this.x0 >= this.x2 ? this.x0 : this.x2) : (max[0] = this.x1 >= this.x2 ? this.x1 : this.x2);
            float f5 = this.y0 >= this.y1 ? (this.y0 >= this.y2 ? this.y0 : this.y2) : (max[1] = this.y1 >= this.y2 ? this.y1 : this.y2);
            max[2] = this.z0 >= this.z1 ? (this.z0 >= this.z2 ? this.z0 : this.z2) : (this.z1 >= this.z2 ? this.z1 : this.z2);
        }

        public float getDistanceSquared(float[] point) {
            float q;
            float xp = point[0];
            float yp = point[1];
            float zp = point[2];
            float x0p = this.x0 - xp;
            float y0p = this.y0 - yp;
            float z0p = this.z0 - zp;
            float x10 = this.x1 - this.x0;
            float y10 = this.y1 - this.y0;
            float z10 = this.z1 - this.z0;
            float x20 = this.x2 - this.x0;
            float y20 = this.y2 - this.y0;
            float z20 = this.z2 - this.z0;
            float a = x10 * x10 + y10 * y10 + z10 * z10;
            float b = x10 * x20 + y10 * y20 + z10 * z20;
            float c = x20 * x20 + y20 * y20 + z20 * z20;
            float d = x10 * x0p + y10 * y0p + z10 * z0p;
            float e = x20 * x0p + y20 * y0p + z20 * z0p;
            float f = x0p * x0p + y0p * y0p + z0p * z0p;
            float s = b * e - c * d;
            float t = b * d - a * e;
            float det = MathPlus.abs(a * c - b * b);
            if (s + t <= det) {
                if (s < 0.0f) {
                    if (t < 0.0f) {
                        if (d < 0.0f) {
                            t = 0.0f;
                            if (-d >= a) {
                                s = 1.0f;
                                q = a + 2.0f * d + f;
                            } else {
                                s = -d / a;
                                q = d * s + f;
                            }
                        } else {
                            s = 0.0f;
                            if (e >= 0.0f) {
                                t = 0.0f;
                                q = f;
                            } else if (-e >= c) {
                                t = 1.0f;
                                q = c + 2.0f * e + f;
                            } else {
                                t = -e / c;
                                q = e * t + f;
                            }
                        }
                    } else {
                        s = 0.0f;
                        if (e >= 0.0f) {
                            t = 0.0f;
                            q = f;
                        } else if (-e >= c) {
                            t = 1.0f;
                            q = c + 2.0f * e + f;
                        } else {
                            t = -e / c;
                            q = e * t + f;
                        }
                    }
                } else if (t < 0.0f) {
                    t = 0.0f;
                    if (d >= 0.0f) {
                        s = 0.0f;
                        q = f;
                    } else if (-d >= a) {
                        s = 1.0f;
                        q = a + 2.0f * d + f;
                    } else {
                        s = -d / a;
                        q = d * s + f;
                    }
                } else {
                    float odet = 1.0f / det;
                    q = (s *= odet) * (a * s + b * (t *= odet) + 2.0f * d) + t * (b * s + c * t + 2.0f * e) + f;
                }
            } else if (s < 0.0f) {
                float ce = c + e;
                float bd = b + d;
                if (ce > bd) {
                    float num = ce - bd;
                    float den = a - 2.0f * b + c;
                    if (num >= den) {
                        s = 1.0f;
                        t = 0.0f;
                        q = a + 2.0f * d + f;
                    } else {
                        s = num / den;
                        t = 1.0f - s;
                        q = s * (a * s + b * t + 2.0f * d) + t * (b * s + c * t + 2.0f * e) + f;
                    }
                } else {
                    s = 0.0f;
                    if (ce <= 0.0f) {
                        t = 1.0f;
                        q = c + 2.0f * e + f;
                    } else if (e >= 0.0f) {
                        t = 0.0f;
                        q = f;
                    } else {
                        t = -e / c;
                        q = e * t + f;
                    }
                }
            } else if (t < 0.0f) {
                float ad = a + d;
                float be = b + e;
                if (ad > be) {
                    float num = ad - be;
                    float den = a - 2.0f * b + c;
                    if (num >= den) {
                        t = 1.0f;
                        s = 0.0f;
                        q = c + 2.0f * e + f;
                    } else {
                        t = num / den;
                        s = 1.0f - t;
                        q = s * (a * s + b * t + 2.0f * d) + t * (b * s + c * t + 2.0f * e) + f;
                    }
                } else {
                    t = 0.0f;
                    if (ad <= 0.0f) {
                        s = 1.0f;
                        q = a + 2.0f * d + f;
                    } else if (d >= 0.0f) {
                        s = 0.0f;
                        q = f;
                    } else {
                        s = -d / a;
                        q = d * s + f;
                    }
                }
            } else {
                float num = c + e - b - d;
                if (num <= 0.0f) {
                    s = 0.0f;
                    t = 1.0f;
                    q = c + 2.0f * e + f;
                } else {
                    float den = a - 2.0f * b + c;
                    if (num >= den) {
                        s = 1.0f;
                        t = 0.0f;
                        q = a + 2.0f * d + f;
                    } else {
                        s = num / den;
                        t = 1.0f - s;
                        q = s * (a * s + b * t + 2.0f * d) + t * (b * s + c * t + 2.0f * e) + f;
                    }
                }
            }
            return q;
        }
    }

    private static class Point
    implements RTree.Boxed {
        float x;
        float y;
        float z;

        Point() {
            this.x = _random.nextFloat();
            this.y = _random.nextFloat();
            this.z = _random.nextFloat();
        }

        Point(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public void getBounds(float[] min, float[] max) {
            min[0] = this.x;
            min[1] = this.y;
            min[2] = this.z;
            max[0] = this.x;
            max[1] = this.y;
            max[2] = this.z;
        }

        public float getDistanceSquared(float[] point) {
            float dx = this.x - point[0];
            float dy = this.y - point[1];
            float dz = this.z - point[2];
            return dx * dx + dy * dy + dz * dz;
        }
    }

    private static class STree {
        private HashSet<RTree.Boxed> _set = new HashSet();
        private int _ndim;
        private float[] _amin;
        private float[] _amax;
        private float[] _bmin;
        private float[] _bmax;

        public STree(int ndim) {
            this._ndim = ndim;
            this._amin = new float[this._ndim];
            this._amax = new float[this._ndim];
            this._bmin = new float[this._ndim];
            this._bmax = new float[this._ndim];
        }

        public boolean add(RTree.Boxed boxed) {
            return this._set.add(boxed);
        }

        public boolean remove(RTree.Boxed boxed) {
            return this._set.remove(boxed);
        }

        public int size() {
            return this._set.size();
        }

        public boolean contains(RTree.Boxed boxed) {
            return this._set.contains(boxed);
        }

        public Object[] findOverlapping(RTree.Boxed boxed) {
            boxed.getBounds(this._amin, this._amax);
            ArrayList<RTree.Boxed> list = new ArrayList<RTree.Boxed>();
            for (RTree.Boxed b : this._set) {
                b.getBounds(this._bmin, this._bmax);
                if (!this.overlapsAB()) continue;
                list.add(b);
            }
            return list.toArray();
        }

        public Object findNearest(float[] point) {
            return this.findNearest(1, point)[0];
        }

        public Object[] findNearest(int n, float[] point) {
            ArrayList<RTree.Boxed> list = new ArrayList<RTree.Boxed>();
            for (int i = 0; i < n; ++i) {
                float dmin = Float.MAX_VALUE;
                RTree.Boxed bmin = null;
                for (RTree.Boxed b : this._set) {
                    float d;
                    if (list.contains(b) || !((d = b.getDistanceSquared(point)) < dmin)) continue;
                    dmin = d;
                    bmin = b;
                }
                list.add(bmin);
            }
            return list.toArray();
        }

        public Object[] findInSphere(float[] point, float radius) {
            ArrayList<RTree.Boxed> list = new ArrayList<RTree.Boxed>();
            Iterator<RTree.Boxed> i = this._set.iterator();
            float s = radius * radius;
            while (i.hasNext()) {
                RTree.Boxed b = i.next();
                if (!(b.getDistanceSquared(point) < s)) continue;
                list.add(b);
            }
            return list.toArray();
        }

        private boolean overlapsAB() {
            for (int idim = 0; idim < this._ndim; ++idim) {
                if (!(this._amin[idim] > this._bmax[idim]) && !(this._amax[idim] < this._bmin[idim])) continue;
                return false;
            }
            return true;
        }
    }
}

