/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util.test;

import edu.mines.jtk.util.CleanFormatter;
import edu.mines.jtk.util.CleanHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CleanFormatterTest
extends TestCase {
    private static final String NL = System.getProperty("line.separator");

    public void testFormatter() {
        CleanHandler.setDefaultHandler();
        Logger logger = Logger.getLogger("edu.mines.jtk.util.CleanFormatter");
        CleanFormatter cf = new CleanFormatter();
        String[] messages = new String[]{"one", "two", "three"};
        Level[] levels = new Level[]{Level.INFO, Level.WARNING, Level.SEVERE};
        String[] s = new String[3];
        for (int i = 0; i < messages.length; ++i) {
            LogRecord lr = new LogRecord(levels[i], messages[i]);
            lr.setSourceClassName("Class");
            lr.setSourceMethodName("method");
            s[i] = cf.format(lr);
            CleanFormatterTest.assertTrue((boolean)s[i].endsWith(messages[i] + NL));
            logger.fine("|" + s[i] + "|");
        }
        assert (s[0].equals("one" + NL)) : s[0];
        assert (s[1].equals("WARNING: two" + NL)) : s[1];
        assert (s[2].matches("^\\*\\*\\*\\* SEVERE WARNING \\*\\*\\*\\* \\(Class.method \\d+-\\d+ #.*\\)" + NL + "SEVERE: three" + NL + "$")) : s[2];
    }

    public void testPrepend() {
        String lines = CleanFormatter.prependToLines("a", "bbb" + NL + "ccc");
        assert (lines.equals("abbb" + NL + "accc"));
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public CleanFormatterTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(CleanFormatterTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)CleanFormatterTest.suite());
    }
}

