/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util.test;

import edu.mines.jtk.util.Cfloat;
import edu.mines.jtk.util.MathPlus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CfloatTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(CfloatTest.class);
        TestRunner.run((Test)suite);
    }

    public void test() {
        Cfloat a = new Cfloat((float)Math.PI, (float)Math.E);
        Cfloat b = new Cfloat((float)Math.E, (float)Math.PI);
        this.assertEquals(a, Cfloat.sub(Cfloat.add(a, b), b));
        this.assertEquals(a, Cfloat.div(Cfloat.mul(a, b), b));
        this.assertEquals(a, Cfloat.conj(Cfloat.conj(a)));
        this.assertEquals(a, Cfloat.polar(Cfloat.abs(a), Cfloat.arg(a)));
        this.assertEquals(a, Cfloat.exp(Cfloat.log(a)));
        this.assertEquals(a, Cfloat.pow(Cfloat.sqrt(a), 2.0f));
        this.assertEquals(Cfloat.pow(a, b), Cfloat.exp(b.times(Cfloat.log(a))));
        this.assertEquals(Cfloat.pow(a, b), Cfloat.exp(b.times(Cfloat.log(a))));
        this.assertEquals(Cfloat.sin(Cfloat.FLT_I.times(a)), Cfloat.FLT_I.times(Cfloat.sinh(a)));
        this.assertEquals(Cfloat.cos(Cfloat.FLT_I.times(a)), Cfloat.cosh(a));
        this.assertEquals(Cfloat.tan(Cfloat.FLT_I.times(a)), Cfloat.FLT_I.times(Cfloat.tanh(a)));
    }

    private void assertEquals(float expected, float actual) {
        float small = 1.0E-6f * MathPlus.max(MathPlus.abs(expected), MathPlus.abs(actual), 1.0f);
        CfloatTest.assertEquals((float)expected, (float)actual, (float)small);
    }

    private void assertEquals(Cfloat expected, Cfloat actual) {
        this.assertEquals(expected.r, actual.r);
        this.assertEquals(expected.i, actual.i);
    }
}

