/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util.test;

import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Cfloat;
import edu.mines.jtk.util.MathPlus;
import java.util.Arrays;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArrayTest
extends TestCase {
    private static final int SAWTOOTH = 0;
    private static final int RAND = 1;
    private static final int STAGGER = 2;
    private static final int PLATEAU = 3;
    private static final int SHUFFLE = 4;
    private static final int COPY = 0;
    private static final int REV = 1;
    private static final int REVHALF1 = 2;
    private static final int REVHALF2 = 3;
    private static final int SORT = 4;
    private static final int DITHER = 5;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(ArrayTest.class);
        TestRunner.run((Test)suite);
    }

    public void testSort() {
        Random r = new Random(314159L);
        int[] ntest = new int[]{100, 1023, 1024, 1025};
        for (int itest = 0; itest < ntest.length; ++itest) {
            int n = ntest[itest];
            float[] x = new float[n];
            for (int m = 1; m < 2 * n; m *= 2) {
                for (int dist = 0; dist < 5; ++dist) {
                    int j = 0;
                    int k = 1;
                    for (int i = 0; i < n; ++i) {
                        int ix = 0;
                        switch (dist) {
                            case 0: {
                                ix = i % m;
                                break;
                            }
                            case 1: {
                                ix = r.nextInt() % m;
                                break;
                            }
                            case 2: {
                                ix = (i * m + i) % n;
                                break;
                            }
                            case 3: {
                                ix = MathPlus.min(i, m);
                                break;
                            }
                            case 4: {
                                ix = r.nextInt() % m != 0 ? (j += 2) : (k += 2);
                            }
                        }
                        x[i] = ix;
                    }
                    for (int order = 0; order < 6; ++order) {
                        float[] y = null;
                        float[] z = null;
                        switch (order) {
                            case 0: {
                                y = Array.copy(x);
                                break;
                            }
                            case 1: {
                                y = Array.reverse(x);
                                break;
                            }
                            case 2: {
                                y = Array.copy(x);
                                z = Array.reverse(Array.copy(n / 2, x));
                                Array.copy(n / 2, 0, z, 0, y);
                                break;
                            }
                            case 3: {
                                y = Array.copy(x);
                                z = Array.reverse(Array.copy(n / 2, n / 2, x));
                                Array.copy(n / 2, 0, z, n / 2, y);
                                break;
                            }
                            case 4: {
                                y = Array.copy(x);
                                Arrays.sort(y);
                                break;
                            }
                            case 5: {
                                y = Array.copy(x);
                                for (int i = 0; i < n; ++i) {
                                    int n2 = i;
                                    y[n2] = y[n2] + (float)(i % 5);
                                }
                                break;
                            }
                        }
                        this.sortAndCheck(y);
                    }
                }
            }
        }
    }

    private void sortAndCheck(float[] x) {
        int j;
        int i;
        int n = x.length;
        float[] x1 = Array.copy(x);
        for (int k = 0; k < n; k += n / 4) {
            Array.quickPartialSort(k, x1);
            for (i = 0; i < k; ++i) {
                ArrayTest.assertTrue((x1[i] <= x1[k] ? 1 : 0) != 0);
            }
            for (i = k; i < n; ++i) {
                ArrayTest.assertTrue((x1[k] <= x1[i] ? 1 : 0) != 0);
            }
        }
        float[] x2 = Array.copy(x);
        Array.quickSort(x2);
        for (i = 1; i < n; ++i) {
            ArrayTest.assertTrue((x2[i - 1] <= x2[i] ? 1 : 0) != 0);
        }
        int[] i1 = Array.rampint(0, 1, n);
        for (int k = 0; k < n; k += n / 4) {
            Array.quickPartialIndexSort(k, x, i1);
            for (j = 0; j < k; ++j) {
                ArrayTest.assertTrue((x[i1[j]] <= x[i1[k]] ? 1 : 0) != 0);
            }
            for (j = k + 1; j < n; ++j) {
                ArrayTest.assertTrue((x[i1[k]] <= x[i1[j]] ? 1 : 0) != 0);
            }
        }
        int[] i2 = Array.rampint(0, 1, n);
        Array.quickIndexSort(x, i2);
        for (j = 1; j < n; ++j) {
            ArrayTest.assertTrue((x[i2[j - 1]] <= x[i2[j]] ? 1 : 0) != 0);
        }
    }

    public void testFloat1() {
        int n1 = 8;
        int n2 = 6;
        int n3 = 4;
        float[] a1 = Array.rampfloat(0.0f, 1.0f, n1);
        float[][] a2 = Array.rampfloat(0.0f, 1.0f, 10.0f, n1, n2);
        float[][][] a3 = Array.rampfloat(0.0f, 1.0f, 10.0f, 100.0f, n1, n2, n3);
        float[] b1 = Array.copy(a1);
        float[][] b2 = Array.copy(a2);
        float[][][] b3 = Array.copy(a3);
        this.assertEqual(b1, a1);
        this.assertEqual(b2, a2);
        this.assertEqual(b3, a3);
        Array.copy(a1, b1);
        Array.copy(a2, b2);
        Array.copy(a3, b3);
        this.assertEqual(b1, a1);
        this.assertEqual(b2, a2);
        this.assertEqual(b3, a3);
        b1 = Array.copy(n1 - 1, a1);
        b2 = Array.copy(n1 - 1, n2 - 1, a2);
        b3 = Array.copy(n1 - 1, n2 - 1, n3 - 1, a3);
        this.assertEqual(b1, Array.rampfloat(0.0f, 1.0f, n1 - 1));
        this.assertEqual(b2, Array.rampfloat(0.0f, 1.0f, 10.0f, n1 - 1, n2 - 1));
        this.assertEqual(b3, Array.rampfloat(0.0f, 1.0f, 10.0f, 100.0f, n1 - 1, n2 - 1, n3 - 1));
        Array.copy(n1 - 1, a1, b1);
        Array.copy(n1 - 1, n2 - 1, a2, b2);
        Array.copy(n1 - 1, n2 - 1, n3 - 1, a3, b3);
        this.assertEqual(b1, Array.rampfloat(0.0f, 1.0f, n1 - 1));
        this.assertEqual(b2, Array.rampfloat(0.0f, 1.0f, 10.0f, n1 - 1, n2 - 1));
        this.assertEqual(b3, Array.rampfloat(0.0f, 1.0f, 10.0f, 100.0f, n1 - 1, n2 - 1, n3 - 1));
        b1 = Array.copy(n1 - 1, 1, a1);
        b2 = Array.copy(n1 - 2, n2 - 1, 2, 1, a2);
        b3 = Array.copy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3);
        this.assertEqual(b1, Array.rampfloat(1.0f, 1.0f, n1 - 1));
        this.assertEqual(b2, Array.rampfloat(12.0f, 1.0f, 10.0f, n1 - 1, n2 - 1));
        this.assertEqual(b3, Array.rampfloat(123.0f, 1.0f, 10.0f, 100.0f, n1 - 1, n2 - 1, n3 - 1));
        Array.copy(n1 - 1, 1, a1, 0, b1);
        Array.copy(n1 - 2, n2 - 1, 2, 1, a2, 0, 0, b2);
        Array.copy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3, 0, 0, 0, b3);
        this.assertEqual(b1, Array.rampfloat(1.0f, 1.0f, n1 - 1));
        this.assertEqual(b2, Array.rampfloat(12.0f, 1.0f, 10.0f, n1 - 1, n2 - 1));
        this.assertEqual(b3, Array.rampfloat(123.0f, 1.0f, 10.0f, 100.0f, n1 - 1, n2 - 1, n3 - 1));
        b1 = Array.copy(n1 / 2, 0, 2, a1);
        b2 = Array.copy(n1 / 2, n2 / 2, 0, 0, 2, 2, a2);
        b3 = Array.copy(n1 / 2, n2 / 2, n3 / 2, 0, 0, 0, 2, 2, 2, a3);
        this.assertEqual(b1, Array.rampfloat(0.0f, 2.0f, n1 / 2));
        this.assertEqual(b2, Array.rampfloat(0.0f, 2.0f, 20.0f, n1 / 2, n2 / 2));
        this.assertEqual(b3, Array.rampfloat(0.0f, 2.0f, 20.0f, 200.0f, n1 / 2, n2 / 2, n3 / 2));
        b1 = Array.copy(a1);
        b2 = Array.copy(a2);
        b3 = Array.copy(a3);
        Array.copy(n1 - 1, 1, a1, 1, b1);
        Array.copy(n1 - 2, n2 - 1, 2, 1, a2, 2, 1, b2);
        Array.copy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3, 3, 2, 1, b3);
        this.assertEqual(b1, Array.rampfloat(0.0f, 1.0f, n1));
        this.assertEqual(b2, Array.rampfloat(0.0f, 1.0f, 10.0f, n1, n2));
        this.assertEqual(b3, Array.rampfloat(0.0f, 1.0f, 10.0f, 100.0f, n1, n2, n3));
        b1 = Array.reverse(Array.reverse(a1));
        this.assertEqual(b1, a1);
        b2 = Array.reshape(n1, n2, Array.flatten(a2));
        b3 = Array.reshape(n1, n2, n3, Array.flatten(a3));
        this.assertEqual(a2, b2);
        this.assertEqual(a3, b3);
        b2 = Array.transpose(Array.transpose(a2));
        this.assertEqual(a2, b2);
    }

    public void testFloat2() {
        int n1 = 3;
        int n2 = 4;
        int n3 = 5;
        float r0 = 0.0f;
        float ra = 2.0f;
        float rb1 = 1.0f;
        float rb2 = 2.0f;
        float rb3 = 4.0f;
        this.assertEqual(Array.zerofloat(n1, n2, n3), Array.fillfloat(r0, n1, n2, n3));
        float[][][] rx = Array.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertEqual(rx, Array.sub(Array.add(rx, rx), rx));
        this.assertEqual(rx, Array.sub(Array.add(rx, ra), ra));
        this.assertEqual(Array.fillfloat(ra, n1, n2, n3), Array.sub(Array.add(ra, rx), rx));
        rx = Array.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertEqual(rx, Array.div(Array.mul(rx, rx), rx));
        this.assertEqual(rx, Array.div(Array.mul(rx, ra), ra));
        this.assertEqual(Array.fillfloat(ra, n1, n2, n3), Array.div(Array.mul(ra, rx), rx));
        rx = Array.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertEqual(rx, Array.log(Array.exp(rx)));
        rx = Array.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertAlmostEqual(rx, Array.mul(Array.sqrt(rx), Array.sqrt(rx)));
        rx = Array.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        this.assertAlmostEqual(rx, Array.pow(Array.sqrt(rx), 2.0f));
        rx = Array.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        int[] imax = new int[]{-1, -1, -1};
        float rmax = Array.max(rx, imax);
        ArrayTest.assertTrue((rmax == rx[n3 - 1][n2 - 1][n1 - 1] ? 1 : 0) != 0);
        ArrayTest.assertEquals((int)(n1 - 1), (int)imax[0]);
        ArrayTest.assertEquals((int)(n2 - 1), (int)imax[1]);
        ArrayTest.assertEquals((int)(n3 - 1), (int)imax[2]);
        rx = Array.rampfloat(ra, rb1, rb2, rb3, n1, n2, n3);
        int[] imin = new int[]{-1, -1, -1};
        float rmin = Array.min(rx, imin);
        ArrayTest.assertTrue((rmin == rx[0][0][0] ? 1 : 0) != 0);
        ArrayTest.assertEquals((int)0, (int)imin[0]);
        ArrayTest.assertEquals((int)0, (int)imin[1]);
        ArrayTest.assertEquals((int)0, (int)imin[2]);
    }

    private void assertEqual(float[] rx, float[] ry) {
        ArrayTest.assertTrue((boolean)Array.equal(rx, ry));
    }

    private void assertEqual(float[][] rx, float[][] ry) {
        ArrayTest.assertTrue((boolean)Array.equal(rx, ry));
    }

    private void assertEqual(float[][][] rx, float[][][] ry) {
        ArrayTest.assertTrue((boolean)Array.equal(rx, ry));
    }

    private void assertAlmostEqual(float[][][] rx, float[][][] ry) {
        float tolerance = 1.1920929E-5f;
        ArrayTest.assertTrue((boolean)Array.equal(tolerance, rx, ry));
    }

    public void testCfloat1() {
        int n1 = 8;
        int n2 = 6;
        int n3 = 4;
        Cfloat c0 = new Cfloat(0.0f, 0.0f);
        Cfloat c1 = new Cfloat(1.0f, 0.0f);
        Cfloat c2 = new Cfloat(2.0f, 0.0f);
        Cfloat c10 = new Cfloat(10.0f, 0.0f);
        Cfloat c12 = new Cfloat(12.0f, 0.0f);
        Cfloat c20 = new Cfloat(20.0f, 0.0f);
        Cfloat c100 = new Cfloat(100.0f, 0.0f);
        Cfloat c123 = new Cfloat(123.0f, 0.0f);
        Cfloat c200 = new Cfloat(200.0f, 0.0f);
        float[] a1 = Array.crampfloat(c0, c1, n1);
        float[][] a2 = Array.crampfloat(c0, c1, c10, n1, n2);
        float[][][] a3 = Array.crampfloat(c0, c1, c10, c100, n1, n2, n3);
        float[] b1 = Array.ccopy(a1);
        float[][] b2 = Array.ccopy(a2);
        float[][][] b3 = Array.ccopy(a3);
        this.assertEqual(b1, a1);
        this.assertEqual(b2, a2);
        this.assertEqual(b3, a3);
        Array.ccopy(a1, b1);
        Array.ccopy(a2, b2);
        Array.ccopy(a3, b3);
        this.assertEqual(b1, a1);
        this.assertEqual(b2, a2);
        this.assertEqual(b3, a3);
        b1 = Array.ccopy(n1 - 1, a1);
        b2 = Array.ccopy(n1 - 1, n2 - 1, a2);
        b3 = Array.ccopy(n1 - 1, n2 - 1, n3 - 1, a3);
        this.assertEqual(b1, Array.crampfloat(c0, c1, n1 - 1));
        this.assertEqual(b2, Array.crampfloat(c0, c1, c10, n1 - 1, n2 - 1));
        this.assertEqual(b3, Array.crampfloat(c0, c1, c10, c100, n1 - 1, n2 - 1, n3 - 1));
        Array.ccopy(n1 - 1, a1, b1);
        Array.ccopy(n1 - 1, n2 - 1, a2, b2);
        Array.ccopy(n1 - 1, n2 - 1, n3 - 1, a3, b3);
        this.assertEqual(b1, Array.crampfloat(c0, c1, n1 - 1));
        this.assertEqual(b2, Array.crampfloat(c0, c1, c10, n1 - 1, n2 - 1));
        this.assertEqual(b3, Array.crampfloat(c0, c1, c10, c100, n1 - 1, n2 - 1, n3 - 1));
        b1 = Array.ccopy(n1 - 1, 1, a1);
        b2 = Array.ccopy(n1 - 2, n2 - 1, 2, 1, a2);
        b3 = Array.ccopy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3);
        this.assertEqual(b1, Array.crampfloat(c1, c1, n1 - 1));
        this.assertEqual(b2, Array.crampfloat(c12, c1, c10, n1 - 1, n2 - 1));
        this.assertEqual(b3, Array.crampfloat(c123, c1, c10, c100, n1 - 1, n2 - 1, n3 - 1));
        Array.ccopy(n1 - 1, 1, a1, 0, b1);
        Array.ccopy(n1 - 2, n2 - 1, 2, 1, a2, 0, 0, b2);
        Array.ccopy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3, 0, 0, 0, b3);
        this.assertEqual(b1, Array.crampfloat(c1, c1, n1 - 1));
        this.assertEqual(b2, Array.crampfloat(c12, c1, c10, n1 - 1, n2 - 1));
        this.assertEqual(b3, Array.crampfloat(c123, c1, c10, c100, n1 - 1, n2 - 1, n3 - 1));
        b1 = Array.ccopy(n1 / 2, 0, 2, a1);
        b2 = Array.ccopy(n1 / 2, n2 / 2, 0, 0, 2, 2, a2);
        b3 = Array.ccopy(n1 / 2, n2 / 2, n3 / 2, 0, 0, 0, 2, 2, 2, a3);
        this.assertEqual(b1, Array.crampfloat(c0, c2, n1 / 2));
        this.assertEqual(b2, Array.crampfloat(c0, c2, c20, n1 / 2, n2 / 2));
        this.assertEqual(b3, Array.crampfloat(c0, c2, c20, c200, n1 / 2, n2 / 2, n3 / 2));
        b1 = Array.ccopy(a1);
        b2 = Array.ccopy(a2);
        b3 = Array.ccopy(a3);
        Array.ccopy(n1 - 1, 1, a1, 1, b1);
        Array.ccopy(n1 - 2, n2 - 1, 2, 1, a2, 2, 1, b2);
        Array.ccopy(n1 - 3, n2 - 2, n3 - 1, 3, 2, 1, a3, 3, 2, 1, b3);
        this.assertEqual(b1, Array.crampfloat(c0, c1, n1));
        this.assertEqual(b2, Array.crampfloat(c0, c1, c10, n1, n2));
        this.assertEqual(b3, Array.crampfloat(c0, c1, c10, c100, n1, n2, n3));
        b1 = Array.creverse(Array.creverse(a1));
        this.assertEqual(b1, a1);
        b2 = Array.creshape(n1, n2, Array.cflatten(a2));
        b3 = Array.creshape(n1, n2, n3, Array.cflatten(a3));
        this.assertEqual(a2, b2);
        this.assertEqual(a3, b3);
        b2 = Array.ctranspose(Array.ctranspose(a2));
        this.assertEqual(a2, b2);
    }

    public void testCfloat2() {
        int n1 = 3;
        int n2 = 4;
        int n3 = 5;
        Cfloat c0 = new Cfloat();
        Cfloat ca = new Cfloat(1.0f, 2.0f);
        Cfloat cb1 = new Cfloat(2.0f, 3.0f);
        Cfloat cb2 = new Cfloat(3.0f, 4.0f);
        Cfloat cb3 = new Cfloat(4.0f, 5.0f);
        this.assertEqual(Array.czerofloat(n1, n2, n3), Array.cfillfloat(c0, n1, n2, n3));
        float[][][] cx = Array.crampfloat(ca, cb1, cb2, cb3, n1, n2, n3);
        this.assertEqual(cx, Array.csub(Array.cadd(cx, cx), cx));
        this.assertEqual(cx, Array.csub(Array.cadd(cx, ca), ca));
        this.assertEqual(Array.cfillfloat(ca, n1, n2, n3), Array.csub(Array.cadd(ca, cx), cx));
        cx = Array.crampfloat(ca, cb1, cb2, cb3, n1, n2, n3);
        this.assertEqual(cx, Array.cdiv(Array.cmul(cx, cx), cx));
        this.assertEqual(cx, Array.cdiv(Array.cmul(cx, ca), ca));
        this.assertEqual(Array.cfillfloat(ca, n1, n2, n3), Array.cdiv(Array.cmul(ca, cx), cx));
        cx = Array.crampfloat(ca, cb1, cb2, cb3, n1, n2, n3);
        this.assertEqual(Array.cnorm(cx), Array.cabs(Array.cmul(cx, Array.cconj(cx))));
        float[][][] rr = Array.fillfloat(1.0f, n1, n2, n3);
        float[][][] ra = Array.rampfloat(0.0f, 1.0f, 1.0f, 1.0f, n1, n2, n3);
        cx = Array.polar(rr, ra);
        float[][][] rx = Array.cos(ra);
        float[][][] ry = Array.sin(ra);
        float[][][] cy = Array.cmplx(rx, ry);
        this.assertEqual(cx, cy);
        Cfloat ci = new Cfloat(0.0f, 1.0f);
        float[][][] ciw = Array.crampfloat(c0, ci, ci, ci, n1, n2, n3);
        float[][][] cz = Array.cexp(ciw);
        this.assertEqual(cx, cz);
    }

    public void testMonotonic() {
        double[] a = new double[]{};
        ArrayTest.assertTrue((boolean)Array.isMonotonic(a));
        ArrayTest.assertTrue((boolean)Array.isIncreasing(a));
        ArrayTest.assertTrue((boolean)Array.isDecreasing(a));
        double[] a0 = new double[]{0.0};
        ArrayTest.assertTrue((boolean)Array.isMonotonic(a0));
        ArrayTest.assertTrue((boolean)Array.isIncreasing(a0));
        ArrayTest.assertTrue((boolean)Array.isDecreasing(a0));
        double[] a01 = new double[]{0.0, 1.0};
        ArrayTest.assertTrue((boolean)Array.isMonotonic(a01));
        ArrayTest.assertTrue((boolean)Array.isIncreasing(a01));
        ArrayTest.assertTrue((!Array.isDecreasing(a01) ? 1 : 0) != 0);
        double[] a10 = new double[]{1.0, 0.0};
        ArrayTest.assertTrue((boolean)Array.isMonotonic(a10));
        ArrayTest.assertTrue((!Array.isIncreasing(a10) ? 1 : 0) != 0);
        ArrayTest.assertTrue((boolean)Array.isDecreasing(a10));
        double[] a101 = new double[]{1.0, 0.0, 1.0};
        ArrayTest.assertTrue((!Array.isMonotonic(a101) ? 1 : 0) != 0);
        ArrayTest.assertTrue((!Array.isIncreasing(a101) ? 1 : 0) != 0);
        ArrayTest.assertTrue((!Array.isDecreasing(a101) ? 1 : 0) != 0);
        double[] a010 = new double[]{0.0, 1.0, 0.0};
        ArrayTest.assertTrue((!Array.isMonotonic(a010) ? 1 : 0) != 0);
        ArrayTest.assertTrue((!Array.isIncreasing(a010) ? 1 : 0) != 0);
        ArrayTest.assertTrue((!Array.isDecreasing(a010) ? 1 : 0) != 0);
    }

    public void testBinarySearch() {
        double[] a = new double[]{};
        this.checkSearch(a, 1.0);
        double[] a0 = new double[]{2.0};
        this.checkSearch(a0, 1.0);
        this.checkSearch(a0, 2.0);
        this.checkSearch(a0, 3.0);
        double[] a13 = new double[]{1.0, 3.0};
        this.checkSearch(a13, 0.0);
        this.checkSearch(a13, 1.0);
        this.checkSearch(a13, 2.0);
        this.checkSearch(a13, 3.0);
        this.checkSearch(a13, 4.0);
        double[] a31 = new double[]{3.0, 1.0};
        this.checkSearch(a31, 0.0);
        this.checkSearch(a31, 1.0);
        this.checkSearch(a31, 2.0);
        this.checkSearch(a31, 3.0);
        this.checkSearch(a31, 4.0);
        double[] a135 = new double[]{1.0, 3.0, 5.0};
        this.checkSearch(a135, 0.0);
        this.checkSearch(a135, 1.0);
        this.checkSearch(a135, 2.0);
        this.checkSearch(a135, 3.0);
        this.checkSearch(a135, 4.0);
        this.checkSearch(a135, 5.0);
        this.checkSearch(a135, 6.0);
        double[] a531 = new double[]{5.0, 3.0, 1.0};
        this.checkSearch(a531, 0.0);
        this.checkSearch(a531, 1.0);
        this.checkSearch(a531, 2.0);
        this.checkSearch(a531, 3.0);
        this.checkSearch(a531, 4.0);
        this.checkSearch(a531, 5.0);
        this.checkSearch(a531, 6.0);
    }

    private void checkSearch(double[] a, double x) {
        int n = a.length;
        int i = Array.binarySearch(a, x);
        this.validateSearch(a, x, i);
        for (int is = -2; is < n + 2; ++is) {
            i = Array.binarySearch(a, x, is);
            this.validateSearch(a, x, i);
        }
    }

    private void validateSearch(double[] a, double x, int i) {
        int n = a.length;
        if (i >= 0) {
            ArrayTest.assertTrue((a[i] == x ? 1 : 0) != 0);
        } else {
            i = -(i + 1);
            if (n == 0) {
                ArrayTest.assertTrue((i == 0 ? 1 : 0) != 0);
            } else if (n < 2 || a[0] < a[n - 1]) {
                if (i == 0) {
                    ArrayTest.assertTrue((x < a[i] ? 1 : 0) != 0);
                } else if (i == n) {
                    ArrayTest.assertTrue((a[i - 1] < x ? 1 : 0) != 0);
                } else {
                    ArrayTest.assertTrue((a[i - 1] < x && x < a[i] ? 1 : 0) != 0);
                }
            } else if (i == 0) {
                ArrayTest.assertTrue((x > a[i] ? 1 : 0) != 0);
            } else if (i == n) {
                ArrayTest.assertTrue((a[i - 1] > x ? 1 : 0) != 0);
            } else {
                ArrayTest.assertTrue((a[i - 1] > x && x > a[i] ? 1 : 0) != 0);
            }
        }
    }
}

