/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util.test;

import edu.mines.jtk.util.ArgsParser;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class ArgsParserTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(ArgsParserTest.class);
        TestRunner.run((Test)suite);
    }

    public void testArgsParser() {
        String[][] args = new String[][]{{"-a3.14", "-b", "foo"}, {"-a", "3.14", "-b", "foo"}, {"--alpha", "3.14", "--beta", "foo"}, {"--a=3.14", "--b", "foo"}};
        for (int iarg = 0; iarg < args.length; ++iarg) {
            float a = 0.0f;
            boolean b = false;
            try {
                String shortOpts = "ha:b";
                String[] longOpts = new String[]{"help", "alpha=", "beta"};
                ArgsParser ap = new ArgsParser(args[iarg], shortOpts, longOpts);
                String[] opts = ap.getOptions();
                String[] vals = ap.getValues();
                for (int i = 0; i < opts.length; ++i) {
                    String opt = opts[i];
                    String val = vals[i];
                    if (opt.equals("-h") || opt.equals("--help")) {
                        ArgsParserTest.assertTrue((boolean)false);
                        continue;
                    }
                    if (opt.equals("-a") || opt.equals("--alpha")) {
                        a = ArgsParser.toFloat(val);
                        continue;
                    }
                    if (!opt.equals("-b") && !opt.equals("--beta")) continue;
                    b = true;
                }
                String[] otherArgs = ap.getOtherArgs();
                ArgsParserTest.assertTrue((otherArgs.length == 1 ? 1 : 0) != 0);
                ArgsParserTest.assertTrue((boolean)otherArgs[0].equals("foo"));
                ArgsParserTest.assertTrue((a == 3.14f ? 1 : 0) != 0);
                ArgsParserTest.assertTrue((b ? 1 : 0) != 0);
                continue;
            }
            catch (ArgsParser.OptionException e) {
                ArgsParserTest.assertTrue((String)("no exceptions: e=" + e.getMessage()), (boolean)false);
            }
        }
    }
}

