/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util.test;

import edu.mines.jtk.util.Almost;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class AlmostTest
extends TestCase {
    public void testEverything() {
        Almost a = new Almost();
        assert (a.between(1.0, 0.0, 2.0));
        assert (a.between(-1.0, 0.0, -2.0));
        assert (a.between(-1.0, -0.5, -2.0));
        assert (a.outside(1.0, 0.0, 2.0) == 0);
        assert (a.outside(1.0, 0.5, 2.0) == 0);
        assert (a.outside(-1.0, 0.0, -2.0) == 0);
        assert (a.outside(-1.0, -0.5, -2.0) == 0);
        assert (a.cmp(1.0, 0.0) > 0);
        assert (a.cmp(0.0, 1.0) < 0);
        assert (a.cmp(1.0, 1.0) == 0);
        assert (a.cmp(0.0, 0.0) == 0);
        assert (a.equal(3.0, 3.0));
        assert (a.equal(0.0, 0.0));
        assert (a.zero(0.0));
        assert (a.zero(a.getMinValue() / 2.0));
        assert (!a.zero(a.getMinValue() * 2.0));
        assert (1.0 != 1.0 + a.getEpsilon());
        assert (1.0 != 1.0 - a.getEpsilon());
        assert (0.0 != a.getMinValue());
        assert (a.equal(1.0, 1.0 + a.getEpsilon() / 2.0));
        assert (!a.equal(1.0, 1.0 + a.getEpsilon() * 2.1));
        assert (a.equal(1.0, 1.000000000001));
        assert (a.getMinValue() / 2.0 > 0.0);
        assert (a.equal(0.0, a.getMinValue() / 2.0));
        assert (a.between(1.0, 1.000000000001, 2.0));
        assert (a.between(-1.0, -1.000000000001, -2.0));
        assert (a.outside(1.0, 1.000000000001, 2.0) == 0);
        assert (a.cmp(1.0, 1.000000000001) == 0);
    }

    public void testHashCode() {
        Almost a = new Almost(0.001, 1.0E-6);
        assert (a.hashCodeOf(new Double(1.0E-8), 100) == 0);
        assert (a.hashCodeOf(new Double(0.99999999), 100) == 1);
        assert (a.hashCodeOf(new Double(1.00000001), 100) == 1);
        assert (a.hashCodeOf(new Long(123456789L), 100) == 123456789);
        assert (a.hashCodeOf(new Double(3.1415), 4) == a.hashCodeOf(new Double(3.1415926), 4));
        assert (a.hashCodeOf(new Double(3.1415), 5) != a.hashCodeOf(new Double(3.1415926), 5));
        assert (a.hashCodeOf(new Double(-3.1415), 4) == a.hashCodeOf(new Double(-3.1415926), 4));
        assert (a.hashCodeOf(new Double(-3.1415), 5) != a.hashCodeOf(new Double(-3.1415926), 5));
        assert (a.hashCodeOf(new Double(314.15), 4) == a.hashCodeOf(new Double(314.15926), 4));
        assert (a.hashCodeOf(new Double(314.15), 5) != a.hashCodeOf(new Double(314.15926), 5));
        assert (a.hashCodeOf(new Double(-314.15), 4) == a.hashCodeOf(new Double(-314.15926), 4));
        assert (a.hashCodeOf(new Double(-314.15), 5) != a.hashCodeOf(new Double(-314.15926), 5));
        assert (a.hashCodeOf(new Double(0.0031415), 4) == a.hashCodeOf(new Double(0.0031415926), 4));
        assert (a.hashCodeOf(new Double(0.0031415), 5) != a.hashCodeOf(new Double(0.0031415926), 5));
        a = new Almost(1.0E-4);
        assert (a.equal(0.0031415, 0.0031415926));
        assert (a.hashCodeOf(new Double(0.0031415)) == a.hashCodeOf(new Double(0.0031415926)));
        a = new Almost(1.0E-5);
        assert (!a.equal(0.0031415, 0.0031415926));
        assert (a.hashCodeOf(new Double(0.0031415)) != a.hashCodeOf(new Double(0.0031415926)));
        a = new Almost(4);
        assert (a.equal(0.0031415, 0.0031415926));
        assert (a.hashCodeOf(new Double(0.0031415)) == a.hashCodeOf(new Double(0.0031415926)));
        a = new Almost(5);
        assert (!a.equal(0.0031415, 0.0031415926));
        assert (a.hashCodeOf(new Double(0.0031415)) != a.hashCodeOf(new Double(0.0031415926)));
    }

    public void testNaNs() {
        try {
            Almost.FLOAT.equal(3.0, Double.NaN);
            assert (false);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Almost.FLOAT.equal(0.0, Double.NaN);
            assert (false);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Almost.FLOAT.equal(3.0, Double.NaN);
            assert (false);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            Almost.FLOAT.equal(0.0, Double.NaN);
            assert (false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAlmostObjectMethod() {
        Almost af1 = new Almost(1.1920928955078125E-6, 1.4E-43f);
        Almost af2 = new Almost(1.1920928955078125E-6);
        Almost af3 = new Almost();
        Almost ad = new Almost(2.220446049250313E-15, 4.94E-322);
        assert (af1.equals(af2)) : af1 + " " + af2;
        assert (af1.equals(af3)) : af1 + " " + af3;
        assert (af2.equals(af3)) : af2 + " " + af3;
        assert (af1.hashCode() == af2.hashCode()) : af1 + " " + af2;
        assert (af1.hashCode() == af3.hashCode()) : af1 + " " + af3;
        assert (af2.hashCode() == af3.hashCode()) : af2 + " " + af3;
        assert (af1.toString().equals(af2.toString())) : af1.toString() + " " + af2.toString();
        assert (af1.toString().equals(af3.toString())) : af1.toString() + " " + af3.toString();
        assert (af2.toString().equals(af3.toString())) : af2.toString() + " " + af3.toString();
        for (Almost af : new Almost[]{af1, af2, af3}) {
            assert (!af.equals(ad));
            assert (af.hashCode() != ad.hashCode());
            assert (!af.toString().equals(ad.toString()));
        }
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public AlmostTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(AlmostTest.class);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)AlmostTest.suite());
    }
}

