/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import java.util.NoSuchElementException;

public class StringParser {
    private String _str = null;
    private int _pos = 0;
    private int _end = 0;
    private int _len = 0;

    public StringParser(String s) {
        this._str = s;
        this._len = s.length();
        this._pos = 0;
        this._end = -1;
    }

    public boolean hasMoreStrings() {
        int space = 32;
        int quote = 34;
        int backslash = 92;
        if (this._pos <= this._end) {
            return true;
        }
        if (this._pos > this._len || this._str == null) {
            return false;
        }
        char c = '\u0000';
        while (this._pos < this._len && (c = this._str.charAt(this._pos)) <= ' ') {
            ++this._pos;
        }
        if (this._pos >= this._len) {
            return false;
        }
        if (c == '\"') {
            ++this._pos;
            boolean in_escape = false;
            this._end = this._pos;
            while (this._end < this._len) {
                c = this._str.charAt(this._end);
                if (in_escape) {
                    in_escape = false;
                } else if (c == '\\') {
                    in_escape = true;
                } else if (c == '\"') break;
                ++this._end;
            }
        } else {
            this._end = this._pos + 1;
            while (this._end < this._len && (c = this._str.charAt(this._end)) > ' ') {
                ++this._end;
            }
        }
        return true;
    }

    public String nextString() {
        if (!this.hasMoreStrings()) {
            throw new NoSuchElementException("StringParser.nextString: no more strings in " + this._str + ".");
        }
        int pos = this._pos;
        this._pos = this._end + 1;
        return this.replaceEscapes(this._str.substring(pos, this._end));
    }

    private String replaceEscapes(String s) {
        int backslash = 92;
        if (s == null || s.indexOf(92) < 0) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.length());
        boolean in_escape = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (in_escape) {
                switch (c) {
                    case '\\': {
                        sb.append('\\');
                        break;
                    }
                    case 't': {
                        sb.append('\t');
                        break;
                    }
                    case 'n': {
                        sb.append('\n');
                        break;
                    }
                    case 'r': {
                        sb.append('\r');
                        break;
                    }
                    case 'f': {
                        sb.append('\f');
                        break;
                    }
                    case 'b': {
                        sb.append('\b');
                        break;
                    }
                    default: {
                        sb.append(c);
                    }
                }
                in_escape = false;
                continue;
            }
            if (c == '\\') {
                in_escape = true;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

