/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.ParameterConvertException;
import edu.mines.jtk.util.ParameterSet;
import edu.mines.jtk.util.XmlUtil;

public class Parameter
implements Cloneable {
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int INT = 2;
    public static final int LONG = 3;
    public static final int FLOAT = 4;
    public static final int DOUBLE = 5;
    public static final int STRING = 6;
    private String _name;
    private ParameterSet _parent;
    private String _units;
    private Object _values;

    public Parameter(String name) {
        this.setNameAndParent(name, null);
    }

    public Parameter(String name, boolean value) {
        this.setNameAndParent(name, null);
        this.setBoolean(value);
    }

    public Parameter(String name, int value) {
        this.setNameAndParent(name, null);
        this.setInt(value);
    }

    public Parameter(String name, long value) {
        this.setNameAndParent(name, null);
        this.setLong(value);
    }

    public Parameter(String name, float value) {
        this.setNameAndParent(name, null);
        this.setFloat(value);
    }

    public Parameter(String name, double value) {
        this.setNameAndParent(name, null);
        this.setDouble(value);
    }

    public Parameter(String name, String value) {
        this.setNameAndParent(name, null);
        this.setString(value);
    }

    public Parameter(String name, boolean[] values) {
        this.setNameAndParent(name, null);
        this.setBooleans(values);
    }

    public Parameter(String name, int[] values) {
        this.setNameAndParent(name, null);
        this.setInts(values);
    }

    public Parameter(String name, long[] values) {
        this.setNameAndParent(name, null);
        this.setLongs(values);
    }

    public Parameter(String name, float[] values) {
        this.setNameAndParent(name, null);
        this.setFloats(values);
    }

    public Parameter(String name, double[] values) {
        this.setNameAndParent(name, null);
        this.setDoubles(values);
    }

    public Parameter(String name, String[] values) {
        this.setNameAndParent(name, null);
        this.setStrings(values);
    }

    public Parameter(String name, boolean value, String units) {
        this.setNameAndParent(name, null);
        this.setBoolean(value);
        this.setUnits(units);
    }

    public Parameter(String name, int value, String units) {
        this.setNameAndParent(name, null);
        this.setInt(value);
        this.setUnits(units);
    }

    public Parameter(String name, long value, String units) {
        this.setNameAndParent(name, null);
        this.setLong(value);
        this.setUnits(units);
    }

    public Parameter(String name, float value, String units) {
        this.setNameAndParent(name, null);
        this.setFloat(value);
        this.setUnits(units);
    }

    public Parameter(String name, double value, String units) {
        this.setNameAndParent(name, null);
        this.setDouble(value);
        this.setUnits(units);
    }

    public Parameter(String name, String value, String units) {
        this.setNameAndParent(name, null);
        this.setString(value);
        this.setUnits(units);
    }

    public Parameter(String name, boolean[] values, String units) {
        this.setNameAndParent(name, null);
        this.setBooleans(values);
        this.setUnits(units);
    }

    public Parameter(String name, int[] values, String units) {
        this.setNameAndParent(name, null);
        this.setInts(values);
        this.setUnits(units);
    }

    public Parameter(String name, long[] values, String units) {
        this.setNameAndParent(name, null);
        this.setLongs(values);
        this.setUnits(units);
    }

    public Parameter(String name, float[] values, String units) {
        this.setNameAndParent(name, null);
        this.setFloats(values);
        this.setUnits(units);
    }

    public Parameter(String name, double[] values, String units) {
        this.setNameAndParent(name, null);
        this.setDoubles(values);
        this.setUnits(units);
    }

    public Parameter(String name, String[] values, String units) {
        this.setNameAndParent(name, null);
        this.setStrings(values);
        this.setUnits(units);
    }

    public Object clone() {
        try {
            Parameter p = (Parameter)super.clone();
            p._parent = null;
            return p.replaceWith(this);
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public Parameter replaceWith(Parameter par) {
        if (par == this) {
            return this;
        }
        this.setName(par.getName());
        this.setUnits(par.getUnits());
        this.setValues(par.getValues());
        return this;
    }

    public Parameter copyTo(ParameterSet parent) {
        return this.copyTo(parent, this.getName());
    }

    public Parameter copyTo(ParameterSet parent, String name) {
        if (parent == this._parent && name == this._name) {
            return this;
        }
        Parameter p = parent != null ? parent.addParameter(name) : new Parameter(name);
        p.setUnits(this.getUnits());
        p.setValues(this.getValues());
        return p;
    }

    public Parameter moveTo(ParameterSet parent) {
        return this.moveTo(parent, this.getName());
    }

    public Parameter moveTo(ParameterSet parent, String name) {
        if (parent == this._parent && name == this._name) {
            return this;
        }
        if (this._parent != null) {
            this._parent.remove(this);
        }
        if (parent != null) {
            parent.insert(name, this);
        } else {
            this.setNameAndParent(name, null);
        }
        return this;
    }

    public void remove() {
        if (this._parent != null) {
            this._parent.remove(this);
        }
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this.moveTo(this._parent, name);
    }

    public String getUnits() {
        return this._units;
    }

    public void setUnits(String units) {
        this._units = units;
    }

    public int getType() {
        if (this._values instanceof boolean[]) {
            return 1;
        }
        if (this._values instanceof int[]) {
            return 2;
        }
        if (this._values instanceof long[]) {
            return 3;
        }
        if (this._values instanceof float[]) {
            return 4;
        }
        if (this._values instanceof double[]) {
            return 5;
        }
        if (this._values instanceof String[]) {
            return 6;
        }
        return 0;
    }

    public void setType(int type) {
        this._values = type == 1 ? (Object)Parameter.valuesAsBooleans(this._values, false) : (type == 2 ? (Object)Parameter.valuesAsInts(this._values, false) : (type == 3 ? (Object)Parameter.valuesAsLongs(this._values, false) : (type == 4 ? (Object)Parameter.valuesAsFloats(this._values, false) : (type == 5 ? (Object)Parameter.valuesAsDoubles(this._values, false) : (type == 6 ? Parameter.valuesAsStrings(this._values, false) : null)))));
    }

    public ParameterSet getParent() {
        return this._parent;
    }

    public boolean getBoolean() throws ParameterConvertException {
        boolean[] values = Parameter.valuesAsBooleans(this._values, false);
        return values[values.length - 1];
    }

    public int getInt() throws ParameterConvertException {
        int[] values = Parameter.valuesAsInts(this._values, false);
        return values[values.length - 1];
    }

    public long getLong() throws ParameterConvertException {
        long[] values = Parameter.valuesAsLongs(this._values, false);
        return values[values.length - 1];
    }

    public float getFloat() throws ParameterConvertException {
        float[] values = Parameter.valuesAsFloats(this._values, false);
        return values[values.length - 1];
    }

    public double getDouble() throws ParameterConvertException {
        double[] values = Parameter.valuesAsDoubles(this._values, false);
        return values[values.length - 1];
    }

    public String getString() throws ParameterConvertException {
        String[] values = Parameter.valuesAsStrings(this._values, false);
        return values[values.length - 1];
    }

    public boolean[] getBooleans() throws ParameterConvertException {
        return Parameter.valuesAsBooleans(this._values, true);
    }

    public int[] getInts() throws ParameterConvertException {
        return Parameter.valuesAsInts(this._values, true);
    }

    public long[] getLongs() throws ParameterConvertException {
        return Parameter.valuesAsLongs(this._values, true);
    }

    public float[] getFloats() throws ParameterConvertException {
        return Parameter.valuesAsFloats(this._values, true);
    }

    public double[] getDoubles() throws ParameterConvertException {
        return Parameter.valuesAsDoubles(this._values, true);
    }

    public String[] getStrings() throws ParameterConvertException {
        return Parameter.valuesAsStrings(this._values, true);
    }

    public void setBoolean(boolean value) {
        this._values = new boolean[1];
        ((boolean[])this._values)[0] = value;
    }

    public void setInt(int value) {
        this._values = new int[1];
        ((int[])this._values)[0] = value;
    }

    public void setLong(long value) {
        this._values = new long[1];
        ((long[])this._values)[0] = value;
    }

    public void setFloat(float value) {
        this._values = new float[1];
        ((float[])this._values)[0] = value;
    }

    public void setDouble(double value) {
        this._values = new double[1];
        ((double[])this._values)[0] = value;
    }

    public void setString(String value) {
        this._values = new String[1];
        ((String[])this._values)[0] = value;
    }

    public void setBooleans(boolean[] values) {
        int length = values == null ? 0 : values.length;
        this._values = new boolean[length];
        if (length > 0) {
            System.arraycopy(values, 0, this._values, 0, length);
        }
    }

    public void setInts(int[] values) {
        int length = values == null ? 0 : values.length;
        this._values = new int[length];
        if (length > 0) {
            System.arraycopy(values, 0, this._values, 0, length);
        }
    }

    public void setLongs(long[] values) {
        int length = values == null ? 0 : values.length;
        this._values = new long[length];
        if (length > 0) {
            System.arraycopy(values, 0, this._values, 0, length);
        }
    }

    public void setFloats(float[] values) {
        int length = values == null ? 0 : values.length;
        this._values = new float[length];
        if (length > 0) {
            System.arraycopy(values, 0, this._values, 0, length);
        }
    }

    public void setDoubles(double[] values) {
        int length = values == null ? 0 : values.length;
        this._values = new double[length];
        if (length > 0) {
            System.arraycopy(values, 0, this._values, 0, length);
        }
    }

    public void setStrings(String[] values) {
        int length = values == null ? 0 : values.length;
        this._values = new String[length];
        if (length > 0) {
            System.arraycopy(values, 0, this._values, 0, length);
        }
    }

    public boolean isNull() {
        return this.getType() == 0;
    }

    public boolean isBoolean() {
        return this.getType() == 1;
    }

    public boolean isInt() {
        return this.getType() == 2;
    }

    public boolean isLong() {
        return this.getType() == 3;
    }

    public boolean isFloat() {
        return this.getType() == 4;
    }

    public boolean isDouble() {
        return this.getType() == 5;
    }

    public boolean isString() {
        return this.getType() == 6;
    }

    public String toString() {
        String indent = "";
        for (ParameterSet parent = this.getParent(); parent != null; parent = parent.getParent()) {
            indent = indent + "  ";
        }
        String name = XmlUtil.quoteAttributeValue(this._name);
        String units = XmlUtil.quoteAttributeValue(this._units);
        String type = XmlUtil.quoteAttributeValue(this.getTypeString());
        String[] values = Parameter.valuesAsStrings(this._values, true);
        for (int i = 0; i < values.length; ++i) {
            values[i] = XmlUtil.quoteCharacterData(values[i]);
        }
        StringBuffer sb = new StringBuffer(256);
        sb.append(indent).append("<par name=").append(name);
        sb.append(" type=").append(type);
        if (units != null) {
            sb.append(" units=").append(units);
        }
        if (this.isNull() || values.length == 0) {
            sb.append("/>\n");
        } else if (values.length == 1) {
            sb.append("> ").append(values[0]).append(" </par>\n");
        } else {
            sb.append(">\n");
            for (int i = 0; i < values.length; ++i) {
                sb.append(indent).append("  ").append(values[i]).append("\n");
            }
            sb.append(indent).append("</par>\n");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        block13: {
            int type;
            int nvalues;
            Parameter other;
            block17: {
                block16: {
                    block15: {
                        block14: {
                            block12: {
                                if (o == this) {
                                    return true;
                                }
                                if (o == null || this.getClass() != o.getClass()) {
                                    return false;
                                }
                                other = (Parameter)o;
                                if (this._name == null ? other._name != null : !this._name.equals(other._name)) {
                                    return false;
                                }
                                if (this._units == null ? other._units != null : !this._units.equals(other._units)) {
                                    return false;
                                }
                                if (this.getType() != other.getType()) {
                                    return false;
                                }
                                nvalues = this.countValues();
                                if (nvalues != other.countValues()) {
                                    return false;
                                }
                                type = this.getType();
                                if (type != 1) break block12;
                                boolean[] values = (boolean[])this._values;
                                boolean[] otherValues = (boolean[])other._values;
                                for (int i = 0; i < nvalues; ++i) {
                                    if (values[i] == otherValues[i]) continue;
                                    return false;
                                }
                                break block13;
                            }
                            if (type != 2) break block14;
                            int[] values = (int[])this._values;
                            int[] otherValues = (int[])other._values;
                            for (int i = 0; i < nvalues; ++i) {
                                if (values[i] == otherValues[i]) continue;
                                return false;
                            }
                            break block13;
                        }
                        if (type != 3) break block15;
                        long[] values = (long[])this._values;
                        long[] otherValues = (long[])other._values;
                        for (int i = 0; i < nvalues; ++i) {
                            if (values[i] == otherValues[i]) continue;
                            return false;
                        }
                        break block13;
                    }
                    if (type != 4) break block16;
                    float[] values = (float[])this._values;
                    float[] otherValues = (float[])other._values;
                    for (int i = 0; i < nvalues; ++i) {
                        if (values[i] == otherValues[i]) continue;
                        return false;
                    }
                    break block13;
                }
                if (type != 5) break block17;
                double[] values = (double[])this._values;
                double[] otherValues = (double[])other._values;
                for (int i = 0; i < nvalues; ++i) {
                    if (values[i] == otherValues[i]) continue;
                    return false;
                }
                break block13;
            }
            if (type != 6) break block13;
            String[] values = (String[])this._values;
            String[] otherValues = (String[])other._values;
            for (int i = 0; i < nvalues; ++i) {
                if (values[i].equals(otherValues[i])) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int code;
        block7: {
            int nvalues;
            int type;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            block6: {
                                String name = this._name != null ? this._name : "name";
                                String units = this._units != null ? this._units : "units";
                                type = this.getType();
                                code = name.hashCode() ^ units.hashCode() ^ type;
                                nvalues = this.countValues();
                                if (type != 1) break block6;
                                boolean[] values = (boolean[])this._values;
                                for (int i = 0; i < nvalues; ++i) {
                                    code ^= values[i] ? 1 : 0;
                                }
                                break block7;
                            }
                            if (type != 2) break block8;
                            int[] values = (int[])this._values;
                            for (int i = 0; i < nvalues; ++i) {
                                code ^= values[i];
                            }
                            break block7;
                        }
                        if (type != 3) break block9;
                        long[] values = (long[])this._values;
                        for (int i = 0; i < nvalues; ++i) {
                            long bits = values[i];
                            code ^= (int)bits ^ (int)(bits >> 32);
                        }
                        break block7;
                    }
                    if (type != 4) break block10;
                    float[] values = (float[])this._values;
                    for (int i = 0; i < nvalues; ++i) {
                        code ^= Float.floatToIntBits(values[i]);
                    }
                    break block7;
                }
                if (type != 5) break block11;
                double[] values = (double[])this._values;
                for (int i = 0; i < nvalues; ++i) {
                    long bits = Double.doubleToLongBits(values[i]);
                    code ^= (int)bits ^ (int)(bits >> 32);
                }
                break block7;
            }
            if (type != 6) break block7;
            String[] values = (String[])this._values;
            for (int i = 0; i < nvalues; ++i) {
                code ^= values[i].hashCode();
            }
        }
        return code;
    }

    Parameter(String name, ParameterSet parent) {
        this.setNameAndParent(name, parent);
    }

    void setParent(ParameterSet parent) {
        this._parent = parent;
    }

    void setNameAndParent(String name, ParameterSet parent) {
        this._name = name;
        if (this._name != null && this._name.equals("")) {
            this._name = null;
        }
        this._parent = parent;
    }

    Object getValues() {
        int n = 0;
        Object[] values = null;
        if (this._values instanceof boolean[]) {
            n = ((boolean[])this._values).length;
            values = new boolean[n];
        } else if (this._values instanceof int[]) {
            n = ((int[])this._values).length;
            values = new int[n];
        } else if (this._values instanceof long[]) {
            n = ((long[])this._values).length;
            values = new long[n];
        } else if (this._values instanceof float[]) {
            n = ((float[])this._values).length;
            values = new float[n];
        } else if (this._values instanceof double[]) {
            n = ((double[])this._values).length;
            values = new double[n];
        } else if (this._values instanceof String[]) {
            n = ((String[])this._values).length;
            values = new String[n];
        }
        if (n > 0) {
            System.arraycopy(this._values, 0, values, 0, n);
        }
        return values;
    }

    void setValues(Object values) {
        int n = 0;
        this._values = null;
        if (values instanceof boolean[]) {
            n = ((boolean[])values).length;
            this._values = new boolean[n];
        } else if (values instanceof int[]) {
            n = ((int[])values).length;
            this._values = new int[n];
        } else if (values instanceof long[]) {
            n = ((long[])values).length;
            this._values = new long[n];
        } else if (values instanceof float[]) {
            n = ((float[])values).length;
            this._values = new float[n];
        } else if (values instanceof double[]) {
            n = ((double[])values).length;
            this._values = new double[n];
        } else if (values instanceof String[]) {
            n = ((String[])values).length;
            this._values = new String[n];
        }
        if (n > 0) {
            System.arraycopy(values, 0, this._values, 0, n);
        }
    }

    private int countValues() {
        if (this.getType() == 1) {
            return ((boolean[])this._values).length;
        }
        if (this.getType() == 2) {
            return ((int[])this._values).length;
        }
        if (this.getType() == 3) {
            return ((long[])this._values).length;
        }
        if (this.getType() == 4) {
            return ((float[])this._values).length;
        }
        if (this.getType() == 5) {
            return ((double[])this._values).length;
        }
        if (this.getType() == 6) {
            return ((String[])this._values).length;
        }
        return 0;
    }

    private static boolean[] valuesAsBooleans(Object values, boolean copy) {
        boolean[] bvalues;
        block10: {
            bvalues = null;
            if (values instanceof boolean[]) {
                bvalues = (boolean[])values;
                if (copy) {
                    bvalues = new boolean[bvalues.length];
                    System.arraycopy(values, 0, bvalues, 0, bvalues.length);
                }
            } else {
                try {
                    if (values instanceof String[]) {
                        String[] svalues = (String[])values;
                        bvalues = new boolean[svalues.length];
                        for (int i = 0; i < svalues.length; ++i) {
                            String s = svalues[i].toLowerCase();
                            if (s.equals("true")) {
                                bvalues[i] = true;
                                continue;
                            }
                            if (s.equals("false")) {
                                bvalues[i] = false;
                                continue;
                            }
                            throw new Exception();
                        }
                        break block10;
                    }
                    if (values == null) {
                        bvalues = new boolean[]{};
                        break block10;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    String msg = "Parameter cannot convert " + Parameter.getTypeString(values) + " to boolean.";
                    throw new ParameterConvertException(msg);
                }
            }
        }
        return bvalues;
    }

    private static int[] valuesAsInts(Object values, boolean copy) {
        int[] ivalues;
        block8: {
            ivalues = null;
            if (values instanceof int[]) {
                ivalues = (int[])values;
                if (copy) {
                    ivalues = new int[ivalues.length];
                    System.arraycopy(values, 0, ivalues, 0, ivalues.length);
                }
            } else {
                try {
                    if (values instanceof String[]) {
                        String[] svalues = (String[])values;
                        ivalues = new int[svalues.length];
                        for (int i = 0; i < svalues.length; ++i) {
                            ivalues[i] = Integer.valueOf(svalues[i]);
                        }
                        break block8;
                    }
                    if (values == null) {
                        ivalues = new int[]{};
                        break block8;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    String msg = "Parameter cannot convert " + Parameter.getTypeString(values) + " to int.";
                    throw new ParameterConvertException(msg);
                }
            }
        }
        return ivalues;
    }

    private static long[] valuesAsLongs(Object values, boolean copy) {
        long[] lvalues;
        block8: {
            lvalues = null;
            if (values instanceof long[]) {
                lvalues = (long[])values;
                if (copy) {
                    lvalues = new long[lvalues.length];
                    System.arraycopy(values, 0, lvalues, 0, lvalues.length);
                }
            } else {
                try {
                    if (values instanceof String[]) {
                        String[] svalues = (String[])values;
                        lvalues = new long[svalues.length];
                        for (int i = 0; i < svalues.length; ++i) {
                            lvalues[i] = Long.valueOf(svalues[i]);
                        }
                        break block8;
                    }
                    if (values == null) {
                        lvalues = new long[]{};
                        break block8;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    String msg = "Parameter cannot convert " + Parameter.getTypeString(values) + " to long.";
                    throw new ParameterConvertException(msg);
                }
            }
        }
        return lvalues;
    }

    private static float[] valuesAsFloats(Object values, boolean copy) {
        float[] fvalues;
        block12: {
            fvalues = null;
            if (values instanceof float[]) {
                fvalues = (float[])values;
                if (copy) {
                    fvalues = new float[fvalues.length];
                    System.arraycopy(values, 0, fvalues, 0, fvalues.length);
                }
            } else {
                try {
                    if (values instanceof int[]) {
                        int[] ivalues = (int[])values;
                        fvalues = new float[ivalues.length];
                        for (int i = 0; i < ivalues.length; ++i) {
                            fvalues[i] = ivalues[i];
                        }
                        break block12;
                    }
                    if (values instanceof double[]) {
                        double[] dvalues = (double[])values;
                        fvalues = new float[dvalues.length];
                        for (int i = 0; i < dvalues.length; ++i) {
                            fvalues[i] = (float)dvalues[i];
                        }
                        break block12;
                    }
                    if (values instanceof String[]) {
                        String[] svalues = (String[])values;
                        fvalues = new float[svalues.length];
                        for (int i = 0; i < svalues.length; ++i) {
                            fvalues[i] = Float.valueOf(svalues[i]).floatValue();
                        }
                        break block12;
                    }
                    if (values == null) {
                        fvalues = new float[]{};
                        break block12;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    String msg = "Parameter cannot convert " + Parameter.getTypeString(values) + " to float.";
                    throw new ParameterConvertException(msg);
                }
            }
        }
        return fvalues;
    }

    private static double[] valuesAsDoubles(Object values, boolean copy) {
        double[] dvalues;
        block12: {
            dvalues = null;
            if (values instanceof double[]) {
                dvalues = (double[])values;
                if (copy) {
                    dvalues = new double[dvalues.length];
                    System.arraycopy(values, 0, dvalues, 0, dvalues.length);
                }
            } else {
                try {
                    if (values instanceof int[]) {
                        int[] ivalues = (int[])values;
                        dvalues = new double[ivalues.length];
                        for (int i = 0; i < ivalues.length; ++i) {
                            dvalues[i] = ivalues[i];
                        }
                        break block12;
                    }
                    if (values instanceof float[]) {
                        float[] fvalues = (float[])values;
                        dvalues = new double[fvalues.length];
                        for (int i = 0; i < fvalues.length; ++i) {
                            dvalues[i] = fvalues[i];
                        }
                        break block12;
                    }
                    if (values instanceof String[]) {
                        String[] svalues = (String[])values;
                        dvalues = new double[svalues.length];
                        for (int i = 0; i < svalues.length; ++i) {
                            dvalues[i] = Double.valueOf(svalues[i]);
                        }
                        break block12;
                    }
                    if (values == null) {
                        dvalues = new double[]{};
                        break block12;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    String msg = "Parameter cannot convert " + Parameter.getTypeString(values) + " to double.";
                    throw new ParameterConvertException(msg);
                }
            }
        }
        return dvalues;
    }

    private static String[] valuesAsStrings(Object values, boolean copy) {
        String[] svalues;
        block16: {
            svalues = null;
            if (values instanceof String[]) {
                svalues = (String[])values;
                if (copy) {
                    svalues = new String[svalues.length];
                    System.arraycopy(values, 0, svalues, 0, svalues.length);
                }
            } else {
                try {
                    if (values instanceof boolean[]) {
                        boolean[] bvalues = (boolean[])values;
                        svalues = new String[bvalues.length];
                        for (int i = 0; i < bvalues.length; ++i) {
                            svalues[i] = bvalues[i] ? "true" : "false";
                        }
                        break block16;
                    }
                    if (values instanceof int[]) {
                        int[] ivalues = (int[])values;
                        svalues = new String[ivalues.length];
                        for (int i = 0; i < ivalues.length; ++i) {
                            svalues[i] = Integer.toString(ivalues[i]);
                        }
                        break block16;
                    }
                    if (values instanceof long[]) {
                        long[] lvalues = (long[])values;
                        svalues = new String[lvalues.length];
                        for (int i = 0; i < lvalues.length; ++i) {
                            svalues[i] = Long.toString(lvalues[i]);
                        }
                        break block16;
                    }
                    if (values instanceof float[]) {
                        float[] fvalues = (float[])values;
                        svalues = new String[fvalues.length];
                        for (int i = 0; i < fvalues.length; ++i) {
                            svalues[i] = Float.toString(fvalues[i]);
                        }
                        break block16;
                    }
                    if (values instanceof double[]) {
                        double[] dvalues = (double[])values;
                        svalues = new String[dvalues.length];
                        for (int i = 0; i < dvalues.length; ++i) {
                            svalues[i] = Double.toString(dvalues[i]);
                        }
                        break block16;
                    }
                    if (values == null) {
                        svalues = new String[]{};
                        break block16;
                    }
                    throw new Exception();
                }
                catch (Exception e) {
                    String msg = "Parameter cannot convert " + Parameter.getTypeString(values) + " to String.";
                    throw new ParameterConvertException(msg);
                }
            }
        }
        return svalues;
    }

    private String getTypeString() {
        return Parameter.getTypeString(this._values);
    }

    private static String getTypeString(Object values) {
        if (values instanceof boolean[]) {
            return "boolean";
        }
        if (values instanceof int[]) {
            return "int";
        }
        if (values instanceof long[]) {
            return "long";
        }
        if (values instanceof float[]) {
            return "float";
        }
        if (values instanceof double[]) {
            return "double";
        }
        if (values instanceof String[]) {
            return "string";
        }
        return "null";
    }
}

