/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.CleanHandler;
import edu.mines.jtk.util.Localize;
import edu.mines.jtk.util.Monitor;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LogMonitor
implements Monitor {
    private Logger _log = null;
    private String _prefix = "";
    private volatile long _startTime = 0L;
    private volatile long _lastTime = 0L;
    private volatile long _currentTime = 0L;
    private volatile double _initFraction = 0.0;
    private volatile double _lastFraction = 0.0;
    private Thread _thread = null;
    private static final String NL = System.getProperty("line.separator");
    private static final long SHORTEST_INTERVAL = 10000L;
    private static final long LONGEST_FIRST_INTERVAL = 60000L;
    private static final long LONGEST_INTERVAL = 900000L;
    private static final Logger LOG = Logger.getLogger(LogMonitor.class.getName(), LogMonitor.class.getName());
    private boolean _debug = LOG.isLoggable(Level.FINE);

    public LogMonitor(String prefix, Logger logger) {
        this._log = logger;
        if (prefix != null) {
            this._prefix = prefix;
        }
    }

    public void initReport(double initFraction) {
        if (this._initFraction != 0.0 || initFraction < this._initFraction) {
            throw new IllegalStateException("initReport is being called twice, or with a bad value: new value of " + initFraction + " cannot replace previous value of " + this._initFraction);
        }
        this._initFraction = Math.min(0.99999, initFraction);
        this.report(initFraction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void report(double fraction) {
        fraction = (fraction - this._initFraction) / (1.0 - this._initFraction);
        LogMonitor logMonitor = this;
        synchronized (logMonitor) {
            if (fraction < this._lastFraction - 1.0E-4) {
                IllegalStateException ex = new IllegalStateException("Progress cannot decrease from " + this._lastFraction + " to " + fraction);
                if (this._debug) {
                    throw ex;
                }
                ex.printStackTrace();
                this._lastFraction = fraction;
                return;
            }
            if (this._startTime == 0L) {
                this._startTime = this._currentTime = System.currentTimeMillis();
                if (fraction < 1.0) {
                    this._thread = new UpdateTimeThread();
                    this._thread.setDaemon(true);
                    this._thread.start();
                }
                this.print(fraction, this._currentTime);
                return;
            }
            if (fraction >= 1.0) {
                if (fraction > this._lastFraction) {
                    this._currentTime = System.currentTimeMillis();
                    this.print(fraction, this._currentTime);
                }
                if (this._thread != null) {
                    this._thread.interrupt();
                    this._thread = null;
                }
                return;
            }
            boolean print = false;
            if (this._currentTime > this._lastTime + 900000L) {
                this._currentTime = System.currentTimeMillis();
                print = true;
            } else {
                boolean firstProgress;
                boolean significantProgress = fraction > this._lastFraction + 0.02 || fraction > this._lastFraction + 0.01 && this._lastFraction <= 0.02;
                boolean bl = firstProgress = this._lastFraction == 0.0 && fraction > this._lastFraction + 0.001;
                if (significantProgress || firstProgress) {
                    long interval;
                    this._currentTime = System.currentTimeMillis();
                    long l = interval = significantProgress ? 10000L : 60000L;
                    if (this._currentTime >= this._lastTime + interval) {
                        print = true;
                    }
                }
            }
            if (print) {
                this.print(fraction, this._currentTime);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(double fraction, long currentTime) {
        LogMonitor logMonitor = this;
        synchronized (logMonitor) {
            if (this._log != null) {
                this._log.info(this._prefix + LogMonitor.getProgressReport(this._startTime, currentTime, fraction, this._initFraction));
            }
            this._lastFraction = fraction;
            this._lastTime = currentTime;
        }
    }

    public static String getProgressReport(long startTime, long currentTime, double fraction, double initFraction) {
        String progress = "";
        long secSoFar = (currentTime - startTime) / 1000L;
        if (secSoFar > 0L) {
            long secRemaining;
            progress = Localize.timeWords(secSoFar) + " ${so_far}";
            long l = secRemaining = fraction > 0.0 ? (long)((1.0 / fraction - 1.0) * (double)secSoFar) : 0L;
            if (secRemaining > 0L) {
                String remaining = Localize.timeWords(secRemaining) + " ${remaining}";
                progress = progress.length() > 0 ? remaining + ", " + progress : remaining;
            }
            long total = secSoFar + secRemaining;
            if (progress.length() > 0) {
                progress = NL + "  " + progress + ", " + Localize.timeWords(total) + " ${total}";
            }
            if (fraction >= 1.0) {
                progress = NL + "  ${Finished_in} " + Localize.timeWords(total) + " ${total}";
            }
        }
        int percent = (int)(100.0 * (initFraction + fraction * (1.0 - initFraction)) + 0.49);
        String message = " ${progress}: " + percent + "% ${complete_at} " + new Date() + progress;
        message = Localize.filter(message, LogMonitor.class);
        return message;
    }

    public static void main(String[] argv) throws Exception {
        CleanHandler.setDefaultHandler();
        LogMonitor monitor = new LogMonitor("${Test}", LOG);
        int n = 25;
        int pause = 25;
        monitor.report(0.0);
        Thread.sleep(pause);
        monitor.report(0.0);
        for (int i = 0; i < n; ++i) {
            monitor.report((double)i / ((double)n - 1.0));
            Thread.sleep(pause);
        }
    }

    private class UpdateTimeThread
    extends Thread {
        public UpdateTimeThread() {
            super("LogMonitor.UpdateTimeThread " + new Date());
        }

        public void run() {
            try {
                while (LogMonitor.this._lastFraction < 0.9999) {
                    Thread.sleep(225000L);
                    LogMonitor.this._currentTime = System.currentTimeMillis();
                    if (LogMonitor.this._currentTime <= LogMonitor.this._lastTime + 1800000L) continue;
                    LogMonitor.this.print(LogMonitor.this._lastFraction, LogMonitor.this._currentTime);
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }
}

