/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Localize {
    private static final Logger LOG = Logger.getLogger(Localize.class.getName());
    private static final Pattern s_tokens = Pattern.compile("[$][{](.+?)[}]");

    public static String filter(String message, ResourceBundle catalog) {
        if (catalog == null) {
            return message;
        }
        try {
            message = catalog.getString(message);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        Matcher matcher = s_tokens.matcher(message);
        int numberMatches = 0;
        while (matcher.find()) {
            ++numberMatches;
        }
        for (int match = numberMatches; match > 0; --match) {
            matcher.reset();
            for (int i = 0; i < match; ++i) {
                matcher.find();
            }
            MatchResult mr = matcher.toMatchResult();
            try {
                String key = mr.group(1);
                String replacement = catalog.getString(key);
                int start = mr.start();
                int end = mr.end();
                message = message.substring(0, start) + replacement + message.substring(end);
                continue;
            }
            catch (MissingResourceException ex) {
                // empty catch block
            }
        }
        return message;
    }

    public static String filter(String message, Class<?> resourceClass) {
        ClassLoader cl = resourceClass.getClassLoader();
        if (cl == null) {
            LOG.warning("Could not get ClassLoader from " + resourceClass.getName());
            cl = ClassLoader.getSystemClassLoader();
        }
        Locale currentLocale = Locale.getDefault();
        String name = resourceClass.getName();
        ResourceBundle catalog = ResourceBundle.getBundle(name, currentLocale, cl);
        if (catalog == null) {
            LOG.warning("Could not get ResourceBundle " + name + " for " + currentLocale + " from " + cl);
        }
        return Localize.filter(message, catalog);
    }

    public static String timeWords(long seconds) {
        if (seconds == 0L) {
            return Localize.filter("0 ${seconds}", Localize.class);
        }
        String result = "";
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        seconds %= 60L;
        minutes %= 60L;
        hours %= 24L;
        if (days >= 10L) {
            if (hours >= 12L) {
                ++days;
            }
            seconds = 0L;
            minutes = 0L;
            hours = 0L;
        } else if (hours >= 10L || days > 0L) {
            if (minutes >= 30L) {
                days += ++hours / 24L;
                hours %= 24L;
            }
            seconds = 0L;
            minutes = 0L;
        } else if (minutes >= 10L || hours > 0L) {
            if (seconds >= 30L) {
                hours += ++minutes / 60L;
                minutes %= 60L;
            }
            seconds = 0L;
        }
        if (seconds != 0L) {
            result = " " + seconds + " ${second" + (seconds > 1L ? "s}" : "}") + result;
        }
        if (minutes != 0L) {
            result = " " + minutes + " ${minute" + (minutes > 1L ? "s}" : "}") + result;
        }
        if (hours != 0L) {
            result = " " + hours + " ${hour" + (hours > 1L ? "s}" : "}") + result;
        }
        if (days != 0L) {
            result = " " + days + " ${day" + (days > 1L ? "s}" : "}") + result;
        }
        return Localize.filter(result.trim(), Localize.class);
    }
}

