/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class Direct {
    public static ByteBuffer newByteBuffer(int capacity) {
        ByteBuffer b = null;
        try {
            b = ByteBuffer.allocateDirect(capacity);
        }
        catch (OutOfMemoryError e1) {
            System.gc();
            try {
                b = ByteBuffer.allocateDirect(capacity);
            }
            catch (OutOfMemoryError e2) {
                throw new OutOfMemoryError("cannot allocate direct buffer");
            }
        }
        b.order(ByteOrder.nativeOrder());
        return b;
    }

    public static ByteBuffer newByteBuffer(byte[] a) {
        ByteBuffer b = Direct.newByteBuffer(a.length);
        b.put(a);
        b.flip();
        return b;
    }

    public static DoubleBuffer newDoubleBuffer(int capacity) {
        return Direct.newByteBuffer(8 * capacity).asDoubleBuffer();
    }

    public static DoubleBuffer newDoubleBuffer(double[] a) {
        DoubleBuffer b = Direct.newDoubleBuffer(a.length);
        b.put(a);
        b.flip();
        return b;
    }

    public static FloatBuffer newFloatBuffer(int capacity) {
        return Direct.newByteBuffer(4 * capacity).asFloatBuffer();
    }

    public static FloatBuffer newFloatBuffer(float[] a) {
        FloatBuffer b = Direct.newFloatBuffer(a.length);
        b.put(a);
        b.flip();
        return b;
    }

    public static IntBuffer newIntBuffer(int capacity) {
        return Direct.newByteBuffer(4 * capacity).asIntBuffer();
    }

    public static IntBuffer newIntBuffer(int[] a) {
        IntBuffer b = Direct.newIntBuffer(a.length);
        b.put(a);
        b.flip();
        return b;
    }

    public static LongBuffer newLongBuffer(int capacity) {
        return Direct.newByteBuffer(8 * capacity).asLongBuffer();
    }

    public static LongBuffer newLongBuffer(long[] a) {
        LongBuffer b = Direct.newLongBuffer(a.length);
        b.put(a);
        b.flip();
        return b;
    }

    public static ShortBuffer newShortBuffer(int capacity) {
        return Direct.newByteBuffer(2 * capacity).asShortBuffer();
    }

    public static ShortBuffer newShortBuffer(short[] a) {
        ShortBuffer b = Direct.newShortBuffer(a.length);
        b.put(a);
        b.flip();
        return b;
    }
}

