/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.Array;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.MathPlus;

public class CubicInterpolator {
    private static final float FLT_O2 = 0.5f;
    private static final float FLT_O6 = 0.16666667f;
    private int _index;
    private float[] _xd;
    private float[][] _yd;

    public CubicInterpolator(Method method, int n, float[] x, float[] y) {
        Check.argument(Array.isMonotonic(x), "array x is monotonic");
        this._xd = new float[n];
        this._yd = new float[n][4];
        for (int i = 0; i < n; ++i) {
            this._xd[i] = x[i];
            this._yd[i][0] = y[i];
        }
        if (method == Method.LINEAR) {
            this.initLinear(n, this._xd, this._yd);
        } else if (method == Method.MONOTONIC) {
            this.initMonotonic(n, this._xd, this._yd);
        } else if (method == Method.SPLINE) {
            this.initSpline(n, this._xd, this._yd);
        } else assert (false);
    }

    public final float interpolate(float x) {
        int i = this.index(x);
        float[] yd = this._yd[i];
        float delx = x - this._xd[i];
        return yd[0] + delx * (yd[1] + delx * (yd[2] * 0.5f + delx * (yd[3] * 0.16666667f)));
    }

    public final float interpolate1(float x) {
        int i = this.index(x);
        float[] yd = this._yd[i];
        float delx = x - this._xd[i];
        return yd[1] + delx * (yd[2] + delx * (yd[3] * 0.5f));
    }

    public final float interpolate2(float x) {
        int i = this.index(x);
        float[] yd = this._yd[i];
        float delx = x - this._xd[i];
        return yd[2] + delx * yd[3];
    }

    public final float interpolate3(float x) {
        int i = this.index(x);
        float[] yd = this._yd[i];
        return yd[3];
    }

    public void interpolate(int n, float[] x, float[] y) {
        for (int i = 0; i < n; ++i) {
            y[i] = this.interpolate(x[i]);
        }
    }

    public void interpolate1(int n, float[] x, float[] y) {
        for (int i = 0; i < n; ++i) {
            y[i] = this.interpolate1(x[i]);
        }
    }

    public void interpolate2(int n, float[] x, float[] y) {
        for (int i = 0; i < n; ++i) {
            y[i] = this.interpolate2(x[i]);
        }
    }

    public void interpolate3(int n, float[] x, float[] y) {
        for (int i = 0; i < n; ++i) {
            y[i] = this.interpolate3(x[i]);
        }
    }

    private int index(float x) {
        int index = Array.binarySearch(this._xd, x, this._index);
        if (index < 0) {
            index = index < -1 ? -2 - index : 0;
        }
        this._index = index;
        return index;
    }

    private void initLinear(int n, float[] x, float[][] y) {
        if (n == 1) {
            y[0][1] = 0.0f;
            y[0][2] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        for (int i = 0; i < n - 1; ++i) {
            y[i][1] = (y[i + 1][0] - y[i][0]) / (x[i + 1] - x[i]);
            y[i][3] = 0.0f;
            y[i][2] = 0.0f;
        }
        y[n - 1][1] = y[n - 2][1];
        y[n - 1][3] = 0.0f;
        y[n - 1][2] = 0.0f;
    }

    private void initMonotonic(int n, float[] x, float[][] y) {
        int i;
        float dmax;
        if (n == 1) {
            y[0][1] = 0.0f;
            y[0][2] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        if (n == 2) {
            float f = (y[1][0] - y[0][0]) / (x[1] - x[0]);
            y[1][1] = f;
            y[0][1] = f;
            y[1][2] = 0.0f;
            y[0][2] = 0.0f;
            y[1][3] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        float h1 = x[1] - x[0];
        float h2 = x[2] - x[1];
        float hsum = h1 + h2;
        float del1 = (y[1][0] - y[0][0]) / h1;
        float del2 = (y[2][0] - y[1][0]) / h2;
        float w1 = (h1 + hsum) / hsum;
        float w2 = -h1 / hsum;
        y[0][1] = w1 * del1 + w2 * del2;
        if (y[0][1] * del1 <= 0.0f) {
            y[0][1] = 0.0f;
        } else if (del1 * del2 < 0.0f) {
            dmax = 3.0f * del1;
            if (MathPlus.abs(y[0][1]) > MathPlus.abs(dmax)) {
                y[0][1] = dmax;
            }
        }
        for (i = 1; i < n - 1; ++i) {
            h1 = x[i] - x[i - 1];
            h2 = x[i + 1] - x[i];
            hsum = h1 + h2;
            del1 = (y[i][0] - y[i - 1][0]) / h1;
            del2 = (y[i + 1][0] - y[i][0]) / h2;
            if (del1 * del2 <= 0.0f) {
                y[i][1] = 0.0f;
                continue;
            }
            float hsum3 = hsum + hsum + hsum;
            w1 = (hsum + h1) / hsum3;
            w2 = (hsum + h2) / hsum3;
            float dmin = MathPlus.min(MathPlus.abs(del1), MathPlus.abs(del2));
            dmax = MathPlus.max(MathPlus.abs(del1), MathPlus.abs(del2));
            float drat1 = del1 / dmax;
            float drat2 = del2 / dmax;
            y[i][1] = dmin / (w1 * drat1 + w2 * drat2);
        }
        w1 = -h2 / hsum;
        w2 = (h2 + hsum) / hsum;
        y[n - 1][1] = w1 * del1 + w2 * del2;
        if (y[n - 1][1] * del2 <= 0.0f) {
            y[n - 1][1] = 0.0f;
        } else if (del1 * del2 < 0.0f) {
            dmax = 3.0f * del2;
            if (MathPlus.abs(y[n - 1][1]) > MathPlus.abs(dmax)) {
                y[n - 1][1] = dmax;
            }
        }
        for (i = 0; i < n - 1; ++i) {
            h2 = x[i + 1] - x[i];
            del2 = (y[i + 1][0] - y[i][0]) / h2;
            float divdf3 = y[i][1] + y[i + 1][1] - 2.0f * del2;
            y[i][2] = 2.0f * (del2 - y[i][1] - divdf3) / h2;
            y[i][3] = divdf3 / h2 * (6.0f / h2);
        }
        y[n - 1][2] = y[n - 2][2] + (x[n - 1] - x[n - 2]) * y[n - 2][3];
        y[n - 1][3] = y[n - 2][3];
    }

    private void initSpline(int n, float[] x, float[][] y) {
        int i;
        float dmax;
        if (n == 1) {
            y[0][1] = 0.0f;
            y[0][2] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        if (n == 2) {
            float f = (y[1][0] - y[0][0]) / (x[1] - x[0]);
            y[1][1] = f;
            y[0][1] = f;
            y[1][2] = 0.0f;
            y[0][2] = 0.0f;
            y[1][3] = 0.0f;
            y[0][3] = 0.0f;
            return;
        }
        float h1 = x[1] - x[0];
        float h2 = x[2] - x[1];
        float hsum = h1 + h2;
        float w1 = (h1 + hsum) / hsum;
        float del1 = (y[1][0] - y[0][0]) / h1;
        float w2 = -h1 / hsum;
        float del2 = (y[2][0] - y[1][0]) / h2;
        float sleft = w1 * del1 + w2 * del2;
        if (sleft * del1 <= 0.0f) {
            sleft = 0.0f;
        } else if (del1 * del2 < 0.0f) {
            dmax = 3.0f * del1;
            if (MathPlus.abs(sleft) > MathPlus.abs(dmax)) {
                sleft = dmax;
            }
        }
        h1 = x[n - 2] - x[n - 3];
        h2 = x[n - 1] - x[n - 2];
        hsum = h1 + h2;
        del1 = (y[n - 2][0] - y[n - 3][0]) / h1;
        del2 = (y[n - 1][0] - y[n - 2][0]) / h2;
        w1 = -h2 / hsum;
        w2 = (h2 + hsum) / hsum;
        float sright = w1 * del1 + w2 * del2;
        if (sright * del2 <= 0.0f) {
            sright = 0.0f;
        } else if (del1 * del2 < 0.0f) {
            dmax = 3.0f * del2;
            if (MathPlus.abs(sright) > MathPlus.abs(dmax)) {
                sright = dmax;
            }
        }
        float[] work = new float[n];
        work[0] = 1.0f;
        y[0][2] = 2.0f * sleft;
        for (i = 1; i < n - 1; ++i) {
            float alpha;
            h1 = x[i] - x[i - 1];
            h2 = x[i + 1] - x[i];
            del1 = (y[i][0] - y[i - 1][0]) / h1;
            del2 = (y[i + 1][0] - y[i][0]) / h2;
            work[i] = alpha = h2 / (h1 + h2);
            y[i][2] = 3.0f * (alpha * del1 + (1.0f - alpha) * del2);
        }
        work[n - 1] = 0.0f;
        y[n - 1][2] = 2.0f * sright;
        float t = 2.0f;
        y[0][1] = y[0][2] / t;
        for (i = 1; i < n; ++i) {
            y[i][3] = (1.0f - work[i - 1]) / t;
            t = 2.0f - work[i] * y[i][3];
            y[i][1] = (y[i][2] - work[i] * y[i - 1][1]) / t;
        }
        for (i = n - 2; i >= 0; --i) {
            float[] fArray = y[i];
            fArray[1] = fArray[1] - y[i + 1][3] * y[i + 1][1];
        }
        for (i = 0; i < n - 1; ++i) {
            h2 = x[i + 1] - x[i];
            del2 = (y[i + 1][0] - y[i][0]) / h2;
            float divdf3 = y[i][1] + y[i + 1][1] - 2.0f * del2;
            y[i][2] = 2.0f * (del2 - y[i][1] - divdf3) / h2;
            y[i][3] = divdf3 / h2 * (6.0f / h2);
        }
        y[n - 1][2] = y[n - 2][2] + (x[n - 1] - x[n - 2]) * y[n - 2][3];
        y[n - 1][3] = y[n - 2][3];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        LINEAR,
        MONOTONIC,
        SPLINE;

    }
}

