/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

import edu.mines.jtk.util.CleanFormatter;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class CleanHandler
extends Handler {
    private static List<PrintStream> s_printStreams = new LinkedList<PrintStream>();
    private static boolean s_setDefault;

    public CleanHandler() {
        this.setFormatter(new CleanFormatter());
    }

    public static void addGlobalLogFile(String fileName) throws FileNotFoundException {
        s_printStreams.add(new PrintStream(new FileOutputStream(fileName), true));
    }

    public void publish(LogRecord record) {
        if (record == null || !this.isLoggable(record)) {
            return;
        }
        String message = this.getFormatter().format(record);
        if (message == null) {
            return;
        }
        if (record.getLevel().intValue() > Level.INFO.intValue()) {
            System.err.print(message);
            System.err.flush();
        } else {
            System.out.print(message);
            System.out.flush();
        }
        for (PrintStream ps : s_printStreams) {
            ps.print(message);
        }
    }

    public void close() {
    }

    public void flush() {
    }

    public static void testLogger() {
        CleanHandler.setDefaultHandler();
        assert (null != CleanHandler.class.getResource("CleanHandler.properties"));
        assert (null != ResourceBundle.getBundle("edu.mines.jtk.util.CleanHandler")) : "can't find rb";
        Logger logger = Logger.getLogger("edu.mines.jtk.util", "edu.mines.jtk.util.CleanHandler");
        logger.severe("test a severe");
        logger.warning("test a warning");
        logger.info("test an info");
        logger.info("test a\\");
        logger.info(" continued info");
        logger.config("test an config");
        logger.fine("test a fine");
        logger.finer("test a finer");
        logger.finest("test a finest");
        logger.info("testmessage");
        logger.info("Try this:>>${testmessage}<<");
        logger.info("Try this:>>${testmessage}<< >>${testmessage}<<");
    }

    public static void main(String[] args) {
        CleanHandler.testLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setDefaultHandler() {
        Class<CleanHandler> clazz = CleanHandler.class;
        synchronized (CleanHandler.class) {
            if (s_setDefault) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (System.getProperties().getProperty("java.util.logging.config.file") == null && System.getProperties().getProperty("java.util.logging.config.class") == null) {
                try {
                    LogManager.getLogManager().readConfiguration(new ByteArrayInputStream("handlers=edu.mines.jtk.util.CleanHandler\n.level=INFO\n".getBytes()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new IllegalStateException("This should never fail " + e.getMessage());
                }
            }
            s_setDefault = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

