/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

public class Cfloat {
    public static final Cfloat FLT_I = new Cfloat(0.0f, 1.0f);
    public float r;
    public float i;

    public Cfloat() {
        this(0.0f, 0.0f);
    }

    public Cfloat(float r) {
        this(r, 0.0f);
    }

    public Cfloat(float r, float i) {
        this.r = r;
        this.i = i;
    }

    public Cfloat(Cfloat x) {
        this(x.r, x.i);
    }

    public Cfloat plus(Cfloat x) {
        return new Cfloat(this).plusEquals(x);
    }

    public Cfloat minus(Cfloat x) {
        return new Cfloat(this).minusEquals(x);
    }

    public Cfloat times(Cfloat x) {
        return new Cfloat(this).timesEquals(x);
    }

    public Cfloat over(Cfloat x) {
        return new Cfloat(this).overEquals(x);
    }

    public Cfloat plus(float x) {
        return new Cfloat(this).plusEquals(x);
    }

    public Cfloat minus(float x) {
        return new Cfloat(this).minusEquals(x);
    }

    public Cfloat times(float x) {
        return new Cfloat(this).timesEquals(x);
    }

    public Cfloat over(float x) {
        return new Cfloat(this).overEquals(x);
    }

    public Cfloat plusEquals(Cfloat x) {
        this.r += x.r;
        this.i += x.i;
        return this;
    }

    public Cfloat minusEquals(Cfloat x) {
        this.r -= x.r;
        this.i -= x.i;
        return this;
    }

    public Cfloat timesEquals(Cfloat x) {
        float tr = this.r;
        float ti = this.i;
        float xr = x.r;
        float xi = x.i;
        this.r = tr * xr - ti * xi;
        this.i = tr * xi + ti * xr;
        return this;
    }

    public Cfloat overEquals(Cfloat x) {
        float tr = this.r;
        float ti = this.i;
        float xr = x.r;
        float xi = x.i;
        float d = Cfloat.norm(x);
        this.r = (tr * xr + ti * xi) / d;
        this.i = (ti * xr - tr * xi) / d;
        return this;
    }

    public Cfloat plusEquals(float x) {
        this.r += x;
        return this;
    }

    public Cfloat minusEquals(float x) {
        this.r -= x;
        return this;
    }

    public Cfloat timesEquals(float x) {
        this.r *= x;
        this.i *= x;
        return this;
    }

    public Cfloat overEquals(float x) {
        this.r /= x;
        this.i /= x;
        return this;
    }

    public Cfloat conjEquals() {
        this.i = -this.i;
        return this;
    }

    public Cfloat invEquals() {
        this.r = -this.r;
        this.i = -this.i;
        return this;
    }

    public Cfloat negEquals() {
        float d = this.norm();
        this.r /= d;
        this.i = -this.i / d;
        return this;
    }

    public boolean isReal() {
        return this.i == 0.0f;
    }

    public boolean isImag() {
        return this.r == 0.0f;
    }

    public Cfloat conj() {
        return new Cfloat(this.r, -this.i);
    }

    public Cfloat inv() {
        float d = this.norm();
        return new Cfloat(this.r / d, -this.i / d);
    }

    public Cfloat neg() {
        return new Cfloat(-this.r, -this.i);
    }

    public float abs() {
        return Cfloat.abs(this);
    }

    public float arg() {
        return Cfloat.arg(this);
    }

    public float norm() {
        return Cfloat.norm(this);
    }

    public Cfloat sqrt() {
        return Cfloat.sqrt(this);
    }

    public Cfloat exp() {
        return Cfloat.exp(this);
    }

    public Cfloat log() {
        return Cfloat.log(this);
    }

    public Cfloat log10() {
        return Cfloat.log10(this);
    }

    public Cfloat pow(float y) {
        return Cfloat.pow(this, y);
    }

    public Cfloat pow(Cfloat y) {
        return Cfloat.pow(this, y);
    }

    public Cfloat sin() {
        return Cfloat.sin(this);
    }

    public Cfloat cos() {
        return Cfloat.cos(this);
    }

    public Cfloat tan() {
        return Cfloat.tan(this);
    }

    public Cfloat sinh() {
        return Cfloat.sinh(this);
    }

    public Cfloat cosh() {
        return Cfloat.cosh(this);
    }

    public Cfloat tanh() {
        return Cfloat.tanh(this);
    }

    public static boolean isReal(Cfloat x) {
        return x.i == 0.0f;
    }

    public static boolean isImag(Cfloat x) {
        return x.r == 0.0f;
    }

    public static Cfloat conj(Cfloat x) {
        return new Cfloat(x.r, -x.i);
    }

    public Cfloat inv(Cfloat x) {
        float d = x.norm();
        return new Cfloat(x.r / d, -x.i / d);
    }

    public static Cfloat neg(Cfloat x) {
        return new Cfloat(-x.r, -x.i);
    }

    public static Cfloat polar(float r, float a) {
        return new Cfloat(r * Cfloat.cos(a), r * Cfloat.sin(a));
    }

    public static Cfloat add(Cfloat x, Cfloat y) {
        return x.plus(y);
    }

    public static Cfloat sub(Cfloat x, Cfloat y) {
        return x.minus(y);
    }

    public static Cfloat mul(Cfloat x, Cfloat y) {
        return x.times(y);
    }

    public static Cfloat div(Cfloat x, Cfloat y) {
        return x.over(y);
    }

    public static float abs(Cfloat x) {
        float ar = Cfloat.abs(x.r);
        float ai = Cfloat.abs(x.i);
        float s = Cfloat.max(Cfloat.abs(ar), Cfloat.abs(ai));
        if (s == 0.0f) {
            return 0.0f;
        }
        return s * Cfloat.sqrt((ar /= s) * ar + (ai /= s) * ai);
    }

    public static float arg(Cfloat x) {
        return Cfloat.atan2(x.i, x.r);
    }

    public static float norm(Cfloat x) {
        return x.r * x.r + x.i * x.i;
    }

    public static Cfloat sqrt(Cfloat x) {
        if (x.r == 0.0f) {
            float t = Cfloat.sqrt(0.5f * Cfloat.abs(x.i));
            return new Cfloat(t, x.i < 0.0f ? -t : t);
        }
        float t = Cfloat.sqrt(2.0f * (Cfloat.abs(x) + Cfloat.abs(x.r)));
        float u = 0.5f * t;
        return x.r > 0.0f ? new Cfloat(u, x.i / t) : new Cfloat(Cfloat.abs(x.i) / t, x.i < 0.0f ? -u : u);
    }

    public static Cfloat exp(Cfloat x) {
        return Cfloat.polar(Cfloat.exp(x.r), x.i);
    }

    public static Cfloat log(Cfloat x) {
        return new Cfloat(Cfloat.log(Cfloat.abs(x)), Cfloat.arg(x));
    }

    public static Cfloat log10(Cfloat x) {
        return Cfloat.log(x).overEquals(Cfloat.log(10.0f));
    }

    public static Cfloat pow(Cfloat x, float y) {
        if (x.i == 0.0f) {
            return new Cfloat(Cfloat.pow(x.r, y));
        }
        Cfloat t = Cfloat.log(x);
        return Cfloat.polar(Cfloat.exp(y * t.r), y * t.i);
    }

    public static Cfloat pow(float x, Cfloat y) {
        if (x == 0.0f) {
            return new Cfloat();
        }
        return Cfloat.polar(Cfloat.pow(x, y.r), y.i * Cfloat.log(x));
    }

    public static Cfloat pow(Cfloat x, Cfloat y) {
        if (x.r == 0.0f && x.i == 0.0f) {
            return new Cfloat();
        }
        return Cfloat.exp(y.times(Cfloat.log(x)));
    }

    public static Cfloat sin(Cfloat x) {
        return new Cfloat(Cfloat.sin(x.r) * Cfloat.cosh(x.i), Cfloat.cos(x.r) * Cfloat.sinh(x.i));
    }

    public static Cfloat cos(Cfloat x) {
        return new Cfloat(Cfloat.cos(x.r) * Cfloat.cosh(x.i), -Cfloat.sin(x.r) * Cfloat.sinh(x.i));
    }

    public static Cfloat tan(Cfloat x) {
        return Cfloat.sin(x).overEquals(Cfloat.cos(x));
    }

    public static Cfloat sinh(Cfloat x) {
        return new Cfloat(Cfloat.sinh(x.r) * Cfloat.cos(x.i), Cfloat.cosh(x.r) * Cfloat.sin(x.i));
    }

    public static Cfloat cosh(Cfloat x) {
        return new Cfloat(Cfloat.cosh(x.r) * Cfloat.cos(x.i), Cfloat.sinh(x.r) * Cfloat.sin(x.i));
    }

    public static Cfloat tanh(Cfloat x) {
        return Cfloat.sinh(x).overEquals(Cfloat.cosh(x));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cfloat that = (Cfloat)obj;
        return this.r == that.r && this.i == that.i;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.r) ^ Float.floatToIntBits(this.i);
    }

    public String toString() {
        if (this.i == 0.0f) {
            return "(" + this.r + "+0.0i)";
        }
        if (this.i > 0.0f) {
            return "(" + this.r + "+" + this.i + "i)";
        }
        return "(" + this.r + "-" + -this.i + "i)";
    }

    private static float max(float x, float y) {
        return x >= y ? x : y;
    }

    private static float abs(float x) {
        return x >= 0.0f ? x : -x;
    }

    private static float sqrt(float x) {
        return (float)Math.sqrt(x);
    }

    private static float sin(float x) {
        return (float)Math.sin(x);
    }

    private static float cos(float x) {
        return (float)Math.cos(x);
    }

    private static float sinh(float x) {
        return (float)Math.sinh(x);
    }

    private static float cosh(float x) {
        return (float)Math.cosh(x);
    }

    private static float exp(float x) {
        return (float)Math.exp(x);
    }

    private static float log(float x) {
        return (float)Math.log(x);
    }

    private static float pow(float x, float y) {
        return (float)Math.pow(x, y);
    }

    private static float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }
}

