/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.util;

public class Cdouble {
    public static final Cdouble DBL_I = new Cdouble(0.0, 1.0);
    public double r;
    public double i;

    public Cdouble() {
        this(0.0, 0.0);
    }

    public Cdouble(double r) {
        this(r, 0.0);
    }

    public Cdouble(double r, double i) {
        this.r = r;
        this.i = i;
    }

    public Cdouble(Cdouble x) {
        this(x.r, x.i);
    }

    public Cdouble plus(Cdouble x) {
        return new Cdouble(this).plusEquals(x);
    }

    public Cdouble minus(Cdouble x) {
        return new Cdouble(this).minusEquals(x);
    }

    public Cdouble times(Cdouble x) {
        return new Cdouble(this).timesEquals(x);
    }

    public Cdouble over(Cdouble x) {
        return new Cdouble(this).overEquals(x);
    }

    public Cdouble plus(double x) {
        return new Cdouble(this).plusEquals(x);
    }

    public Cdouble minus(double x) {
        return new Cdouble(this).minusEquals(x);
    }

    public Cdouble times(double x) {
        return new Cdouble(this).timesEquals(x);
    }

    public Cdouble over(double x) {
        return new Cdouble(this).overEquals(x);
    }

    public Cdouble plusEquals(Cdouble x) {
        this.r += x.r;
        this.i += x.i;
        return this;
    }

    public Cdouble minusEquals(Cdouble x) {
        this.r -= x.r;
        this.i -= x.i;
        return this;
    }

    public Cdouble timesEquals(Cdouble x) {
        double tr = this.r;
        double ti = this.i;
        double xr = x.r;
        double xi = x.i;
        this.r = tr * xr - ti * xi;
        this.i = tr * xi + ti * xr;
        return this;
    }

    public Cdouble overEquals(Cdouble x) {
        double tr = this.r;
        double ti = this.i;
        double xr = x.r;
        double xi = x.i;
        double d = Cdouble.norm(x);
        this.r = (tr * xr + ti * xi) / d;
        this.i = (ti * xr - tr * xi) / d;
        return this;
    }

    public Cdouble plusEquals(double x) {
        this.r += x;
        return this;
    }

    public Cdouble minusEquals(double x) {
        this.r -= x;
        return this;
    }

    public Cdouble timesEquals(double x) {
        this.r *= x;
        this.i *= x;
        return this;
    }

    public Cdouble overEquals(double x) {
        this.r /= x;
        this.i /= x;
        return this;
    }

    public Cdouble conjEquals() {
        this.i = -this.i;
        return this;
    }

    public Cdouble invEquals() {
        this.r = -this.r;
        this.i = -this.i;
        return this;
    }

    public Cdouble negEquals() {
        double d = this.norm();
        this.r /= d;
        this.i = -this.i / d;
        return this;
    }

    public boolean isReal() {
        return this.i == 0.0;
    }

    public boolean isImag() {
        return this.r == 0.0;
    }

    public Cdouble conj() {
        return new Cdouble(this.r, -this.i);
    }

    public Cdouble inv() {
        double d = this.norm();
        return new Cdouble(this.r / d, -this.i / d);
    }

    public Cdouble neg() {
        return new Cdouble(-this.r, -this.i);
    }

    public double abs() {
        return Cdouble.abs(this);
    }

    public double arg() {
        return Cdouble.arg(this);
    }

    public double norm() {
        return Cdouble.norm(this);
    }

    public Cdouble sqrt() {
        return Cdouble.sqrt(this);
    }

    public Cdouble exp() {
        return Cdouble.exp(this);
    }

    public Cdouble log() {
        return Cdouble.log(this);
    }

    public Cdouble log10() {
        return Cdouble.log10(this);
    }

    public Cdouble pow(double y) {
        return Cdouble.pow(this, y);
    }

    public Cdouble pow(Cdouble y) {
        return Cdouble.pow(this, y);
    }

    public Cdouble sin() {
        return Cdouble.sin(this);
    }

    public Cdouble cos() {
        return Cdouble.cos(this);
    }

    public Cdouble tan() {
        return Cdouble.tan(this);
    }

    public Cdouble sinh() {
        return Cdouble.sinh(this);
    }

    public Cdouble cosh() {
        return Cdouble.cosh(this);
    }

    public Cdouble tanh() {
        return Cdouble.tanh(this);
    }

    public static boolean isReal(Cdouble x) {
        return x.i == 0.0;
    }

    public static boolean isImag(Cdouble x) {
        return x.r == 0.0;
    }

    public static Cdouble conj(Cdouble x) {
        return new Cdouble(x.r, -x.i);
    }

    public Cdouble inv(Cdouble x) {
        double d = x.norm();
        return new Cdouble(x.r / d, -x.i / d);
    }

    public static Cdouble neg(Cdouble x) {
        return new Cdouble(-x.r, -x.i);
    }

    public static Cdouble polar(double r, double a) {
        return new Cdouble(r * Cdouble.cos(a), r * Cdouble.sin(a));
    }

    public static Cdouble add(Cdouble x, Cdouble y) {
        return x.plus(y);
    }

    public static Cdouble sub(Cdouble x, Cdouble y) {
        return x.minus(y);
    }

    public static Cdouble mul(Cdouble x, Cdouble y) {
        return x.times(y);
    }

    public static Cdouble div(Cdouble x, Cdouble y) {
        return x.over(y);
    }

    public static double abs(Cdouble x) {
        double ar = Cdouble.abs(x.r);
        double ai = Cdouble.abs(x.i);
        double s = Cdouble.max(Cdouble.abs(ar), Cdouble.abs(ai));
        if (s == 0.0) {
            return 0.0;
        }
        return s * Cdouble.sqrt((ar /= s) * ar + (ai /= s) * ai);
    }

    public static double arg(Cdouble x) {
        return Cdouble.atan2(x.i, x.r);
    }

    public static double norm(Cdouble x) {
        return x.r * x.r + x.i * x.i;
    }

    public static Cdouble sqrt(Cdouble x) {
        if (x.r == 0.0) {
            double t = Cdouble.sqrt(0.5 * Cdouble.abs(x.i));
            return new Cdouble(t, x.i < 0.0 ? -t : t);
        }
        double t = Cdouble.sqrt(2.0 * (Cdouble.abs(x) + Cdouble.abs(x.r)));
        double u = 0.5 * t;
        return x.r > 0.0 ? new Cdouble(u, x.i / t) : new Cdouble(Cdouble.abs(x.i) / t, x.i < 0.0 ? -u : u);
    }

    public static Cdouble exp(Cdouble x) {
        return Cdouble.polar(Cdouble.exp(x.r), x.i);
    }

    public static Cdouble log(Cdouble x) {
        return new Cdouble(Cdouble.log(Cdouble.abs(x)), Cdouble.arg(x));
    }

    public static Cdouble log10(Cdouble x) {
        return Cdouble.log(x).overEquals(Cdouble.log(10.0));
    }

    public static Cdouble pow(Cdouble x, double y) {
        if (x.i == 0.0) {
            return new Cdouble(Cdouble.pow(x.r, y));
        }
        Cdouble t = Cdouble.log(x);
        return Cdouble.polar(Cdouble.exp(y * t.r), y * t.i);
    }

    public static Cdouble pow(double x, Cdouble y) {
        if (x == 0.0) {
            return new Cdouble();
        }
        return Cdouble.polar(Cdouble.pow(x, y.r), y.i * Cdouble.log(x));
    }

    public static Cdouble pow(Cdouble x, Cdouble y) {
        if (x.r == 0.0 && x.i == 0.0) {
            return new Cdouble();
        }
        return Cdouble.exp(y.times(Cdouble.log(x)));
    }

    public static Cdouble sin(Cdouble x) {
        return new Cdouble(Cdouble.sin(x.r) * Cdouble.cosh(x.i), Cdouble.cos(x.r) * Cdouble.sinh(x.i));
    }

    public static Cdouble cos(Cdouble x) {
        return new Cdouble(Cdouble.cos(x.r) * Cdouble.cosh(x.i), -Cdouble.sin(x.r) * Cdouble.sinh(x.i));
    }

    public static Cdouble tan(Cdouble x) {
        return Cdouble.sin(x).overEquals(Cdouble.cos(x));
    }

    public static Cdouble sinh(Cdouble x) {
        return new Cdouble(Cdouble.sinh(x.r) * Cdouble.cos(x.i), Cdouble.cosh(x.r) * Cdouble.sin(x.i));
    }

    public static Cdouble cosh(Cdouble x) {
        return new Cdouble(Cdouble.cosh(x.r) * Cdouble.cos(x.i), Cdouble.sinh(x.r) * Cdouble.sin(x.i));
    }

    public static Cdouble tanh(Cdouble x) {
        return Cdouble.sinh(x).overEquals(Cdouble.cosh(x));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Cdouble that = (Cdouble)obj;
        return this.r == that.r && this.i == that.i;
    }

    public int hashCode() {
        long rbits = Double.doubleToLongBits(this.r);
        long ibits = Double.doubleToLongBits(this.i);
        return (int)(rbits ^ rbits >>> 32 ^ ibits ^ ibits >>> 32);
    }

    public String toString() {
        if (this.i == 0.0) {
            return "(" + this.r + "+0.0i)";
        }
        if (this.i > 0.0) {
            return "(" + this.r + "+" + this.i + "i)";
        }
        return "(" + this.r + "-" + -this.i + "i)";
    }

    private static double max(double x, double y) {
        return x >= y ? x : y;
    }

    private static double abs(double x) {
        return x >= 0.0 ? x : -x;
    }

    private static double sqrt(double x) {
        return Math.sqrt(x);
    }

    private static double sin(double x) {
        return Math.sin(x);
    }

    private static double cos(double x) {
        return Math.cos(x);
    }

    private static double sinh(double x) {
        return Math.sinh(x);
    }

    private static double cosh(double x) {
        return Math.cosh(x);
    }

    private static double exp(double x) {
        return Math.exp(x);
    }

    private static double log(double x) {
        return Math.log(x);
    }

    private static double pow(double x, double y) {
        return Math.pow(x, y);
    }

    private static double atan2(double y, double x) {
        return Math.atan2(y, x);
    }
}

