/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl.test;

import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.awt.ModeMenuItem;
import edu.mines.jtk.awt.ModeToggleButton;
import edu.mines.jtk.sgl.OrbitView;
import edu.mines.jtk.sgl.OrbitViewMode;
import edu.mines.jtk.sgl.SelectDragMode;
import edu.mines.jtk.sgl.View;
import edu.mines.jtk.sgl.ViewCanvas;
import edu.mines.jtk.sgl.World;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.ToolTipManager;

public class TestFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final int SIZE = 600;
    private OrbitView _view;

    public TestFrame(World world) {
        OrbitView view = world != null ? new OrbitView(world) : new OrbitView();
        view.setAxesOrientation(View.AxesOrientation.XRIGHT_YOUT_ZDOWN);
        ViewCanvas canvas = new ViewCanvas(view);
        canvas.setView(view);
        ModeManager mm = new ModeManager();
        mm.add((Component)((Object)canvas));
        OrbitViewMode ovm = new OrbitViewMode(mm);
        SelectDragMode sdm = new SelectDragMode(mm);
        JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        AbstractAction exitAction = new AbstractAction("Exit"){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        JMenuItem exitItem = fileMenu.add(exitAction);
        exitItem.setMnemonic('x');
        JMenu modeMenu = new JMenu("Mode");
        modeMenu.setMnemonic('M');
        ModeMenuItem ovmItem = new ModeMenuItem(ovm);
        modeMenu.add(ovmItem);
        ModeMenuItem sdmItem = new ModeMenuItem(sdm);
        modeMenu.add(sdmItem);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(fileMenu);
        menuBar.add(modeMenu);
        JToolBar toolBar = new JToolBar(1);
        toolBar.setRollover(true);
        ModeToggleButton ovmButton = new ModeToggleButton(ovm);
        toolBar.add(ovmButton);
        ModeToggleButton sdmButton = new ModeToggleButton(sdm);
        toolBar.add(sdmButton);
        ovm.setActive(true);
        this.setDefaultCloseOperation(3);
        this.setSize(new Dimension(600, 600));
        this.add((Component)((Object)canvas), "Center");
        this.add((Component)toolBar, "West");
        this.setJMenuBar(menuBar);
        this._view = view;
    }

    public OrbitView getOrbitView() {
        return this._view;
    }

    public static void main(String[] args) {
        TestFrame frame = new TestFrame(null);
        frame.setVisible(true);
    }
}

