/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl.test;

import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Point4;
import edu.mines.jtk.sgl.Tuple3;
import edu.mines.jtk.sgl.Tuple4;
import edu.mines.jtk.sgl.Vector3;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class MatrixPointVectorTest
extends TestCase {
    private static Random _random = new Random(314159L);
    private static final double TOLERANCE = 2.220446049250313E-14;

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(MatrixPointVectorTest.class);
        TestRunner.run((Test)suite);
    }

    public void testMatrix() {
        int ntrial = 10;
        for (int itrial = 0; itrial < ntrial; ++itrial) {
            Matrix44 i = Matrix44.identity();
            Matrix44 a = MatrixPointVectorTest.randomMatrix44();
            Matrix44 at = a.transpose();
            MatrixPointVectorTest.assertEquals(a, at.transpose());
            Matrix44 ai = a.inverse();
            MatrixPointVectorTest.assertEquals(a, ai.inverse());
            MatrixPointVectorTest.assertEquals(i, a.times(ai));
            MatrixPointVectorTest.assertEquals(i, a.transpose().timesTranspose(ai));
            MatrixPointVectorTest.assertEquals(i, a.transposeTimes(ai.transpose()));
            Matrix44 ac = new Matrix44(a);
            MatrixPointVectorTest.assertEquals(i, ac.timesEquals(ai));
            ac = new Matrix44(a);
            MatrixPointVectorTest.assertEquals(i, ac.transposeEquals().timesTranspose(ai));
            ac = new Matrix44(a);
            MatrixPointVectorTest.assertEquals(i, ac.transposeTimesEquals(ai.transpose()));
        }
    }

    public void testVector() {
        int ntrial = 10;
        for (int itrial = 0; itrial < ntrial; ++itrial) {
            Vector3 u = MatrixPointVectorTest.randomVector3();
            Vector3 v = MatrixPointVectorTest.randomVector3();
            Vector3 vc = new Vector3(v);
            MatrixPointVectorTest.assertEquals(v, v.negate().negate());
            MatrixPointVectorTest.assertEquals(v, vc.negateEquals().negateEquals());
            MatrixPointVectorTest.assertEquals(1.0, v.normalize().length());
            MatrixPointVectorTest.assertEquals(1.0, vc.normalizeEquals().length());
            MatrixPointVectorTest.assertEquals(1.0, v.normalize().lengthSquared());
            MatrixPointVectorTest.assertEquals(v.dot(v), v.lengthSquared());
            MatrixPointVectorTest.assertEquals(0.0, u.cross(v).dot(u));
            MatrixPointVectorTest.assertEquals(0.0, u.cross(v).dot(v));
        }
    }

    public void testPoint() {
        int ntrial = 10;
        for (int itrial = 0; itrial < ntrial; ++itrial) {
            Point3 p = MatrixPointVectorTest.randomPoint3();
            Point3 pc = new Point3(p);
            Vector3 v = MatrixPointVectorTest.randomVector3();
            MatrixPointVectorTest.assertEquals(p, p.plus(v).minus(v));
            MatrixPointVectorTest.assertEquals(p, pc.plusEquals(v).minusEquals(v));
            Point3 q = p.minus(v);
            MatrixPointVectorTest.assertEquals(q.distanceTo(p), v.length());
        }
    }

    public void testMatrixVector() {
        int ntrial = 10;
        for (int itrial = 0; itrial < ntrial; ++itrial) {
            Vector3 v = MatrixPointVectorTest.randomVector3();
            Matrix44 a = MatrixPointVectorTest.randomMatrix33();
            Matrix44 ata = a.transposeTimes(a);
            MatrixPointVectorTest.assertEquals(ata.times(v), a.transposeTimes(a.times(v)));
            Matrix44 aat = a.timesTranspose(a);
            MatrixPointVectorTest.assertEquals(aat.times(v), a.times(a.transposeTimes(v)));
        }
    }

    public void testMatrixPoint() {
        int ntrial = 10;
        for (int itrial = 0; itrial < ntrial; ++itrial) {
            Matrix44 a = MatrixPointVectorTest.randomMatrix33();
            Matrix44 ata = a.transposeTimes(a);
            Matrix44 aat = a.timesTranspose(a);
            Point3 p3 = MatrixPointVectorTest.randomPoint3();
            MatrixPointVectorTest.assertEquals(ata.times(p3), a.transposeTimes(a.times(p3)));
            MatrixPointVectorTest.assertEquals(aat.times(p3), a.times(a.transposeTimes(p3)));
            a = MatrixPointVectorTest.randomMatrix44();
            ata = a.transposeTimes(a);
            aat = a.timesTranspose(a);
            Point4 p4 = MatrixPointVectorTest.randomPoint4();
            MatrixPointVectorTest.assertEquals(ata.times(p4), a.transposeTimes(a.times(p4)));
            MatrixPointVectorTest.assertEquals(aat.times(p4), a.times(a.transposeTimes(p4)));
        }
    }

    private static Matrix44 randomMatrix33() {
        double[] m = new double[16];
        for (int i = 0; i < 16; ++i) {
            m[i] = _random.nextDouble();
        }
        m[0] = m[0] + 4.0;
        m[5] = m[5] + 4.0;
        m[10] = m[10] + 4.0;
        m[12] = 0.0;
        m[3] = 0.0;
        m[13] = 0.0;
        m[7] = 0.0;
        m[14] = 0.0;
        m[11] = 0.0;
        m[15] = 1.0;
        return new Matrix44(m);
    }

    private static Matrix44 randomMatrix44() {
        double[] m = new double[16];
        for (int i = 0; i < 16; ++i) {
            m[i] = _random.nextDouble();
        }
        m[0] = m[0] + 4.0;
        m[5] = m[5] + 4.0;
        m[10] = m[10] + 4.0;
        m[15] = m[15] + 4.0;
        return new Matrix44(m);
    }

    private static Point3 randomPoint3() {
        double x = _random.nextDouble();
        double y = _random.nextDouble();
        double z = _random.nextDouble();
        return new Point3(x, y, z);
    }

    private static Vector3 randomVector3() {
        double x = _random.nextDouble();
        double y = _random.nextDouble();
        double z = _random.nextDouble();
        return new Vector3(x, y, z);
    }

    private static Point4 randomPoint4() {
        double x = _random.nextDouble();
        double y = _random.nextDouble();
        double z = _random.nextDouble();
        double w = _random.nextDouble();
        return new Point4(x, y, z, w);
    }

    private static void assertEquals(Matrix44 e, Matrix44 a) {
        double[] em = e.m;
        double[] am = a.m;
        for (int i = 0; i < 16; ++i) {
            MatrixPointVectorTest.assertEquals((double)em[i], (double)am[i], (double)2.220446049250313E-14);
        }
    }

    private static void assertEquals(Tuple3 e, Tuple3 a) {
        MatrixPointVectorTest.assertEquals((double)e.x, (double)a.x, (double)2.220446049250313E-14);
        MatrixPointVectorTest.assertEquals((double)e.y, (double)a.y, (double)2.220446049250313E-14);
        MatrixPointVectorTest.assertEquals((double)e.z, (double)a.z, (double)2.220446049250313E-14);
    }

    private static void assertEquals(Tuple4 e, Tuple4 a) {
        MatrixPointVectorTest.assertEquals((double)e.x, (double)a.x, (double)2.220446049250313E-14);
        MatrixPointVectorTest.assertEquals((double)e.y, (double)a.y, (double)2.220446049250313E-14);
        MatrixPointVectorTest.assertEquals((double)e.z, (double)a.z, (double)2.220446049250313E-14);
        MatrixPointVectorTest.assertEquals((double)e.w, (double)a.w, (double)2.220446049250313E-14);
    }

    private static void assertEquals(double e, double a) {
        MatrixPointVectorTest.assertEquals((double)e, (double)a, (double)2.220446049250313E-14);
    }
}

