/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl.test;

import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.Point3;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BoundingTest
extends TestCase {
    private static Random _random = new Random(314159L);

    public static void main(String[] args) {
        TestSuite suite = new TestSuite(BoundingTest.class);
        TestRunner.run((Test)suite);
    }

    public void testBox() {
        BoundingBox bb = new BoundingBox();
        bb.expandBy(0.0, 0.0, 0.0);
        bb.expandBy(1.0, 1.0, 1.0);
        double a = 2.220446049250313E-15;
        double b = 1.0 - a;
        BoundingTest.assertTrue((boolean)bb.contains(new Point3(a, a, a)));
        BoundingTest.assertTrue((boolean)bb.contains(new Point3(a, a, b)));
        BoundingTest.assertTrue((boolean)bb.contains(new Point3(a, b, a)));
        BoundingTest.assertTrue((boolean)bb.contains(new Point3(a, b, b)));
        BoundingTest.assertTrue((boolean)bb.contains(new Point3(b, a, a)));
        BoundingTest.assertTrue((boolean)bb.contains(new Point3(b, a, b)));
        BoundingTest.assertTrue((boolean)bb.contains(new Point3(b, b, a)));
        BoundingTest.assertTrue((boolean)bb.contains(new Point3(b, b, b)));
        a = -2.220446049250313E-15;
        b = 1.0 - a;
        BoundingTest.assertTrue((!bb.contains(new Point3(a, a, a)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bb.contains(new Point3(a, a, b)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bb.contains(new Point3(a, b, a)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bb.contains(new Point3(a, b, b)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bb.contains(new Point3(b, a, a)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bb.contains(new Point3(b, a, b)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bb.contains(new Point3(b, b, a)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bb.contains(new Point3(b, b, b)) ? 1 : 0) != 0);
    }

    public void testBoxExpand() {
        int ntrial = 100;
        for (int itrial = 0; itrial < ntrial; ++itrial) {
            BoundingBox bb = new BoundingBox();
            BoundingTest.assertTrue((boolean)bb.isEmpty());
            int nexpand = 100;
            for (int iexpand = 0; iexpand < nexpand; ++iexpand) {
                Point3 c = BoundingTest.randomPoint3();
                double r = BoundingTest.randomDouble();
                BoundingSphere bs = new BoundingSphere(c, r);
                bb.expandBy(bs);
                BoundingTest.assertTrue((!bb.isEmpty() ? 1 : 0) != 0);
                int npoint = 100;
                for (int ipoint = 0; ipoint < npoint; ++ipoint) {
                    Point3 p = BoundingTest.randomPoint3();
                    if (!bs.contains(p)) continue;
                    BoundingTest.assertTrue((boolean)bb.contains(p));
                }
            }
        }
    }

    public void testSphere() {
        BoundingSphere bs = new BoundingSphere();
        bs.expandBy(0.0, 0.0, 0.0);
        bs.expandBy(1.0, 1.0, 1.0);
        double a = 2.220446049250313E-15;
        double b = 1.0 - a;
        BoundingTest.assertTrue((boolean)bs.contains(new Point3(a, a, a)));
        BoundingTest.assertTrue((boolean)bs.contains(new Point3(a, a, b)));
        BoundingTest.assertTrue((boolean)bs.contains(new Point3(a, b, a)));
        BoundingTest.assertTrue((boolean)bs.contains(new Point3(a, b, b)));
        BoundingTest.assertTrue((boolean)bs.contains(new Point3(b, a, a)));
        BoundingTest.assertTrue((boolean)bs.contains(new Point3(b, a, b)));
        BoundingTest.assertTrue((boolean)bs.contains(new Point3(b, b, a)));
        BoundingTest.assertTrue((boolean)bs.contains(new Point3(b, b, b)));
        a = -2.220446049250313E-15;
        b = 1.0 - a;
        BoundingTest.assertTrue((!bs.contains(new Point3(a, a, a)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bs.contains(new Point3(a, a, b)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bs.contains(new Point3(a, b, a)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bs.contains(new Point3(a, b, b)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bs.contains(new Point3(b, a, a)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bs.contains(new Point3(b, a, b)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bs.contains(new Point3(b, b, a)) ? 1 : 0) != 0);
        BoundingTest.assertTrue((!bs.contains(new Point3(b, b, b)) ? 1 : 0) != 0);
    }

    public void testSphereExpand() {
        int ntrial = 100;
        for (int itrial = 0; itrial < ntrial; ++itrial) {
            BoundingSphere bs = new BoundingSphere();
            BoundingTest.assertTrue((boolean)bs.isEmpty());
            int nexpand = 100;
            for (int iexpand = 0; iexpand < nexpand; ++iexpand) {
                Point3 p = BoundingTest.randomPoint3();
                Point3 q = BoundingTest.randomPoint3();
                BoundingBox bb = new BoundingBox(p, q);
                if (BoundingTest.randomDouble() > 0.5) {
                    bs.expandBy(bb);
                } else {
                    bs.expandRadiusBy(bb);
                }
                BoundingTest.assertTrue((!bs.isEmpty() ? 1 : 0) != 0);
                int npoint = 100;
                for (int ipoint = 0; ipoint < npoint; ++ipoint) {
                    Point3 r = BoundingTest.randomPoint3();
                    if (!bb.contains(r)) continue;
                    BoundingTest.assertTrue((boolean)bs.contains(r));
                }
            }
        }
    }

    private static double randomDouble() {
        return _random.nextDouble();
    }

    private static Point3 randomPoint3() {
        double x = _random.nextDouble();
        double y = _random.nextDouble();
        double z = _random.nextDouble();
        return new Point3(x, y, z);
    }
}

