/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl.test;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedFrame;
import edu.mines.jtk.sgl.AxisAlignedQuad;
import edu.mines.jtk.sgl.ImagePanel;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.World;
import edu.mines.jtk.sgl.test.TestFrame;
import edu.mines.jtk.util.MathPlus;
import edu.mines.jtk.util.SimpleFloat3;

public class AxisAlignedQuadTest {
    public static void main(String[] args) {
        double dx;
        int nx = 101;
        int ny = 121;
        int nz = 141;
        double dy = dx = 1.0 / (double)(nx - 1);
        double dz = dx;
        double fx = 0.0;
        double fy = 0.0;
        double fz = 0.0;
        double lx = fx + (double)(nx - 1) * dx;
        double ly = fy + (double)(ny - 1) * dy;
        double lz = fz + (double)(nz - 1) * dz;
        Point3 qmin = new Point3(fx, fy, fz);
        Point3 qmax = new Point3(lx, ly, lz);
        AxisAlignedQuad aaq = new AxisAlignedQuad(Axis.Y, qmin, qmax);
        AxisAlignedFrame aaf = aaq.getFrame();
        Sampling sx = new Sampling(nx, dx, fx);
        Sampling sy = new Sampling(ny, dy, fy);
        Sampling sz = new Sampling(nz, dz, fz);
        float[][][] a = new float[nx][ny][nz];
        for (int ix = 0; ix < nx; ++ix) {
            float x = (float)((double)ix * dx);
            for (int iy = 0; iy < ny; ++iy) {
                float y = (float)((double)iy * dy);
                for (int iz = 0; iz < nz; ++iz) {
                    float z = (float)((double)iz * dz);
                    a[ix][iy][iz] = MathPlus.sin((float)Math.PI * 4 * (x + y + z));
                }
            }
        }
        SimpleFloat3 f3 = new SimpleFloat3(a);
        ImagePanel iop = new ImagePanel(sx, sy, sz, f3);
        aaf.addChild(iop);
        World world = new World();
        world.addChild(aaq);
        TestFrame frame = new TestFrame(world);
        frame.setVisible(true);
    }
}

