/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.Tuple3;
import edu.mines.jtk.sgl.ViewCanvas;
import edu.mines.jtk.sgl.World;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class View {
    private World _world;
    private Matrix44 _worldToView = Matrix44.identity();
    private ArrayList<ViewCanvas> _canvasList = new ArrayList(1);
    private Tuple3 _axesScale = new Tuple3(1.0, 1.0, 1.0);
    private AxesOrientation _axesOrientation = AxesOrientation.XRIGHT_YUP_ZOUT;

    public AxesOrientation getAxesOrientation() {
        return this._axesOrientation;
    }

    public void setAxesOrientation(AxesOrientation axesOrientation) {
        this._axesOrientation = axesOrientation;
        this.updateTransforms();
        this.repaint();
    }

    public Tuple3 getAxesScale() {
        return new Tuple3(this._axesScale);
    }

    public void setAxesScale(Tuple3 s) {
        this.setAxesScale(s.x, s.y, s.z);
    }

    public void setAxesScale(double sx, double sy, double sz) {
        this._axesScale = new Tuple3(sx, sy, sz);
        this.updateTransforms();
        this.repaint();
    }

    public View() {
    }

    public View(World world) {
        this.setWorld(world);
    }

    public void setWorld(World world) {
        if (this._world != null) {
            this._world.removeView(this);
        }
        this._world = world;
        if (this._world != null) {
            this._world.addView(this);
        }
        this.updateTransforms();
        this.repaint();
    }

    public World getWorld() {
        return this._world;
    }

    public void setWorldToView(Matrix44 worldToView) {
        this._worldToView = new Matrix44(worldToView);
        this.repaint();
    }

    public Matrix44 getWorldToView() {
        return new Matrix44(this._worldToView);
    }

    public int countCanvases() {
        return this._canvasList.size();
    }

    public Iterator<ViewCanvas> getCanvases() {
        return this._canvasList.iterator();
    }

    public void updateTransforms() {
        for (ViewCanvas canvas : this._canvasList) {
            this.updateTransforms(canvas);
        }
    }

    public void repaint() {
        for (ViewCanvas canvas : this._canvasList) {
            canvas.repaint();
        }
    }

    protected abstract void updateTransforms(ViewCanvas var1);

    protected abstract void draw(ViewCanvas var1);

    boolean addCanvas(ViewCanvas canvas) {
        if (!this._canvasList.contains((Object)canvas)) {
            this._canvasList.add(canvas);
            this.updateTransforms();
            this.repaint();
            return true;
        }
        return false;
    }

    boolean removeCanvas(ViewCanvas canvas) {
        if (this._canvasList.remove((Object)canvas)) {
            this.updateTransforms();
            this.repaint();
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AxesOrientation {
        XRIGHT_YUP_ZOUT,
        XRIGHT_YOUT_ZDOWN,
        XRIGHT_YIN_ZDOWN,
        XOUT_YRIGHT_ZUP;

    }
}

