/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingBoxTree;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.PickContext;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Segment;
import edu.mines.jtk.sgl.Selectable;
import edu.mines.jtk.util.Direct;
import java.nio.FloatBuffer;
import java.util.HashMap;

public class TriangleGroup
extends Group
implements Selectable {
    private static final int I = 0;
    private static final int J = 1;
    private static final int K = 2;
    private static final int X = 0;
    private static final int Y = 1;
    private static final int Z = 2;
    private static final int U = 0;
    private static final int V = 1;
    private static final int W = 2;
    private static final int R = 0;
    private static final int G = 1;
    private static final int B = 2;
    private static final int MIN_TRI_PER_NODE = 1024;

    public TriangleGroup(boolean vn, float[] xyz) {
        this(vn, xyz, null);
    }

    public TriangleGroup(boolean vn, float[] xyz, float[] rgb) {
        int[] ijk = TriangleGroup.indexVertices(!vn, xyz);
        float[] uvw = TriangleGroup.computeNormals(ijk, xyz);
        this.buildTree(ijk, xyz, uvw, rgb);
    }

    public TriangleGroup(int[] ijk, float[] xyz) {
        this(ijk, xyz, null);
    }

    public TriangleGroup(int[] ijk, float[] xyz, float[] rgb) {
        float[] uvw = TriangleGroup.computeNormals(ijk, xyz);
        this.buildTree(ijk, xyz, uvw, rgb);
    }

    public static int[] indexVertices(boolean sequential, float[] xyz) {
        int nv = xyz.length / 3;
        int nt = nv / 3;
        int[] ijk = new int[nv];
        if (sequential) {
            for (int iv = 0; iv < nv; ++iv) {
                ijk[iv] = iv;
            }
        } else {
            HashMap<Vertex, Integer> vimap = new HashMap<Vertex, Integer>(nv);
            for (int it = 0; it < nt; ++it) {
                int iv = 0;
                int jv = 3 * it;
                int kv = 3 * jv;
                while (iv < 3) {
                    Vertex v = new Vertex(xyz[kv + 0], xyz[kv + 1], xyz[kv + 2]);
                    Integer i = (Integer)vimap.get(v);
                    if (i == null) {
                        i = new Integer(jv);
                        vimap.put(v, i);
                    }
                    ijk[jv] = i;
                    ++iv;
                    ++jv;
                    kv += 3;
                }
            }
        }
        return ijk;
    }

    protected void selectedChanged() {
        System.out.println("TriangleGroup: " + this + " selected=" + this.isSelected());
        this.dirtyDraw();
    }

    private void buildTree(int[] ijk, float[] xyz, float[] uvw, float[] rgb) {
        float[] c = this.computeCenters(ijk, xyz);
        BoundingBoxTree bbt = new BoundingBoxTree(1024, c);
        this.buildTree(this, bbt.getRoot(), ijk, xyz, uvw, rgb);
    }

    private void buildTree(Group parent, BoundingBoxTree.Node bbtNode, int[] ijk, float[] xyz, float[] uvw, float[] rgb) {
        if (bbtNode.isLeaf()) {
            TriangleNode tn = new TriangleNode(bbtNode, ijk, xyz, uvw, rgb);
            parent.addChild(tn);
        } else {
            Group group = new Group();
            parent.addChild(group);
            this.buildTree(group, bbtNode.getLeft(), ijk, xyz, uvw, rgb);
            this.buildTree(group, bbtNode.getRight(), ijk, xyz, uvw, rgb);
        }
    }

    private static float[] computeNormals(int[] ijk, float[] xyz) {
        int nv = xyz.length / 3;
        int nt = ijk.length / 3;
        float[] uvw = new float[3 * nv];
        int jt = 0;
        for (int it = 0; it < nt; ++it) {
            int i = 3 * ijk[jt++];
            int j = 3 * ijk[jt++];
            int k = 3 * ijk[jt++];
            float xi = xyz[i + 0];
            float yi = xyz[i + 1];
            float zi = xyz[i + 2];
            float xj = xyz[j + 0];
            float yj = xyz[j + 1];
            float zj = xyz[j + 2];
            float xk = xyz[k + 0];
            float yk = xyz[k + 1];
            float zk = xyz[k + 2];
            float xa = xj - xi;
            float ya = yj - yi;
            float za = zj - zi;
            float xb = xk - xi;
            float yb = yk - yi;
            float zb = zk - zi;
            float un = ya * zb - yb * za;
            float vn = za * xb - zb * xa;
            float wn = xa * yb - xb * ya;
            int n = i + 0;
            uvw[n] = uvw[n] + un;
            int n2 = i + 1;
            uvw[n2] = uvw[n2] + vn;
            int n3 = i + 2;
            uvw[n3] = uvw[n3] + wn;
            int n4 = j + 0;
            uvw[n4] = uvw[n4] + un;
            int n5 = j + 1;
            uvw[n5] = uvw[n5] + vn;
            int n6 = j + 2;
            uvw[n6] = uvw[n6] + wn;
            int n7 = k + 0;
            uvw[n7] = uvw[n7] + un;
            int n8 = k + 1;
            uvw[n8] = uvw[n8] + vn;
            int n9 = k + 2;
            uvw[n9] = uvw[n9] + wn;
        }
        return uvw;
    }

    private float[] computeCenters(int[] ijk, float[] xyz) {
        int nt = ijk.length / 3;
        float[] c = new float[3 * nt];
        float o3 = 0.33333334f;
        int jt = 0;
        int jc = 0;
        for (int it = 0; it < nt; ++it) {
            int i = 3 * ijk[jt++];
            int j = 3 * ijk[jt++];
            int k = 3 * ijk[jt++];
            float xi = xyz[i + 0];
            float yi = xyz[i + 1];
            float zi = xyz[i + 2];
            float xj = xyz[j + 0];
            float yj = xyz[j + 1];
            float zj = xyz[j + 2];
            float xk = xyz[k + 0];
            float yk = xyz[k + 1];
            float zk = xyz[k + 2];
            c[jc++] = (xi + xj + xk) * o3;
            c[jc++] = (yi + yj + yk) * o3;
            c[jc++] = (zi + zj + zk) * o3;
        }
        return c;
    }

    private static class Vertex {
        float x;
        float y;
        float z;

        Vertex(float x, float y, float z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            Vertex v = (Vertex)o;
            return this.x == v.x && this.y == v.y && this.z == v.z;
        }

        public int hashCode() {
            return Float.floatToIntBits(this.x) ^ Float.floatToIntBits(this.y) ^ Float.floatToIntBits(this.z);
        }
    }

    private class TriangleNode
    extends Node {
        private BoundingSphere _bs;
        private int _nt;
        private FloatBuffer _vb;
        private FloatBuffer _nb;
        private FloatBuffer _cb;

        public TriangleNode(BoundingBoxTree.Node bbtNode, int[] ijk, float[] xyz, float[] uvw, float[] rgb) {
            BoundingBox bb = bbtNode.getBoundingBox();
            this._bs = new BoundingSphere(bb);
            int nt = this._nt = bbtNode.getSize();
            int nv = 3 * nt;
            int nn = 3 * nt;
            int nc = 3 * nt;
            int[] index = bbtNode.getIndices();
            this._vb = Direct.newFloatBuffer(3 * nv);
            this._nb = uvw != null ? Direct.newFloatBuffer(3 * nn) : null;
            this._cb = rgb != null ? Direct.newFloatBuffer(3 * nc) : null;
            int iv = 0;
            int in = 0;
            int ic = 0;
            for (int it = 0; it < nt; ++it) {
                int jt = 3 * index[it];
                int i = 3 * ijk[jt + 0];
                int j = 3 * ijk[jt + 1];
                int k = 3 * ijk[jt + 2];
                this._vb.put(iv++, xyz[i + 0]);
                this._vb.put(iv++, xyz[i + 1]);
                this._vb.put(iv++, xyz[i + 2]);
                this._vb.put(iv++, xyz[j + 0]);
                this._vb.put(iv++, xyz[j + 1]);
                this._vb.put(iv++, xyz[j + 2]);
                this._vb.put(iv++, xyz[k + 0]);
                this._vb.put(iv++, xyz[k + 1]);
                this._vb.put(iv++, xyz[k + 2]);
                if (this._nb != null) {
                    this._nb.put(in++, uvw[i + 0]);
                    this._nb.put(in++, uvw[i + 1]);
                    this._nb.put(in++, uvw[i + 2]);
                    this._nb.put(in++, uvw[j + 0]);
                    this._nb.put(in++, uvw[j + 1]);
                    this._nb.put(in++, uvw[j + 2]);
                    this._nb.put(in++, uvw[k + 0]);
                    this._nb.put(in++, uvw[k + 1]);
                    this._nb.put(in++, uvw[k + 2]);
                }
                if (this._cb == null) continue;
                this._cb.put(ic++, rgb[i + 0]);
                this._cb.put(ic++, rgb[i + 1]);
                this._cb.put(ic++, rgb[i + 2]);
                this._cb.put(ic++, rgb[j + 0]);
                this._cb.put(ic++, rgb[j + 1]);
                this._cb.put(ic++, rgb[j + 2]);
                this._cb.put(ic++, rgb[k + 0]);
                this._cb.put(ic++, rgb[k + 1]);
                this._cb.put(ic++, rgb[k + 2]);
            }
        }

        protected BoundingSphere computeBoundingSphere(boolean finite) {
            return this._bs;
        }

        protected void draw(DrawContext dc) {
            boolean selected = TriangleGroup.this.isSelected();
            Gl.glEnableClientState(32884);
            Gl.glVertexPointer(3, 5126, 0, this._vb);
            if (this._nb != null) {
                Gl.glEnableClientState(32885);
                Gl.glNormalPointer(5126, 0, this._nb);
            }
            if (this._cb != null) {
                Gl.glEnableClientState(32886);
                Gl.glColorPointer(3, 5126, 0, this._cb);
            }
            if (selected) {
                Gl.glEnable(32823);
                Gl.glPolygonOffset(1.0f, 1.0f);
            }
            Gl.glDrawArrays(4, 0, 3 * this._nt);
            if (this._nb != null) {
                Gl.glDisableClientState(32885);
            }
            if (this._cb != null) {
                Gl.glDisableClientState(32886);
            }
            if (selected) {
                Gl.glPolygonMode(1032, 6913);
                Gl.glDisable(2896);
                Gl.glColor3d(1.0, 1.0, 1.0);
                Gl.glDrawArrays(4, 0, 3 * this._nt);
            }
            Gl.glDisableClientState(32884);
        }

        protected void pick(PickContext pc) {
            Segment ps = pc.getPickSegment();
            int jt = 0;
            for (int it = 0; it < this._nt; ++it) {
                double zk;
                double yk;
                Point3 p;
                double xi = this._vb.get(jt++);
                double yi = this._vb.get(jt++);
                double zi = this._vb.get(jt++);
                double xj = this._vb.get(jt++);
                double yj = this._vb.get(jt++);
                double zj = this._vb.get(jt++);
                double xk = this._vb.get(jt++);
                if ((p = ps.intersectWithTriangle(xi, yi, zi, xj, yj, zj, xk, yk = (double)this._vb.get(jt++), zk = (double)this._vb.get(jt++))) == null) continue;
                pc.addResult(p);
            }
        }
    }
}

