/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.awt.Mode;
import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.sgl.DragContext;
import edu.mines.jtk.sgl.Dragable;
import edu.mines.jtk.sgl.PickContext;
import edu.mines.jtk.sgl.PickResult;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Selectable;
import edu.mines.jtk.sgl.View;
import edu.mines.jtk.sgl.ViewCanvas;
import edu.mines.jtk.sgl.World;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.KeyStroke;

public class SelectDragMode
extends Mode {
    private static final long serialVersionUID = 1L;
    private ViewCanvas _canvas;
    private View _view;
    private World _world;
    private PickResult _pickResult;
    private Dragable _dragable;
    private Selectable _selectable;
    private DragContext _dragContext;
    private boolean _selecting;
    private MouseListener _ml = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            SelectDragMode.this._selecting = true;
            SelectDragMode.this._pickResult = SelectDragMode.this.pick(e);
            if (SelectDragMode.this._pickResult != null) {
                SelectDragMode.this._selectable = SelectDragMode.this._pickResult.getSelectableNode();
                SelectDragMode.this._dragable = SelectDragMode.this._pickResult.getDragableNode();
            }
            SelectDragMode.this._canvas = (ViewCanvas)((Object)e.getSource());
            SelectDragMode.this._view = SelectDragMode.this._canvas.getView();
            if (SelectDragMode.this._view != null) {
                SelectDragMode.this._world = SelectDragMode.this._view.getWorld();
            }
            SelectDragMode.this._canvas.addMouseMotionListener(SelectDragMode.this._mml);
        }

        public void mouseReleased(MouseEvent e) {
            if (SelectDragMode.this._dragContext != null) {
                SelectDragMode.this._dragable.dragEnd(SelectDragMode.this._dragContext);
            } else if (SelectDragMode.this._selecting) {
                if (e.isControlDown()) {
                    if (SelectDragMode.this._selectable != null) {
                        SelectDragMode.this._selectable.setSelected(!SelectDragMode.this._selectable.isSelected());
                    }
                } else if (e.isShiftDown()) {
                    if (SelectDragMode.this._selectable != null) {
                        SelectDragMode.this._selectable.setSelected(true);
                    }
                } else if (SelectDragMode.this._selectable != null) {
                    SelectDragMode.this._world.clearSelectedExcept(SelectDragMode.this._selectable);
                    SelectDragMode.this._selectable.setSelected(true);
                } else if (SelectDragMode.this._world != null) {
                    SelectDragMode.this._world.clearSelected();
                }
            }
            SelectDragMode.this._dragable = null;
            SelectDragMode.this._dragContext = null;
            SelectDragMode.this._selectable = null;
            SelectDragMode.this._selecting = false;
            SelectDragMode.this._canvas.removeMouseMotionListener(SelectDragMode.this._mml);
        }
    };
    private MouseMotionListener _mml = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            Point3 pd;
            Point3 pp;
            SelectDragMode.this._selecting = SelectDragMode.this._dragContext == null;
            if (SelectDragMode.this._selecting && SelectDragMode.this._pickResult != null && (pp = SelectDragMode.this._pickResult.getPointPixel()).distanceTo(pd = new Point3(e.getX(), e.getY(), pp.z)) >= 2.0) {
                SelectDragMode.this._selecting = false;
            }
            if (!SelectDragMode.this._selecting && SelectDragMode.this._dragable != null && SelectDragMode.this._dragContext == null) {
                SelectDragMode.this._dragContext = new DragContext(SelectDragMode.this._pickResult);
                SelectDragMode.this._dragable.dragBegin(SelectDragMode.this._dragContext);
            }
            if (SelectDragMode.this._dragContext != null) {
                SelectDragMode.this._dragContext.update(e);
                SelectDragMode.this._dragable.drag(SelectDragMode.this._dragContext);
            }
        }
    };

    public SelectDragMode(ModeManager modeManager) {
        super(modeManager);
        this.setName("Select");
        Class<SelectDragMode> cls = SelectDragMode.class;
        this.setIcon(SelectDragMode.loadIcon(cls, "resources/SelectDragIcon16.png"));
        this.setCursor(SelectDragMode.loadCursor(cls, "resources/SelectDragCursor16.png", 1, 1));
        this.setMnemonicKey(83);
        this.setAcceleratorKey(KeyStroke.getKeyStroke(83, 0));
        this.setShortDescription("Select/drag");
    }

    protected void setActive(Component component, boolean active) {
        if (component instanceof ViewCanvas) {
            if (active) {
                component.addMouseListener(this._ml);
            } else {
                component.removeMouseListener(this._ml);
            }
        }
    }

    private PickResult pick(MouseEvent event) {
        ViewCanvas canvas = (ViewCanvas)((Object)event.getSource());
        canvas.addMouseMotionListener(this._mml);
        View view = canvas.getView();
        if (view == null) {
            return null;
        }
        World world = view.getWorld();
        if (world == null) {
            return null;
        }
        PickContext pc = new PickContext(event);
        world.pickApply(pc);
        PickResult pickResult = pc.getClosest();
        if (pickResult != null) {
            Point3 pointLocal = pickResult.getPointLocal();
            Point3 pointWorld = pickResult.getPointWorld();
            System.out.println("Pick");
            System.out.println("  local=" + pointLocal);
            System.out.println("  world=" + pointWorld);
        } else {
            System.out.println("Pick nothing");
        }
        return pickResult;
    }
}

