/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Dragable;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.PickContext;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Selectable;
import edu.mines.jtk.sgl.View;
import edu.mines.jtk.sgl.ViewCanvas;
import edu.mines.jtk.sgl.World;
import java.awt.event.MouseEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickResult {
    private MouseEvent _event;
    private Node[] _nodes;
    private Point3 _pointLocal;
    private Point3 _pointWorld;
    private Point3 _pointPixel;
    private double _depthPixel;
    private Matrix44 _localToWorld;
    private Matrix44 _localToPixel;
    private Matrix44 _worldToPixel;

    public PickResult(PickContext pc, Point3 point) {
        this._event = pc.getMouseEvent();
        this._nodes = pc.getNodes();
        this._localToWorld = pc.getLocalToWorld();
        this._localToPixel = pc.getLocalToPixel();
        this._worldToPixel = pc.getWorldToPixel();
        this._pointLocal = new Point3(point);
        this._pointWorld = this._localToWorld.times(point);
        this._pointPixel = this._localToPixel.times(point);
        this._depthPixel = this._pointPixel.z;
    }

    public MouseEvent getMouseEvent() {
        return this._event;
    }

    public Node[] getNodes() {
        return (Node[])this._nodes.clone();
    }

    public Node getNode() {
        return this._nodes[this._nodes.length - 1];
    }

    public Dragable getDragableNode() {
        return (Dragable)((Object)this.getNode(Dragable.class));
    }

    public Selectable getSelectableNode() {
        return (Selectable)((Object)this.getNode(Selectable.class));
    }

    public Node getNode(Class<?> nodeClass) {
        for (int i = this._nodes.length - 1; i >= 0; --i) {
            Node node = this._nodes[i];
            if (!nodeClass.isAssignableFrom(node.getClass())) continue;
            return node;
        }
        return null;
    }

    public Point3 getPointLocal() {
        return new Point3(this._pointLocal);
    }

    public Point3 getPointWorld() {
        return new Point3(this._pointWorld);
    }

    public Point3 getPointPixel() {
        return new Point3(this._pointPixel);
    }

    public double getPixelZ() {
        return this._depthPixel;
    }

    public Matrix44 getLocalToWorld() {
        return new Matrix44(this._localToWorld);
    }

    public Matrix44 getLocalToPixel() {
        return new Matrix44(this._localToPixel);
    }

    public Matrix44 getWorldToPixel() {
        return new Matrix44(this._worldToPixel);
    }

    public ViewCanvas getViewCanvas() {
        return (ViewCanvas)((Object)this._event.getSource());
    }

    public View getView() {
        return this.getViewCanvas().getView();
    }

    public World getWorld() {
        return this.getView().getWorld();
    }
}

