/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.ArrayStack;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.PickResult;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Segment;
import edu.mines.jtk.sgl.TransformContext;
import edu.mines.jtk.sgl.ViewCanvas;
import java.awt.event.MouseEvent;
import java.util.ArrayList;

public class PickContext
extends TransformContext {
    private MouseEvent _event;
    private Segment _pickSegment;
    private Point3 _nearPoint;
    private Point3 _farPoint;
    private ArrayStack<Segment> _pickSegmentStack = new ArrayStack();
    private ArrayList<PickResult> _pickResults = new ArrayList();

    public PickContext(MouseEvent event) {
        super((ViewCanvas)((Object)event.getSource()));
        this._event = event;
        int xp = event.getX();
        int yp = event.getY();
        Point3 near = new Point3(xp, yp, 0.0);
        Point3 far = new Point3(xp, yp, 1.0);
        this._pickSegment = new Segment(near, far);
        this._pickSegment.transform(this.getPixelToWorld());
        this._nearPoint = this._pickSegment.getA();
        this._farPoint = this._pickSegment.getB();
    }

    public MouseEvent getMouseEvent() {
        return this._event;
    }

    public Segment getPickSegment() {
        return new Segment(this._pickSegment);
    }

    public boolean segmentIntersectsSphereOf(Node node) {
        double pz;
        double py;
        double px;
        BoundingSphere bs = node.getBoundingSphere(false);
        if (bs.isEmpty()) {
            return false;
        }
        if (bs.isInfinite()) {
            return true;
        }
        Point3 a = this._farPoint;
        Point3 b = this._nearPoint;
        Point3 c = bs.getCenter();
        double r = bs.getRadius();
        double rr = r * r;
        double cx = c.x;
        double ax = a.x;
        double cax = cx - ax;
        double bx = b.x;
        double bax = bx - ax;
        double cy = c.y;
        double ay = a.y;
        double cay = cy - ay;
        double by = b.y;
        double bay = by - ay;
        double cz = c.z;
        double az = a.z;
        double caz = cz - az;
        double bz = b.z;
        double baz = bz - az;
        double caba = cax * bax + cay * bay + caz * baz;
        if (caba <= 0.0) {
            px = ax;
            py = ay;
            pz = az;
        } else {
            double baba = bax * bax + bay * bay + baz * baz;
            if (baba <= caba) {
                px = bx;
                py = by;
                pz = bz;
            } else {
                double u = caba / baba;
                px = ax + u * bax;
                py = ay + u * bay;
                pz = az + u * baz;
            }
        }
        double dx = px - cx;
        double dy = py - cy;
        double dz = pz - cz;
        return dx * dx + dy * dy + dz * dz <= rr;
    }

    public void addResult(Point3 point) {
        if (point != null) {
            PickResult pr = new PickResult(this, point);
            this._pickResults.add(pr);
        }
    }

    public PickResult getClosest() {
        PickResult prmin = null;
        double zpmin = Double.MAX_VALUE;
        for (PickResult pr : this._pickResults) {
            double zp = pr.getPixelZ();
            if (!(zp < zpmin)) continue;
            zpmin = zp;
            prmin = pr;
        }
        return prmin;
    }

    public void pushLocalToWorld(Matrix44 transform) {
        super.pushLocalToWorld(transform);
        this._pickSegmentStack.push(new Segment(this._pickSegment));
        this._pickSegment.transform(transform.inverse());
        this._nearPoint = this._pickSegment.getA();
        this._farPoint = this._pickSegment.getB();
    }

    public void popLocalToWorld() {
        super.popLocalToWorld();
        this._pickSegment = this._pickSegmentStack.pop();
        this._nearPoint = this._pickSegment.getA();
        this._farPoint = this._pickSegment.getB();
    }
}

