/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.awt.Mode;
import edu.mines.jtk.awt.ModeManager;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.OrbitView;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Tuple3;
import edu.mines.jtk.sgl.Vector3;
import edu.mines.jtk.sgl.ViewCanvas;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseMotionListener;
import javax.swing.KeyStroke;

public class OrbitViewMode
extends Mode {
    private static final long serialVersionUID = 1L;
    private ViewCanvas _canvas;
    private OrbitView _view;
    private int _xmouse;
    private int _ymouse;
    private double _zmouse;
    private double _scale;
    private double _azimuth;
    private double _elevation;
    private Vector3 _translate;
    private Point3 _translateP;
    private Matrix44 _translateM;
    private boolean _rotating;
    private boolean _scaling;
    private boolean _translating;
    private KeyListener _kl = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            ViewCanvas canvas = (ViewCanvas)((Object)e.getSource());
            OrbitView view = (OrbitView)canvas.getView();
            int kc = e.getKeyCode();
            if (kc == 36) {
                view.reset();
            } else if (kc == 34) {
                Tuple3 s = view.getAxesScale();
                view.setAxesScale(s.x, s.y, s.z / 1.1);
            } else if (kc == 33) {
                Tuple3 s = view.getAxesScale();
                view.setAxesScale(s.x, s.y, s.z * 1.1);
            } else if (kc == 155) {
                OrbitView.Projection projection = view.getProjection();
                if (projection == OrbitView.Projection.ORTHOGRAPHIC) {
                    projection = OrbitView.Projection.PERSPECTIVE;
                } else if (projection == OrbitView.Projection.PERSPECTIVE) {
                    projection = OrbitView.Projection.ORTHOGRAPHIC;
                }
                view.setProjection(projection);
            } else if (e.isControlDown()) {
                double scale = view.getScale();
                if (kc == 38) {
                    scale *= 0.9;
                } else if (kc == 40) {
                    scale *= 1.1;
                }
                view.setScale(scale);
            } else if (e.isShiftDown()) {
                Matrix44 viewToCube = OrbitViewMode.this._canvas.getViewToCube();
                Matrix44 unitSphereToView = OrbitViewMode.this._view.getUnitSphereToView();
                Matrix44 unitSphereToCube = viewToCube.times(unitSphereToView);
                Matrix44 cubeToUnitSphere = unitSphereToCube.inverse();
                Vector3 translate = view.getTranslate();
                Matrix44 m = Matrix44.translate(translate).times(cubeToUnitSphere);
                double xc = 0.0;
                double yc = 0.0;
                double zc = 0.0;
                Point3 c1 = new Point3(xc, yc, zc);
                if (kc == 37) {
                    xc -= 0.05;
                } else if (kc == 39) {
                    xc += 0.05;
                } else if (kc == 38) {
                    yc += 0.05;
                } else if (kc == 40) {
                    yc -= 0.05;
                }
                Point3 c2 = new Point3(xc, yc, zc);
                translate.plusEquals(m.times(c2).minus(m.times(c1)));
                view.setTranslate(translate);
            } else {
                double azimuth = view.getAzimuth();
                double elevation = view.getElevation();
                if (kc == 37) {
                    azimuth += 5.0;
                } else if (kc == 39) {
                    azimuth -= 5.0;
                } else if (kc == 38) {
                    elevation -= 5.0;
                } else if (kc == 40) {
                    elevation += 5.0;
                }
                view.setAzimuthAndElevation(azimuth, elevation);
            }
        }
    };
    private MouseListener _ml = new MouseAdapter(){

        public void mousePressed(MouseEvent e) {
            if (e.isControlDown()) {
                OrbitViewMode.this.beginScale(e);
                OrbitViewMode.this._scaling = true;
            } else if (e.isShiftDown()) {
                OrbitViewMode.this.beginTranslate(e);
                OrbitViewMode.this._translating = true;
            } else {
                OrbitViewMode.this.beginRotate(e);
                OrbitViewMode.this._rotating = true;
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (OrbitViewMode.this._scaling) {
                OrbitViewMode.this.endScale(e);
                OrbitViewMode.this._scaling = false;
            } else if (OrbitViewMode.this._translating) {
                OrbitViewMode.this.endTranslate(e);
                OrbitViewMode.this._translating = false;
            } else if (OrbitViewMode.this._rotating) {
                OrbitViewMode.this.endRotate(e);
                OrbitViewMode.this._rotating = false;
            }
        }
    };
    private MouseMotionListener _mml = new MouseMotionAdapter(){

        public void mouseDragged(MouseEvent e) {
            if (OrbitViewMode.this._scaling) {
                OrbitViewMode.this.duringScale(e);
            } else if (OrbitViewMode.this._translating) {
                OrbitViewMode.this.duringTranslate(e);
            } else if (OrbitViewMode.this._rotating) {
                OrbitViewMode.this.duringRotate(e);
            }
        }
    };

    public OrbitViewMode(ModeManager modeManager) {
        super(modeManager);
        this.setName("View");
        Class<OrbitViewMode> cls = OrbitViewMode.class;
        this.setIcon(OrbitViewMode.loadIcon(cls, "resources/ViewHandIcon16.png"));
        this.setCursor(OrbitViewMode.loadCursor(cls, "resources/ViewHandCursor16.png", 3, 2));
        this.setMnemonicKey(32);
        this.setAcceleratorKey(KeyStroke.getKeyStroke(32, 0));
        this.setShortDescription("Manipulate view");
    }

    protected void setActive(Component component, boolean active) {
        if (component instanceof ViewCanvas) {
            if (active) {
                component.addMouseListener(this._ml);
                component.addKeyListener(this._kl);
            } else {
                component.removeMouseListener(this._ml);
                component.removeKeyListener(this._kl);
            }
        }
    }

    private void beginScale(MouseEvent e) {
        this._ymouse = e.getY();
        this._canvas = (ViewCanvas)((Object)e.getSource());
        this._canvas.addMouseMotionListener(this._mml);
        this._view = (OrbitView)this._canvas.getView();
        this._scale = this._view.getScale();
    }

    private void duringScale(MouseEvent e) {
        int h = this._canvas.getHeight();
        int y = e.getY();
        int dy = y - this._ymouse;
        double ds = 2.0 * (double)dy / (double)h;
        this._view.setScale(this._scale * Math.pow(10.0, ds));
    }

    private void endScale(MouseEvent e) {
        this._canvas.removeMouseMotionListener(this._mml);
    }

    private void beginTranslate(MouseEvent e) {
        this._xmouse = e.getX();
        this._ymouse = e.getY();
        this._canvas = (ViewCanvas)((Object)e.getSource());
        this._canvas.addMouseMotionListener(this._mml);
        this._view = (OrbitView)this._canvas.getView();
        this._zmouse = this._canvas.getPixelZ(this._xmouse, this._ymouse);
        if (this._zmouse == 1.0) {
            this._zmouse = 0.5;
        }
        Matrix44 cubeToPixel = this._canvas.getCubeToPixel();
        Matrix44 viewToCube = this._canvas.getViewToCube();
        Matrix44 viewToPixel = cubeToPixel.times(viewToCube);
        Matrix44 unitSphereToView = this._view.getUnitSphereToView();
        Matrix44 unitSphereToPixel = viewToPixel.times(unitSphereToView);
        Matrix44 pixelToUnitSphere = unitSphereToPixel.inverse();
        this._translate = this._view.getTranslate();
        this._translateM = Matrix44.translate(this._translate).times(pixelToUnitSphere);
        this._translateP = this._translateM.times(new Point3(this._xmouse, this._ymouse, this._zmouse));
    }

    private void duringTranslate(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        Point3 p = new Point3(x, y, this._zmouse);
        Vector3 t = this._translate.plus(this._translateM.times(p).minus(this._translateP));
        this._view.setTranslate(t);
    }

    private void endTranslate(MouseEvent e) {
        this._canvas.removeMouseMotionListener(this._mml);
    }

    private void beginRotate(MouseEvent e) {
        this._xmouse = e.getX();
        this._ymouse = e.getY();
        this._canvas = (ViewCanvas)((Object)e.getSource());
        this._canvas.addMouseMotionListener(this._mml);
        this._view = (OrbitView)this._canvas.getView();
        this._azimuth = this._view.getAzimuth();
        this._elevation = this._view.getElevation();
    }

    private void duringRotate(MouseEvent e) {
        int w = this._canvas.getWidth();
        int h = this._canvas.getHeight();
        int x = e.getX();
        int y = e.getY();
        int dx = x - this._xmouse;
        int dy = y - this._ymouse;
        double da = -360.0 * (double)dx / (double)w;
        double de = 360.0 * (double)dy / (double)h;
        this._view.setAzimuthAndElevation(this._azimuth + da, this._elevation + de);
    }

    private void endRotate(MouseEvent e) {
        this._canvas.removeMouseMotionListener(this._mml);
    }
}

