/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.MouseConstrained;
import edu.mines.jtk.sgl.Plane;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Segment;
import edu.mines.jtk.sgl.Vector3;
import java.awt.event.MouseEvent;

public class MouseOnPlane
extends MouseConstrained {
    private Vector3 _normal;
    private Plane _plane;
    private Vector3 _delta;

    public MouseOnPlane(MouseEvent event, Point3 origin, Plane plane, Matrix44 localToPixel) {
        super(localToPixel);
        this._normal = plane.getNormal();
        this._plane = new Plane(plane);
        this._delta = origin.minus(this.getPointOnPlane(event));
    }

    public Point3 getPoint(MouseEvent event) {
        return this.getPointOnPlane(event).plusEquals(this._delta);
    }

    private Point3 getPointOnPlane(MouseEvent event) {
        Segment segment = this.getMouseSegment(event);
        Point3 a = segment.getA();
        Point3 b = segment.getB();
        Vector3 d = b.minus(a);
        double den = d.dot(this._normal);
        double num = -this._plane.distanceTo(a);
        double t = num / den;
        Point3 point = t <= 0.0 ? a : (t >= 1.0 ? b : a.plus(d.times(t)));
        return point;
    }
}

