/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.MouseConstrained;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.Segment;
import edu.mines.jtk.sgl.Vector3;
import java.awt.Canvas;
import java.awt.event.MouseEvent;

public class MouseOnLine
extends MouseConstrained {
    private double _ymouse;
    private Point3 _origin;
    private Vector3 _vector;
    private Vector3 _delta;
    private double _length;
    private Mode _mode;

    public MouseOnLine(MouseEvent event, Point3 origin, Vector3 vector, Matrix44 localToPixel) {
        super(localToPixel);
        this._ymouse = event.getY();
        this._origin = new Point3(origin);
        this._vector = vector.normalize();
        Segment mouseSegment = this.getMouseSegment(event);
        Point3 mouseNear = mouseSegment.getA();
        Point3 mouseFar = mouseSegment.getB();
        Vector3 mouseVector = mouseFar.minus(mouseNear).normalize();
        double d = mouseVector.dot(this._vector);
        if (d < 0.0) {
            d = -d;
            this._vector.negateEquals();
        }
        this._mode = d < 0.867 ? Mode.NEAREST : Mode.PUSH_PULL;
        this._length = mouseSegment.length();
        this._delta = origin.minus(this.getPointOnLine(event));
    }

    public Point3 getPoint(MouseEvent event) {
        return this.getPointOnLine(event).plusEquals(this._delta);
    }

    private Point3 getPointOnLine(MouseEvent event) {
        Point3 point = null;
        if (this._mode == Mode.NEAREST) {
            Segment segment = this.getMouseSegment(event);
            Point3 p1 = segment.getA();
            Vector3 v1 = segment.getB().minus(p1);
            Point3 p2 = this._origin;
            Vector3 v2 = this._vector;
            Vector3 a = p2.minus(p1);
            Vector3 b = v1;
            Vector3 c = v1.cross(v2);
            double cc = c.lengthSquared();
            double t = a.cross(b).dot(c) / cc;
            point = p2.plus(v2.times(t));
        } else if (this._mode == Mode.PUSH_PULL) {
            Canvas canvas = (Canvas)event.getSource();
            double height = canvas.getHeight();
            double ymouse = event.getY();
            double scale = 0.05 * (this._ymouse - ymouse) / height;
            point = this._origin.plus(this._vector.times(scale * this._length));
        }
        return point;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        NEAREST,
        PUSH_PULL;

    }
}

