/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.State;
import java.awt.Color;

public class LightModelState
implements State {
    private static float[] _ambientDefault = new float[]{0.2f, 0.2f, 0.2f, 1.0f};
    private float[] _ambient = _ambientDefault;
    private boolean _ambientSet;
    private static int _colorControlDefault = 33273;
    private int _colorControl = _colorControlDefault;
    private boolean _colorControlSet;
    private static boolean _localViewerDefault = false;
    private boolean _localViewer = _localViewerDefault;
    private boolean _localViewerSet;
    private static boolean _twoSideDefault = false;
    private boolean _twoSide = _twoSideDefault;
    private boolean _twoSideSet;

    public boolean hasAmbient() {
        return this._ambientSet;
    }

    public Color getAmbient() {
        return LightModelState.toColor(this._ambient);
    }

    public void setAmbient(Color color) {
        this._ambient = LightModelState.toArray(color);
        this._ambientSet = true;
    }

    public void unsetAmbient() {
        this._ambient = _ambientDefault;
        this._ambientSet = false;
    }

    public boolean hasColorControl() {
        return this._colorControlSet;
    }

    public int getColorControl() {
        return this._colorControl;
    }

    public void setColorControl(int control) {
        this._colorControl = control;
        this._colorControlSet = true;
    }

    public void unsetColorControl() {
        this._colorControl = _colorControlDefault;
        this._colorControlSet = false;
    }

    public boolean hasLocalViewer() {
        return this._localViewerSet;
    }

    public boolean getLocalViewer() {
        return this._localViewer;
    }

    public void setLocalViewer(boolean local) {
        this._localViewer = local;
        this._localViewerSet = true;
    }

    public void unsetLocalViewer() {
        this._localViewer = _localViewerDefault;
        this._localViewerSet = false;
    }

    public boolean hasTwoSide() {
        return this._twoSideSet;
    }

    public boolean getTwoSide() {
        return this._twoSide;
    }

    public void setTwoSide(boolean local) {
        this._twoSide = local;
        this._twoSideSet = true;
    }

    public void unsetTwoSide() {
        this._twoSide = _twoSideDefault;
        this._twoSideSet = false;
    }

    public void apply() {
        if (this._ambientSet) {
            Gl.glLightModelfv(2899, this._ambient, 0);
        }
        if (this._colorControlSet) {
            Gl.glLightModelf(33272, this._colorControl);
        }
        if (this._localViewerSet) {
            Gl.glLightModelf(2897, this._localViewer ? 1.0f : 0.0f);
        }
        if (this._twoSideSet) {
            Gl.glLightModelf(2898, this._twoSide ? 1.0f : 0.0f);
        }
    }

    public int getAttributeBits() {
        return 2896;
    }

    private static float[] toArray(Color c) {
        float r = (float)c.getRed() / 255.0f;
        float g = (float)c.getGreen() / 255.0f;
        float b = (float)c.getBlue() / 255.0f;
        float a = (float)c.getAlpha() / 255.0f;
        return new float[]{r, g, b, a};
    }

    private static Color toColor(float[] a) {
        return new Color(a[0], a[1], a[2], a[3]);
    }
}

