/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedQuad;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.ImagePanel;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.util.Clips;
import edu.mines.jtk.util.Float3;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImagePanelGroup
extends Group {
    private Sampling _sx;
    private Sampling _sy;
    private Sampling _sz;
    private Float3 _f3;
    private ArrayList<ImagePanel> _ipList;
    Clips _clips;
    private ColorMap _colorMap = new ColorMap(0.0, 1.0, ColorMap.GRAY);

    public ImagePanelGroup(Sampling sx, Sampling sy, Sampling sz, Float3 f3) {
        this(sx, sy, sz, f3, new Axis[]{Axis.X, Axis.Y, Axis.Z});
    }

    public ImagePanelGroup(Sampling sx, Sampling sy, Sampling sz, Float3 f3, Axis[] axes) {
        this._clips = new Clips(f3);
        this.addPanels(sx, sy, sz, f3, axes);
    }

    public ImagePanel getImagePanel(Axis axis) {
        for (ImagePanel ip : this._ipList) {
            if (axis != ip.getFrame().getAxis()) continue;
            return ip;
        }
        return null;
    }

    public Iterator<ImagePanel> getImagePanels() {
        return this._ipList.iterator();
    }

    public void setColorModel(IndexColorModel colorModel) {
        this._colorMap.setColorModel(colorModel);
        for (ImagePanel ip : this._ipList) {
            ip.setColorModel(colorModel);
        }
    }

    public IndexColorModel getColorModel() {
        return this._colorMap.getColorModel();
    }

    public void setClips(double clipMin, double clipMax) {
        this._clips.setClips(clipMin, clipMax);
        clipMin = this._clips.getClipMin();
        clipMax = this._clips.getClipMax();
        for (ImagePanel ip : this._ipList) {
            ip.setClips(clipMin, clipMax);
        }
        this._colorMap.setValueRange(clipMin, clipMax);
    }

    public float getClipMin() {
        return this._clips.getClipMin();
    }

    public float getClipMax() {
        return this._clips.getClipMax();
    }

    public void setPercentiles(double percMin, double percMax) {
        this._clips.setPercentiles(percMin, percMax);
        double clipMin = this._clips.getClipMin();
        double clipMax = this._clips.getClipMax();
        System.out.println("clip min=" + clipMin + " max=" + clipMax);
        for (ImagePanel ip : this._ipList) {
            ip.setClips(clipMin, clipMax);
        }
        this._colorMap.setValueRange(clipMin, clipMax);
    }

    public float getPercentileMin() {
        return this._clips.getPercentileMin();
    }

    public float getPercentileMax() {
        return this._clips.getPercentileMax();
    }

    public void addColorMapListener(ColorMapListener cml) {
        this._colorMap.addListener(cml);
    }

    public void removeColorMapListener(ColorMapListener cml) {
        this._colorMap.removeListener(cml);
    }

    private void addPanels(Sampling sx, Sampling sy, Sampling sz, Float3 f3, Axis[] axes) {
        this._sx = sx;
        this._sy = sy;
        this._sz = sz;
        this._f3 = f3;
        int nx = sx.getCount();
        int ny = sy.getCount();
        int nz = sz.getCount();
        double dx = sx.getDelta();
        double dy = sy.getDelta();
        double dz = sz.getDelta();
        double fx = sx.getFirst();
        double fy = sy.getFirst();
        double fz = sz.getFirst();
        double lx = fx + (double)(nx - 1) * dx;
        double ly = fy + (double)(ny - 1) * dy;
        double lz = fz + (double)(nz - 1) * dz;
        Point3 qmin = new Point3(fx, fy, fz);
        Point3 qmax = new Point3(lx, ly, lz);
        int np = axes.length;
        this._ipList = new ArrayList(np);
        for (int jp = 0; jp < np; ++jp) {
            AxisAlignedQuad aaq = new AxisAlignedQuad(axes[jp], qmin, qmax);
            ImagePanel ip = new ImagePanel(sx, sy, sz, f3);
            ip.setColorModel(this.getColorModel());
            aaq.getFrame().addChild(ip);
            this.addChild(aaq);
            this._ipList.add(ip);
        }
    }
}

