/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.CullContext;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.PickContext;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.TransformContext;
import edu.mines.jtk.sgl.Tuple3;
import edu.mines.jtk.sgl.View;

public abstract class Handle
extends Group {
    private static double _size = 10.0;
    private Matrix44 _transform = Matrix44.identity();
    private BoundingSphere _boundingSphereChildren;

    public static double getSize() {
        return _size;
    }

    public static void setSize(double size) {
        _size = size;
    }

    public Matrix44 getTransform() {
        return new Matrix44(this._transform);
    }

    public void setTransform(Matrix44 transform) {
        this._transform = new Matrix44(transform);
        this.dirtyBoundingSphere();
        this.dirtyDraw();
    }

    public Point3 getLocation() {
        return this._transform.times(new Point3());
    }

    public void setLocation(Point3 p) {
        this.setLocation(p.x, p.y, p.z);
    }

    public void setLocation(double x, double y, double z) {
        this._transform = Matrix44.translate(x, y, z);
        this.dirtyBoundingSphere();
        this.dirtyDraw();
    }

    protected BoundingSphere computeBoundingSphere(boolean finite) {
        this._boundingSphereChildren = super.computeBoundingSphere(true);
        return finite ? BoundingSphere.empty() : BoundingSphere.infinite();
    }

    protected Handle(Matrix44 transform) {
        this.setTransform(transform);
    }

    protected Handle(Point3 p) {
        this.setLocation(p.x, p.y, p.z);
    }

    protected Handle(double x, double y, double z) {
        this.setLocation(x, y, z);
    }

    protected void cullBegin(CullContext cc) {
        super.cullBegin(cc);
        Matrix44 transform = this.computeTransform(cc);
        cc.pushLocalToWorld(transform);
    }

    protected void cullEnd(CullContext cc) {
        cc.popLocalToWorld();
        super.cullEnd(cc);
    }

    protected void drawBegin(DrawContext dc) {
        super.drawBegin(dc);
        Matrix44 transform = this.computeTransform(dc);
        dc.pushLocalToWorld(transform);
        Gl.glPushMatrix();
        Gl.glMultMatrixd(transform.m, 0);
    }

    protected void drawEnd(DrawContext dc) {
        dc.popLocalToWorld();
        Gl.glPopMatrix();
        super.drawEnd(dc);
    }

    protected void pickBegin(PickContext pc) {
        super.pickBegin(pc);
        Matrix44 transform = this.computeTransform(pc);
        pc.pushLocalToWorld(transform);
    }

    protected void pickEnd(PickContext pc) {
        pc.popLocalToWorld();
        super.pickEnd(pc);
    }

    private Matrix44 computeTransform(TransformContext tc) {
        View view = tc.getView();
        Tuple3 as = view.getAxesScale();
        Matrix44 localToPixel = tc.getLocalToPixel().times(this._transform);
        Matrix44 pixelToLocal = localToPixel.inverse();
        Point3 p = new Point3(0.0, 0.0, 0.0);
        Point3 q = localToPixel.times(p);
        q.x += Handle.getSize();
        q = pixelToLocal.times(q);
        double dx = (q.x - p.x) * as.x;
        double dy = (q.y - p.y) * as.y;
        double dz = (q.z - p.z) * as.z;
        double d = Math.sqrt(dx * dx + dy * dy + dz * dz);
        double r = this._boundingSphereChildren.getRadius();
        double s = d / r;
        double sx = s / as.x;
        double sy = s / as.y;
        double sz = s / as.z;
        return this._transform.times(Matrix44.scale(sx, sy, sz));
    }
}

