/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.BoundingBox;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.CullContext;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.PickContext;
import edu.mines.jtk.sgl.World;
import edu.mines.jtk.util.Check;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Group
extends Node {
    ArrayList<Node> _childList = new ArrayList(4);

    public void addChild(Node child) {
        Check.argument(!(child instanceof World), "child is not a world");
        World worldChild = child.getWorld();
        World worldGroup = this.getWorld();
        Check.argument(worldChild == null || worldGroup == null || worldChild == worldGroup, "child is not already in a different world");
        if (child.addParent(this)) {
            this._childList.add(child);
            this.dirtyBoundingSphere();
            this.dirtyDraw();
            if (worldGroup != null) {
                worldGroup.updateSelectedSet(child);
            }
        }
    }

    public void removeChild(Node child) {
        if (child.removeParent(this)) {
            this._childList.remove(child);
            this.dirtyBoundingSphere();
            this.dirtyDraw();
            World worldGroup = this.getWorld();
            if (worldGroup != null) {
                worldGroup.updateSelectedSet(child);
            }
        }
    }

    public int countChildren() {
        return this._childList.size();
    }

    public Iterator<Node> getChildren() {
        return this._childList.iterator();
    }

    @Override
    protected void cull(CullContext cc) {
        for (Node child : this._childList) {
            child.cullApply(cc);
        }
    }

    @Override
    protected void draw(DrawContext dc) {
        for (Node child : this._childList) {
            child.drawApply(dc);
        }
    }

    @Override
    protected void pick(PickContext pc) {
        for (Node child : this._childList) {
            child.pickApply(pc);
        }
    }

    @Override
    protected BoundingSphere computeBoundingSphere(boolean finite) {
        if (this.countChildren() == 1) {
            return this._childList.get(0).getBoundingSphere(finite);
        }
        BoundingBox bb = new BoundingBox();
        for (Node child : this._childList) {
            bb.expandBy(child.getBoundingSphere(finite));
        }
        if (bb.isEmpty()) {
            return BoundingSphere.empty();
        }
        if (bb.isInfinite()) {
            return BoundingSphere.infinite();
        }
        BoundingSphere bs = new BoundingSphere(bb.getCenter(), 0.0);
        for (Node child : this._childList) {
            bs.expandRadiusBy(child.getBoundingSphere(finite));
        }
        return bs;
    }

    @Override
    protected int getAttributeBits() {
        return 0;
    }
}

