/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.sgl.ArrayStack;
import edu.mines.jtk.sgl.BoundingSphere;
import edu.mines.jtk.sgl.DrawList;
import edu.mines.jtk.sgl.Matrix44;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.Plane;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.TransformContext;
import edu.mines.jtk.sgl.ViewCanvas;

public class CullContext
extends TransformContext {
    private DrawList _drawList = new DrawList();
    private Plane[] _planes = new Plane[6];
    private int _active;
    private ArrayStack<Plane> _planesStack = new ArrayStack();
    private IntStack _activeStack = new IntStack();

    public CullContext(ViewCanvas canvas) {
        super(canvas);
        this.initFrustum();
    }

    public boolean frustumIntersectsSphereOf(Node node) {
        if (this._active != 0) {
            BoundingSphere bs = node.getBoundingSphere(false);
            if (bs.isEmpty()) {
                return false;
            }
            if (bs.isInfinite()) {
                return true;
            }
            Point3 c = bs.getCenter();
            double r = bs.getRadius();
            double s = -r;
            int i = 0;
            int plane = 1;
            while (i < 6) {
                if ((this._active & plane) != 0) {
                    double d = this._planes[i].distanceTo(c);
                    if (d < s) {
                        return false;
                    }
                    if (d > r) {
                        this._active ^= plane;
                    }
                }
                ++i;
                plane <<= 1;
            }
        }
        return true;
    }

    public void appendNodes() {
        this._drawList.append(this.getNodes());
    }

    public DrawList getDrawList() {
        return this._drawList;
    }

    public void pushNode(Node node) {
        super.pushNode(node);
        this._activeStack.push(this._active);
    }

    public void popNode() {
        super.popNode();
        this._active = this._activeStack.pop();
    }

    public void pushLocalToWorld(Matrix44 transform) {
        super.pushLocalToWorld(transform);
        int i = 0;
        int plane = 1;
        while (i < 6) {
            this._planesStack.push(new Plane(this._planes[i]));
            if ((this._active & plane) != 0) {
                this._planes[i].transformWithInverse(transform);
            }
            ++i;
            plane <<= 1;
        }
    }

    public void popLocalToWorld() {
        super.popLocalToWorld();
        for (int i = 5; i >= 0; --i) {
            this._planes[i] = this._planesStack.pop();
        }
    }

    private void initFrustum() {
        this._planes[0] = new Plane(-1.0, 0.0, 0.0, 1.0);
        this._planes[1] = new Plane(1.0, 0.0, 0.0, 1.0);
        this._planes[2] = new Plane(0.0, -1.0, 0.0, 1.0);
        this._planes[3] = new Plane(0.0, 1.0, 0.0, 1.0);
        this._planes[4] = new Plane(0.0, 0.0, -1.0, 1.0);
        this._planes[5] = new Plane(0.0, 0.0, 1.0, 1.0);
        this._active = 63;
        Matrix44 worldToCube = this.getWorldToCube();
        for (int i = 0; i < 6; ++i) {
            this._planes[i].transformWithInverse(worldToCube);
        }
    }

    private static class IntStack {
        private int _n = 0;
        private int[] _a = new int[8];

        private IntStack() {
        }

        void push(int active) {
            if (this._n == this._a.length) {
                int[] a = new int[2 * this._n];
                for (int i = 0; i < this._n; ++i) {
                    a[i] = this._a[i];
                }
                this._a = a;
            }
            this._a[this._n++] = active;
        }

        int pop() {
            return this._a[--this._n];
        }
    }
}

