/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt.test;

import edu.mines.jtk.opt.ArrayVect1;
import edu.mines.jtk.opt.VectMap;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class VectMapTest
extends TestCase {
    public void testAll() {
        int index;
        Random random = new Random(32525L);
        VectMap vm = new VectMap(false);
        for (int index2 = 0; index2 < 5; index2 += 2) {
            double[] a = new double[7 * index2];
            for (int i = 0; i < a.length; ++i) {
                a[i] = random.nextDouble();
            }
            ArrayVect1 v = new ArrayVect1(a, 2.0);
            vm.put(index2, v);
        }
        VectUtil.test(vm);
        int[] keys = vm.getKeys();
        assert (keys.length == 3) : "keys.length = " + keys.length;
        assert (keys[0] == 0);
        assert (keys[1] == 2);
        assert (keys[2] == 4);
        for (index = 0; index < 5; index += 2) {
            ArrayVect1 value = (ArrayVect1)vm.get(index);
            assert (value != null) : "index=" + index;
            assert (value.getData() != null) : "index=" + index;
            assert (value.getSize() == 7 * index) : "index=" + index;
            assert (value.getData().length == 7 * index) : "index=" + index;
            assert (vm.get(index + 1) == null) : "index=" + index;
        }
        vm = new VectMap(false);
        for (index = 1; index < 5; ++index) {
            double[] a = new double[7 * index];
            for (int i = 0; i < a.length; ++i) {
                a[i] = 1.0;
            }
            ArrayVect1 v = new ArrayVect1(a, 1.0);
            vm.put(index, v);
            assert (vm.containsKey(index));
        }
        assert (!vm.containsKey(99));
        VectMap wm = vm.clone();
        wm.multiplyInverseCovariance();
        assert (Almost.FLOAT.equal(1.0, wm.dot(vm)));
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public VectMapTest(String name) {
        super(name);
    }

    public static Test suite() {
        try {
            assert (false);
            throw new IllegalStateException("need -ea");
        }
        catch (AssertionError assertionError) {
            return new TestSuite(VectMapTest.class);
        }
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VectMapTest.suite());
    }
}

