/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt.test;

import edu.mines.jtk.opt.LineSearch;
import edu.mines.jtk.util.MathPlus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class LineSearchTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(LineSearchTest.class);
        TestRunner.run((Test)suite);
    }

    public void testMT1() {
        this.trace("Function 1");
        LineSearch.Function func = new LineSearch.Function(){
            private double beta = 2.0;

            public double[] evaluate(double s) {
                double t = 1.0 / (s * s + this.beta);
                double f = -s * t;
                double g = (s * s - this.beta) * t * t;
                return new double[]{f, g};
            }
        };
        LineSearch ls = new LineSearch(func, 1.0E-10, 0.001, 0.1);
        double[] se = new double[]{1.4, 1.4, 10.0, 37.0};
        double[] ge = new double[]{-0.0092, 0.0047, 0.0094, 7.3E-4};
        int[] ne = new int[]{7, 4, 2, 5};
        this.testMT(func, ls, se, ge, ne);
    }

    public void testMT2() {
        this.trace("Function 2");
        LineSearch.Function func = new LineSearch.Function(){
            private double beta2 = 0.004;

            public double[] evaluate(double s) {
                double t = s + this.beta2;
                double f = t * t * t * t * t - 2.0 * t * t * t * t;
                double g = 5.0 * t * t * t * t - 8.0 * t * t * t;
                return new double[]{f, g};
            }
        };
        LineSearch ls = new LineSearch(func, 1.0E-10, 0.1, 0.1);
        double[] se = new double[]{1.6, 1.6, 1.6, 1.6};
        double[] ge = new double[]{7.1E-9, 1.0E-10, -5.0E-9, -2.3E-8};
        int[] ne = new int[]{13, 9, 9, 12};
        this.testMT(func, ls, se, ge, ne);
    }

    public void testMT3() {
        this.trace("Function 3");
        LineSearch.Function func = new LineSearch.Function(){
            private double beta3 = 0.01;

            public double[] evaluate(double s) {
                double g;
                double f;
                int nwig = 39;
                if (s < 1.0 - this.beta3) {
                    f = 1.0 - s;
                    g = -1.0;
                } else if (s < 1.0 + this.beta3) {
                    f = (s - 1.0) * (s - 1.0) / (2.0 * this.beta3) + this.beta3 / 2.0;
                    g = (s - 1.0) / this.beta3;
                } else {
                    f = s - 1.0;
                    g = 1.0;
                }
                double t1 = 2.0 * (double)nwig * MathPlus.atan(1.0);
                double t2 = (1.0 - this.beta3) / t1;
                return new double[]{f += t2 * MathPlus.sin(t1 * s), g += (1.0 - this.beta3) * MathPlus.cos(t1 * s)};
            }
        };
        LineSearch ls = new LineSearch(func, 1.0E-10, 0.1, 0.1);
        double[] se = new double[]{1.0, 1.0, 1.0, 1.0};
        double[] ge = new double[]{-5.1E-5, -1.9E-4, -2.0E-6, -1.6E-5};
        int[] ne = new int[]{13, 13, 11, 14};
        this.testMT(func, ls, se, ge, ne);
    }

    public void testMT4() {
        this.trace("Function 4");
        LineSearch.Function func = new LineSearch.Function(){

            public double[] evaluate(double s) {
                double a1 = 0.001;
                double a2 = 0.001;
                double t1 = MathPlus.sqrt(1.0 + a1 * a1) - a1;
                double t2 = MathPlus.sqrt(1.0 + a2 * a2) - a2;
                double f = t1 * MathPlus.sqrt((1.0 - s) * (1.0 - s) + a2 * a2) + t2 * MathPlus.sqrt(s * s + a1 * a1);
                double g = -t1 * ((1.0 - s) / MathPlus.sqrt((1.0 - s) * (1.0 - s) + a2 * a2)) + t2 * (s / MathPlus.sqrt(s * s + a1 * a1));
                return new double[]{f, g};
            }
        };
        LineSearch ls = new LineSearch(func, 1.0E-10, 0.001, 0.001);
        double[] se = new double[]{0.08, 0.1, 0.35, 0.83};
        double[] ge = new double[]{-6.9E-5, -4.9E-5, -2.9E-6, 1.6E-5};
        int[] ne = new int[]{5, 2, 4, 5};
        this.testMT(func, ls, se, ge, ne);
    }

    public void testMT5() {
        this.trace("Function 5");
        LineSearch.Function func = new LineSearch.Function(){

            public double[] evaluate(double s) {
                double a1 = 0.01;
                double a2 = 0.001;
                double t1 = MathPlus.sqrt(1.0 + a1 * a1) - a1;
                double t2 = MathPlus.sqrt(1.0 + a2 * a2) - a2;
                double f = t1 * MathPlus.sqrt((1.0 - s) * (1.0 - s) + a2 * a2) + t2 * MathPlus.sqrt(s * s + a1 * a1);
                double g = -t1 * ((1.0 - s) / MathPlus.sqrt((1.0 - s) * (1.0 - s) + a2 * a2)) + t2 * (s / MathPlus.sqrt(s * s + a1 * a1));
                return new double[]{f, g};
            }
        };
        LineSearch ls = new LineSearch(func, 1.0E-10, 0.001, 0.001);
        double[] se = new double[]{0.075, 0.078, 0.073, 0.076};
        double[] ge = new double[]{1.9E-4, 7.4E-4, -2.6E-4, 4.5E-4};
        int[] ne = new int[]{7, 4, 8, 9};
        this.testMT(func, ls, se, ge, ne);
    }

    public void testMT6() {
        this.trace("Function 6");
        LineSearch.Function func = new LineSearch.Function(){

            public double[] evaluate(double s) {
                double a1 = 0.001;
                double a2 = 0.01;
                double t1 = MathPlus.sqrt(1.0 + a1 * a1) - a1;
                double t2 = MathPlus.sqrt(1.0 + a2 * a2) - a2;
                double f = t1 * MathPlus.sqrt((1.0 - s) * (1.0 - s) + a2 * a2) + t2 * MathPlus.sqrt(s * s + a1 * a1);
                double g = -t1 * ((1.0 - s) / MathPlus.sqrt((1.0 - s) * (1.0 - s) + a2 * a2)) + t2 * (s / MathPlus.sqrt(s * s + a1 * a1));
                return new double[]{f, g};
            }
        };
        LineSearch ls = new LineSearch(func, 1.0E-10, 0.001, 0.001);
        double[] se = new double[]{0.93, 0.93, 0.92, 0.92};
        double[] ge = new double[]{5.2E-4, 8.4E-5, -2.4E-4, -3.2E-4};
        int[] ne = new int[]{14, 12, 9, 12};
        this.testMT(func, ls, se, ge, ne);
    }

    private void testMT(LineSearch.Function func, LineSearch ls, double[] se, double[] ge, int[] ne) {
        double s = 0.001;
        int ie = 0;
        while (ie < se.length) {
            double[] fg = func.evaluate(0.0);
            double f = fg[0];
            double g = fg[1];
            double smin = 0.0;
            double smax = 4.0 * MathPlus.max(1.0, s);
            LineSearch.Result lsr = ls.search(s, f, g, smin, smax);
            this.trace("s0=" + s);
            this.trace(" s=" + lsr.s + " f'(s)=" + lsr.g + " ended=" + lsr.ended + " neval=" + lsr.neval);
            LineSearchTest.assertTrue((boolean)lsr.converged());
            LineSearchTest.assertEquals((double)se[ie], (double)lsr.s, (double)(0.1 * MathPlus.abs(se[ie])));
            LineSearchTest.assertEquals((int)ne[ie], (int)lsr.neval);
            ++ie;
            s *= 100.0;
        }
    }

    private void trace(String s) {
    }
}

