/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt.test;

import edu.mines.jtk.opt.BrentZeroFinder;
import edu.mines.jtk.util.MathPlus;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class BrentZeroFinderTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(BrentZeroFinderTest.class);
        TestRunner.run((Test)suite);
    }

    public void testForsythe() {
        ZeroFunc1 f1 = new ZeroFunc1();
        f1.findZero(2.0, 3.0);
        ZeroFunc2 f2 = new ZeroFunc2();
        f2.findZero(-1.0, 3.0);
        ZeroFunc3 f3 = new ZeroFunc3();
        f3.findZero(-1.0, 3.0);
    }

    private static void assertEqual(double x, double y) {
        BrentZeroFinderTest.assertTrue((String)(x + " = " + y), (boolean)BrentZeroFinderTest.almostEqual(x, y));
    }

    private static boolean almostEqual(double x, double y) {
        double ax = MathPlus.abs(x);
        double ay = MathPlus.abs(y);
        return MathPlus.abs(x - y) <= 1.0E-4 * MathPlus.max(ax, ay);
    }

    class ZeroFunc3
    extends BrentTestFunc {
        ZeroFunc3() {
        }

        double eval(double x) {
            return MathPlus.sin(x) - x;
        }

        void checkRoot(double x) {
            BrentZeroFinderTest.assertEqual(x, -1.643737357E-8);
        }

        void checkFunc(double y) {
            BrentZeroFinderTest.assertEqual(y, 0.0);
        }

        void checkCount(int count) {
            BrentZeroFinderTest.assertEqual(count, 58.0);
        }
    }

    class ZeroFunc2
    extends BrentTestFunc {
        ZeroFunc2() {
        }

        double eval(double x) {
            return MathPlus.cos(x) - x;
        }

        void checkRoot(double x) {
            BrentZeroFinderTest.assertEqual(x, 0.7390851332);
        }

        void checkFunc(double y) {
            BrentZeroFinderTest.assertEqual(y, 0.0);
        }

        void checkCount(int count) {
            BrentZeroFinderTest.assertEqual(count, 11.0);
        }
    }

    class ZeroFunc1
    extends BrentTestFunc {
        ZeroFunc1() {
        }

        double eval(double x) {
            return (MathPlus.pow(x, 2.0) - 2.0) * x - 5.0;
        }

        void checkRoot(double x) {
            BrentZeroFinderTest.assertEqual(x, 2.094551482);
        }

        void checkFunc(double y) {
            BrentZeroFinderTest.assertEqual(y, -1.7764E-15);
        }

        void checkCount(int count) {
            BrentZeroFinderTest.assertEqual(count, 11.0);
        }
    }

    abstract class BrentTestFunc
    implements BrentZeroFinder.Function {
        private int _count;

        BrentTestFunc() {
        }

        void findZero(double a, double b) {
            this._count = 0;
            BrentZeroFinder zeroFinder = new BrentZeroFinder(this);
            double xzero = zeroFinder.findZero(a, b, 2.220446049250313E-16);
            double yzero = this.evaluate(xzero);
            this.checkRoot(xzero);
            this.checkFunc(yzero);
            this.checkCount(this._count);
        }

        public double evaluate(double x) {
            ++this._count;
            return this.eval(x);
        }

        abstract double eval(double var1);

        abstract void checkRoot(double var1);

        abstract void checkFunc(double var1);

        abstract void checkCount(int var1);
    }
}

