/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectContainer;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.logging.Logger;

public class VectMap
implements VectContainer {
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private LinkedHashMap<Integer, Vect> _map = new LinkedHashMap();
    private boolean _cloneContents = false;
    private static final long serialVersionUID = 1L;

    public VectMap(boolean cloneContents) {
        if (cloneContents) {
            LOG.warning("Cloning hurts performance.  Use only for testing a VectContainer that requires puts.");
        }
        this._cloneContents = cloneContents;
    }

    public void put(int index, Vect vect) {
        this._map.put(index, this._cloneContents ? vect.clone() : vect);
    }

    public Vect get(int index) {
        Vect result = this.getPrivate(index);
        if (result != null && this._cloneContents) {
            result = result.clone();
        }
        return result;
    }

    private Vect getPrivate(int index) {
        return this._map.get(index);
    }

    public int size() {
        return this._map.size();
    }

    public boolean containsKey(int index) {
        return this._map.containsKey(index);
    }

    public int[] getKeys() {
        Set<Integer> keys = this._map.keySet();
        int[] result = new int[keys.size()];
        int i = 0;
        for (Integer j : keys) {
            result[i++] = j;
        }
        return result;
    }

    public double dot(VectConst other) {
        VectMap otherMap = (VectMap)other;
        int[] keys = this.getKeys();
        double result = 0.0;
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            Vect lhs = this.getPrivate(key);
            Vect rhs = otherMap.getPrivate(key);
            result += lhs.dot(rhs);
        }
        return result;
    }

    public VectMap clone() {
        VectMap result = null;
        try {
            result = (VectMap)super.clone();
            result._map = new LinkedHashMap();
            int[] keys = this.getKeys();
            for (int i = 0; i < keys.length; ++i) {
                int key = keys[i];
                Vect vect = this.getPrivate(key);
                result.put(key, vect.clone());
            }
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        return result;
    }

    public void dispose() {
        int[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Vect vect = this.getPrivate(keys[i]);
            vect.dispose();
        }
        this._map = null;
    }

    public void multiplyInverseCovariance() {
        int[] keys = this.getKeys();
        double scale = Almost.FLOAT.divide(1.0, (double)keys.length, 0.0);
        for (int i = 0; i < keys.length; ++i) {
            Vect vect = this.getPrivate(keys[i]);
            vect.multiplyInverseCovariance();
            VectUtil.scale(vect, scale);
        }
    }

    public void constrain() {
        int[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Vect vect = this.getPrivate(keys[i]);
            vect.constrain();
        }
    }

    public void postCondition() {
        int[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            Vect vect = this.getPrivate(keys[i]);
            vect.postCondition();
        }
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        this.addOrProject(scaleThis, scaleOther, other, false);
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.addOrProject(scaleThis, scaleOther, other, true);
    }

    private void addOrProject(double scaleThis, double scaleOther, VectConst other, boolean project) {
        VectMap otherMap = (VectMap)other;
        int[] keys = this.getKeys();
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            Vect vectTo = this.getPrivate(key);
            Vect vectFrom = otherMap.getPrivate(key);
            if (vectFrom == null) {
                throw new IllegalStateException("Cannot scale a vector missing key " + key);
            }
            if (project) {
                vectTo.project(scaleThis, scaleOther, vectFrom);
                continue;
            }
            vectTo.add(scaleThis, scaleOther, vectFrom);
        }
    }

    public double magnitude() {
        int[] keys = this.getKeys();
        double result = 0.0;
        for (int i = 0; i < keys.length; ++i) {
            int key = keys[i];
            Vect vect = this.getPrivate(key);
            result += vect.magnitude();
        }
        result = Almost.FLOAT.divide(result, (double)keys.length, 0.0);
        return result;
    }
}

