/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectContainer;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.logging.Logger;

public class VectArray
implements VectContainer {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private Vect[] _vect = null;
    private int[] _keys = null;

    public VectArray(int size) {
        this._vect = new Vect[size];
        this._keys = new int[size];
        for (int i = 0; i < size; ++i) {
            this._keys[i] = i;
        }
    }

    public void put(int index, Vect vect) {
        this._vect[index] = vect;
    }

    public Vect get(int index) {
        return this._vect[index];
    }

    public int size() {
        return this._vect.length;
    }

    public boolean containsKey(int index) {
        if (index >= 0 && index < this._vect.length) {
            return this._vect[index] != null;
        }
        return false;
    }

    public int[] getKeys() {
        return this._keys;
    }

    public double dot(VectConst other) {
        VectArray otherMap = (VectArray)other;
        double result = 0.0;
        for (int i = 0; i < this._vect.length; ++i) {
            result += this._vect[i].dot(otherMap._vect[i]);
        }
        return result;
    }

    public VectArray clone() {
        VectArray result = null;
        try {
            result = (VectArray)super.clone();
            result._vect = new Vect[this._vect.length];
            for (int i = 0; i < this._vect.length; ++i) {
                if (this._vect[i] == null) continue;
                result._vect[i] = this._vect[i].clone();
            }
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
        return result;
    }

    public void dispose() {
        this._vect = null;
        this._keys = null;
    }

    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this._vect.length, 0.0);
        for (int i = 0; i < this._vect.length; ++i) {
            this._vect[i].multiplyInverseCovariance();
            VectUtil.scale(this._vect[i], scale);
        }
    }

    public void constrain() {
        for (int i = 0; i < this._vect.length; ++i) {
            this._vect[i].constrain();
        }
    }

    public void postCondition() {
        for (int i = 0; i < this._vect.length; ++i) {
            this._vect[i].postCondition();
        }
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        this.addOrProject(scaleThis, scaleOther, other, false);
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.addOrProject(scaleThis, scaleOther, other, true);
    }

    private void addOrProject(double scaleThis, double scaleOther, VectConst other, boolean project) {
        VectArray otherMap = (VectArray)other;
        for (int i = 0; i < this._vect.length; ++i) {
            Vect vectTo = this._vect[i];
            Vect vectFrom = otherMap._vect[i];
            if (vectFrom == null) {
                throw new IllegalStateException("Cannot scale missing Vect " + i);
            }
            if (project) {
                vectTo.project(scaleThis, scaleOther, vectFrom);
                continue;
            }
            vectTo.add(scaleThis, scaleOther, vectFrom);
        }
    }

    public double magnitude() {
        double result = 0.0;
        for (int i = 0; i < this._vect.length; ++i) {
            result += this._vect[i].magnitude();
        }
        result = Almost.FLOAT.divide(result, (double)this._vect.length, 0.0);
        return result;
    }
}

