/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.util.Almost;
import java.util.logging.Logger;

public class ScalarVect
implements Vect {
    protected double _value = 0.0;
    protected double _variance = 1.0;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private static final long serialVersionUID = 1L;

    public ScalarVect(double value, double variance) {
        this.init(value, variance);
    }

    protected ScalarVect() {
        this.init(0.0, 1.0);
    }

    public void init(double value, double variance) {
        this._value = value;
        this._variance = variance;
    }

    public double get() {
        return this._value;
    }

    public void set(double value) {
        this._value = value;
    }

    public ScalarVect clone() {
        try {
            ScalarVect result = (ScalarVect)super.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public double dot(VectConst other) {
        ScalarVect rhs = (ScalarVect)other;
        return this._value * rhs._value;
    }

    public String toString() {
        return "ScalarVect<" + this._value + ">";
    }

    public void dispose() {
        this._value = Double.NaN;
        this._variance = Double.NaN;
    }

    public void multiplyInverseCovariance() {
        this._value = Almost.FLOAT.divide(this._value, this._variance, 0.0);
    }

    public void constrain() {
    }

    public void postCondition() {
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        ScalarVect rhs = (ScalarVect)other;
        this._value = scaleThis * this._value + scaleOther * rhs._value;
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), this._variance, 0.0);
    }
}

