/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.QuadraticSolver;
import edu.mines.jtk.opt.ScalarSolver;
import edu.mines.jtk.opt.Transform;
import edu.mines.jtk.opt.TransformQuadratic;
import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import edu.mines.jtk.util.Monitor;
import edu.mines.jtk.util.PartialMonitor;
import java.util.logging.Logger;

public class GaussNewtonSolver {
    private static boolean s_expensiveDebug = false;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");

    public static Vect solve(VectConst data, VectConst referenceModel, VectConst perturbModel, Transform transform, boolean dampOnlyPerturbation, int conjugateGradIterations, int lineSearchIterations, int linearizationIterations, double lineSearchError, Monitor monitor) {
        if (s_expensiveDebug) {
            VectUtil.test(data);
            VectUtil.test(referenceModel);
            TransformQuadratic tq = new TransformQuadratic(data, referenceModel, perturbModel, transform, dampOnlyPerturbation);
            int precision = tq.getTransposePrecision();
            if (precision < 6) {
                throw new IllegalStateException("Bad transpose precision = " + precision);
            }
            tq.dispose();
        }
        if (monitor == null) {
            monitor = Monitor.NULL_MONITOR;
        }
        monitor.report(0.0);
        Vect m0 = referenceModel.clone();
        referenceModel = null;
        m0.constrain();
        if (linearizationIterations < 1) {
            linearizationIterations = 1;
        }
        for (int iter = 0; iter < linearizationIterations; ++iter) {
            double frac = 3.0 * (double)conjugateGradIterations / (3.0 * (double)conjugateGradIterations + (double)lineSearchIterations);
            double begin = (double)iter / (double)linearizationIterations;
            double mid = ((double)iter + frac) / (double)linearizationIterations;
            double end = ((double)iter + 1.0) / (double)linearizationIterations;
            monitor.report(begin);
            TransformQuadratic transformQuadratic = new TransformQuadratic(data, m0, perturbModel, transform, dampOnlyPerturbation);
            QuadraticSolver quadraticSolver = new QuadraticSolver(transformQuadratic);
            Vect perturbation = quadraticSolver.solve(conjugateGradIterations, new PartialMonitor(monitor, begin, mid));
            double pp = perturbation.dot(perturbation);
            if (Almost.FLOAT.zero(pp)) {
                perturbation.dispose();
                transformQuadratic.dispose();
                break;
            }
            double scalar = 1.0;
            if (lineSearchIterations > 0) {
                TransformFunction transformFunction = new TransformFunction(transform, data, m0, perturbation, dampOnlyPerturbation);
                ScalarSolver scalarSolver = new ScalarSolver(transformFunction);
                double scalarMin = 0.0;
                double scalarMax = 1.1;
                double okError = lineSearchError;
                double okFraction = lineSearchError;
                scalar = scalarSolver.solve(scalarMin, scalarMax, okError, okFraction, lineSearchIterations, new PartialMonitor(monitor, mid, end));
                transformFunction.dispose();
            }
            m0.project(1.0, scalar, perturbation);
            m0.constrain();
            perturbation.dispose();
            transformQuadratic.dispose();
            monitor.report(end);
        }
        monitor.report(1.0);
        return m0;
    }

    public static void setExpensiveDebug(boolean debug) {
        s_expensiveDebug = debug;
    }

    private static class TransformFunction
    implements ScalarSolver.Function {
        VectConst _data;
        VectConst _referenceModel;
        VectConst _perturbation;
        Vect _model;
        TransformQuadratic _transformQuadratic;

        public TransformFunction(Transform transform, VectConst data, VectConst referenceModel, VectConst perturbation, boolean dampOnlyPerturbation) {
            this._data = data;
            this._referenceModel = referenceModel;
            this._model = this._referenceModel.clone();
            this._perturbation = perturbation;
            this._transformQuadratic = new TransformQuadratic(data, referenceModel, null, transform, dampOnlyPerturbation);
        }

        public double function(double scalar) {
            VectUtil.copy(this._model, this._referenceModel);
            this._model.project(1.0, scalar, this._perturbation);
            double result = this._transformQuadratic.evalFullObjectiveFunction(this._model);
            return result;
        }

        public void dispose() {
            this._model.dispose();
        }
    }
}

