/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.ArrayVect1;
import edu.mines.jtk.opt.Quadratic;
import edu.mines.jtk.opt.QuadraticSolver;
import edu.mines.jtk.opt.Vect;
import java.util.Arrays;
import java.util.logging.Logger;

public class CoordinateTransform {
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private int _nout = 0;
    private int _nin = 0;
    private double[][] _hessian;
    private double[][] _b;
    private double[][] _a;
    private double[] _in0 = null;
    private double[] _out0 = null;
    private double[] _inScr = null;
    private double[] _outScr = null;

    public CoordinateTransform(int dimensionOut, int dimensionIn) {
        this._nout = dimensionOut;
        this._nin = dimensionIn;
        this._hessian = new double[this._nin][this._nin];
        this._b = new double[this._nout][this._nin];
        this._inScr = new double[this._nin];
        this._outScr = new double[this._nout];
    }

    public void add(double[] out, double[] in) {
        int i;
        this._a = null;
        if (in.length != this._nin) {
            throw new IllegalArgumentException("in must have dimension " + this._nin);
        }
        if (out.length != this._nout) {
            throw new IllegalArgumentException("out must have dimension " + this._nout);
        }
        if (this._in0 == null) {
            this._in0 = (double[])in.clone();
        }
        if (this._out0 == null) {
            this._out0 = (double[])out.clone();
        }
        for (i = 0; i < this._nin; ++i) {
            this._inScr[i] = in[i] - this._in0[i];
        }
        for (i = 0; i < this._nout; ++i) {
            this._outScr[i] = out[i] - this._out0[i];
        }
        for (int k = 0; k < this._nin; ++k) {
            for (int i2 = 0; i2 < this._nin; ++i2) {
                double[] dArray = this._hessian[k];
                int n = i2;
                dArray[n] = dArray[n] + this._inScr[k] * this._inScr[i2];
            }
            for (int o = 0; o < this._nout; ++o) {
                double[] dArray = this._b[o];
                int n = k;
                dArray[n] = dArray[n] - this._outScr[o] * this._inScr[k];
            }
        }
    }

    public double[] get(double[] in) {
        for (int i = 0; i < in.length; ++i) {
            this._inScr[i] = in[i] - this._in0[i];
        }
        in = null;
        if (this._a == null) {
            this._a = new double[this._nout][this._nin];
            for (int o = 0; o < this._nout; ++o) {
                LinearQuadratic lq = new LinearQuadratic(o);
                QuadraticSolver qs = new QuadraticSolver(lq);
                ArrayVect1 solution = (ArrayVect1)qs.solve(this._nin + 4, null);
                double[] data = solution.getData();
                for (int i = 0; i < this._nin; ++i) {
                    this._a[o][i] = data[i];
                }
                solution.dispose();
            }
        }
        double[] result = new double[this._nout];
        for (int o = 0; o < this._nout; ++o) {
            for (int i = 0; i < this._nin; ++i) {
                int n = o;
                result[n] = result[n] + this._a[o][i] * this._inScr[i];
            }
        }
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i] + this._out0[i];
        }
        return result;
    }

    private class LinearQuadratic
    implements Quadratic {
        int _o = -1;

        public LinearQuadratic(int o) {
            this._o = o;
        }

        public void multiplyHessian(Vect x) {
            ArrayVect1 m = (ArrayVect1)x;
            double[] data = m.getData();
            double[] oldData = (double[])data.clone();
            Arrays.fill(data, 0.0);
            for (int i = 0; i < data.length; ++i) {
                for (int j = 0; j < data.length; ++j) {
                    int n = i;
                    data[n] = data[n] + CoordinateTransform.this._hessian[i][j] * oldData[j];
                }
            }
        }

        public Vect getB() {
            return new ArrayVect1((double[])CoordinateTransform.this._b[this._o].clone(), 1.0);
        }

        public void inverseHessian(Vect x) {
        }
    }
}

