/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.logging.Logger;

public class ArrayVect3f
implements Vect {
    protected float[][][] _data = null;
    protected double _variance = 1.0;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private static final long serialVersionUID = 1L;

    public ArrayVect3f(float[][][] data, double variance) {
        this.init(data, variance);
    }

    public double getVariance() {
        return this._variance;
    }

    protected ArrayVect3f() {
    }

    protected void init(float[][][] data, double variance) {
        this._data = data;
        this._variance = variance;
    }

    public float[][][] getData() {
        return this._data;
    }

    public int getSize() {
        return this._data.length * this._data[0].length * this._data[0][0].length;
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        float s1 = (float)scaleThis;
        float s2 = (float)scaleOther;
        ArrayVect3f rhs = (ArrayVect3f)other;
        for (int i = 0; i < this._data.length; ++i) {
            for (int j = 0; j < this._data[0].length; ++j) {
                for (int k = 0; k < this._data[0][0].length; ++k) {
                    this._data[i][j][k] = s1 * this._data[i][j][k] + s2 * rhs._data[i][j][k];
                }
            }
        }
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    public void dispose() {
        this._data = null;
    }

    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this.getSize() * this._variance, 0.0);
        VectUtil.scale(this, scale);
    }

    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), (double)this.getSize() * this._variance, 0.0);
    }

    public void constrain() {
    }

    public void postCondition() {
    }

    public ArrayVect3f clone() {
        try {
            float[][][] newData = new float[this._data.length][this._data[0].length][];
            for (int i = 0; i < newData.length; ++i) {
                for (int j = 0; j < newData[0].length; ++j) {
                    newData[i][j] = (float[])this._data[i][j].clone();
                }
            }
            ArrayVect3f result = (ArrayVect3f)super.clone();
            result.init(newData, this._variance);
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public double dot(VectConst other) {
        double result = 0.0;
        ArrayVect3f rhs = (ArrayVect3f)other;
        for (int i = 0; i < this._data.length; ++i) {
            for (int j = 0; j < this._data[0].length; ++j) {
                for (int k = 0; k < this._data[0][0].length; ++k) {
                    result += (double)(this._data[i][j][k] * rhs._data[i][j][k]);
                }
            }
        }
        return result;
    }
}

