/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.Arrays;
import java.util.logging.Logger;

public class ArrayVect2f
implements Vect {
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private static final long serialVersionUID = 2L;
    protected float[][] _data = null;
    private int[] _firstSample = null;
    protected double _variance = 1.0;
    private int _size = -1;

    public ArrayVect2f(float[][] data, double variance) {
        this.init(data, null, variance);
    }

    public ArrayVect2f(float[][] data, int[] firstSample, double variance) {
        this.init(data, firstSample, variance);
    }

    protected ArrayVect2f() {
    }

    protected void init(float[][] data, int[] firstSample, double variance) {
        this._data = data;
        this._variance = variance;
        this._firstSample = firstSample;
        if (this._firstSample != null && this._firstSample.length != data.length) {
            throw new IllegalArgumentException("Data and firstSample must have same length for slow dimension.");
        }
    }

    public float[][] getData() {
        return this._data;
    }

    public void dataChanged() {
        this._size = -1;
    }

    public int getSize() {
        if (this._size < 0) {
            this._size = 0;
            for (int i = 0; i < this._data.length && this._data.length > 0; ++i) {
                this._size += this._data[i].length;
            }
        }
        return this._size;
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        float s1 = (float)scaleThis;
        float s2 = (float)scaleOther;
        ArrayVect2f o = (ArrayVect2f)other;
        for (int i = 0; i < this._data.length; ++i) {
            for (int j = 0; j < this._data[i].length; ++j) {
                this._data[i][j] = s1 * this._data[i][j] + s2 * o._data[i][j];
            }
        }
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    public void dispose() {
        this._data = null;
    }

    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this.getSize() * this._variance, 0.0);
        VectUtil.scale(this, scale);
    }

    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), (double)this.getSize() * this._variance, 0.0);
    }

    public void constrain() {
        if (this._firstSample == null) {
            return;
        }
        for (int i = 0; i < this._data.length; ++i) {
            Arrays.fill(this._data[i], 0, this._firstSample[i], 0.0f);
        }
    }

    public void postCondition() {
    }

    public ArrayVect2f clone() {
        try {
            float[][] newData = new float[this._data.length][];
            for (int i = 0; i < newData.length; ++i) {
                newData[i] = (float[])this._data[i].clone();
            }
            int[] newFirstSample = this._firstSample != null ? (int[])this._firstSample.clone() : null;
            ArrayVect2f result = (ArrayVect2f)super.clone();
            result.init(newData, newFirstSample, this._variance);
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public double dot(VectConst other) {
        ArrayVect2f rhs = (ArrayVect2f)other;
        double result = 0.0;
        for (int i = 0; i < this._data.length; ++i) {
            for (int j = 0; j < this._data[i].length; ++j) {
                result += (double)(this._data[i][j] * rhs._data[i][j]);
            }
        }
        return result;
    }
}

