/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.logging.Logger;

public class ArrayVect2
implements Vect {
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private static final long serialVersionUID = 1L;
    private double[][] _data = null;
    private double _variance = 1.0;

    public ArrayVect2(double[][] data, double variance) {
        this.init(data, variance);
    }

    protected ArrayVect2() {
    }

    protected void init(double[][] data, double variance) {
        this._data = data;
        this._variance = variance;
    }

    public double[][] getData() {
        return this._data;
    }

    public int getSize() {
        return this._data.length * this._data[0].length;
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        ArrayVect2 o = (ArrayVect2)other;
        for (int i = 0; i < this._data.length && this._data.length > 0; ++i) {
            for (int j = 0; j < this._data[0].length; ++j) {
                this._data[i][j] = scaleThis * this._data[i][j] + scaleOther * o._data[i][j];
            }
        }
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    public void dispose() {
        this._data = null;
    }

    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this.getSize() * this._variance, 0.0);
        VectUtil.scale(this, scale);
    }

    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), (double)this.getSize() * this._variance, 0.0);
    }

    public void constrain() {
    }

    public void postCondition() {
    }

    public ArrayVect2 clone() {
        try {
            double[][] newData = new double[this._data.length][];
            for (int i = 0; i < newData.length; ++i) {
                newData[i] = (double[])this._data[i].clone();
            }
            ArrayVect2 result = (ArrayVect2)super.clone();
            result.init(newData, this._variance);
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public double dot(VectConst other) {
        ArrayVect2 rhs = (ArrayVect2)other;
        double result = 0.0;
        for (int i = 0; i < this._data.length; ++i) {
            for (int j = 0; j < this._data[0].length; ++j) {
                result += this._data[i][j] * rhs._data[i][j];
            }
        }
        return result;
    }
}

