/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectContainer;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.logging.Logger;

public class ArrayVect1f
implements Vect {
    private static final long serialVersionUID = 1L;
    protected float[] _data = null;
    protected double _variance = 1.0;
    protected int _firstSample = 0;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");

    public ArrayVect1f(float[] data, int firstSample, double variance) {
        this.init(data, firstSample, variance);
    }

    protected ArrayVect1f() {
    }

    protected void init(float[] data, int firstSample, double variance) {
        this._data = data;
        this._firstSample = firstSample;
        this._variance = variance;
    }

    public int getFirstSample() {
        return this._firstSample;
    }

    public int getSize() {
        return this._data.length;
    }

    public float[] getData() {
        return this._data;
    }

    public void setData(float[] data) {
        System.arraycopy(data, 0, this._data, 0, this._data.length);
    }

    public static void fillContainer(VectContainer container, int[] firstSamples, float[][] data, double variance) {
        for (int i = 0; i < data.length; ++i) {
            container.put(i, new ArrayVect1f(data[i], firstSamples[i], variance));
        }
    }

    public static void extractContainer(float[][] data, VectContainer container) {
        for (int i = 0; i < data.length; ++i) {
            ArrayVect1f trace = (ArrayVect1f)container.get(i);
            float[] traceData = trace.getData();
            System.arraycopy(traceData, 0, data[i], 0, data[i].length);
        }
    }

    public ArrayVect1f clone() {
        try {
            ArrayVect1f result = (ArrayVect1f)super.clone();
            if (this._data != null) {
                float[] newData = (float[])this._data.clone();
                result.init(newData, this._firstSample, this._variance);
            }
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this._data.length; ++i) {
            sb.append("" + this._data[i]);
            if (i >= this._data.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public double dot(VectConst other) {
        double result = 0.0;
        ArrayVect1f rhs = (ArrayVect1f)other;
        for (int i = 0; i < this._data.length; ++i) {
            result += (double)(this._data[i] * rhs._data[i]);
        }
        return result;
    }

    public void dispose() {
        this._data = null;
    }

    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this.getSize() * this._variance, 0.0);
        VectUtil.scale(this, scale);
    }

    public void constrain() {
        Arrays.fill(this._data, 0, this._firstSample, 0.0f);
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        float s1 = (float)scaleThis;
        float s2 = (float)scaleOther;
        ArrayVect1f rhs = (ArrayVect1f)other;
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = s1 * this._data[i] + s2 * rhs._data[i];
        }
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), (double)this.getSize() * this._variance, 0.0);
    }

    public void postCondition() {
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this._data);
        out.writeDouble(this._variance);
        out.writeInt(this._firstSample);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._data = (float[])in.readObject();
        this._variance = in.readDouble();
        this._firstSample = in.readInt();
    }
}

