/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opt;

import edu.mines.jtk.opt.Vect;
import edu.mines.jtk.opt.VectConst;
import edu.mines.jtk.opt.VectUtil;
import edu.mines.jtk.util.Almost;
import java.util.logging.Logger;

public class ArrayVect1
implements Vect {
    private double[] _data = null;
    private double _variance = 1.0;
    private static final Logger LOG = Logger.getLogger("edu.mines.jtk.opt");
    private static final long serialVersionUID = 1L;

    public ArrayVect1(double[] data, double variance) {
        this.init(data, variance);
    }

    protected ArrayVect1() {
    }

    protected void init(double[] data, double variance) {
        this._data = data;
        this._variance = variance;
    }

    public int getSize() {
        return this._data.length;
    }

    public double[] getData() {
        return this._data;
    }

    public ArrayVect1 clone() {
        try {
            ArrayVect1 result = (ArrayVect1)super.clone();
            result._data = (double[])result._data.clone();
            return result;
        }
        catch (CloneNotSupportedException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            e.initCause(ex);
            throw e;
        }
    }

    public double dot(VectConst other) {
        double result = 0.0;
        ArrayVect1 rhs = (ArrayVect1)other;
        for (int i = 0; i < this._data.length; ++i) {
            result += this._data[i] * rhs._data[i];
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this._data.length; ++i) {
            sb.append("" + this._data[i]);
            if (i >= this._data.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public void dispose() {
        this._data = null;
    }

    public void multiplyInverseCovariance() {
        double scale = Almost.FLOAT.divide(1.0, (double)this.getSize() * this._variance, 0.0);
        VectUtil.scale(this, scale);
    }

    public void constrain() {
    }

    public void postCondition() {
    }

    public void add(double scaleThis, double scaleOther, VectConst other) {
        ArrayVect1 rhs = (ArrayVect1)other;
        for (int i = 0; i < this._data.length; ++i) {
            this._data[i] = scaleThis * this._data[i] + scaleOther * rhs._data[i];
        }
    }

    public void project(double scaleThis, double scaleOther, VectConst other) {
        this.add(scaleThis, scaleOther, other);
    }

    public double magnitude() {
        return Almost.FLOAT.divide(this.dot(this), (double)this.getSize() * this._variance, 0.0);
    }
}

