/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opengl;

import edu.mines.jtk.opengl.Gl;
import edu.mines.jtk.util.Check;
import java.awt.Canvas;

public class GlContext {
    private long _peer;
    private ReentrantLock _lock = new ReentrantLock();
    private boolean _gotProcAddresses;
    private boolean _locked;
    long glBlendColor;
    long glBlendEquation;
    long glDrawRangeElements;
    long glColorTable;
    long glColorTableParameterfv;
    long glColorTableParameteriv;
    long glCopyColorTable;
    long glGetColorTable;
    long glGetColorTableParameterfv;
    long glGetColorTableParameteriv;
    long glColorSubTable;
    long glCopyColorSubTable;
    long glConvolutionFilter1D;
    long glConvolutionFilter2D;
    long glConvolutionParameterf;
    long glConvolutionParameterfv;
    long glConvolutionParameteri;
    long glConvolutionParameteriv;
    long glCopyConvolutionFilter1D;
    long glCopyConvolutionFilter2D;
    long glGetConvolutionFilter;
    long glGetConvolutionParameterfv;
    long glGetConvolutionParameteriv;
    long glGetSeparableFilter;
    long glSeparableFilter2D;
    long glGetHistogram;
    long glGetHistogramParameterfv;
    long glGetHistogramParameteriv;
    long glGetMinmax;
    long glGetMinmaxParameterfv;
    long glGetMinmaxParameteriv;
    long glHistogram;
    long glMinmax;
    long glResetHistogram;
    long glResetMinmax;
    long glTexImage3D;
    long glTexSubImage3D;
    long glCopyTexSubImage3D;
    long glActiveTexture;
    long glClientActiveTexture;
    long glMultiTexCoord1d;
    long glMultiTexCoord1dv;
    long glMultiTexCoord1f;
    long glMultiTexCoord1fv;
    long glMultiTexCoord1i;
    long glMultiTexCoord1iv;
    long glMultiTexCoord1s;
    long glMultiTexCoord1sv;
    long glMultiTexCoord2d;
    long glMultiTexCoord2dv;
    long glMultiTexCoord2f;
    long glMultiTexCoord2fv;
    long glMultiTexCoord2i;
    long glMultiTexCoord2iv;
    long glMultiTexCoord2s;
    long glMultiTexCoord2sv;
    long glMultiTexCoord3d;
    long glMultiTexCoord3dv;
    long glMultiTexCoord3f;
    long glMultiTexCoord3fv;
    long glMultiTexCoord3i;
    long glMultiTexCoord3iv;
    long glMultiTexCoord3s;
    long glMultiTexCoord3sv;
    long glMultiTexCoord4d;
    long glMultiTexCoord4dv;
    long glMultiTexCoord4f;
    long glMultiTexCoord4fv;
    long glMultiTexCoord4i;
    long glMultiTexCoord4iv;
    long glMultiTexCoord4s;
    long glMultiTexCoord4sv;
    long glLoadTransposeMatrixf;
    long glLoadTransposeMatrixd;
    long glMultTransposeMatrixf;
    long glMultTransposeMatrixd;
    long glSampleCoverage;
    long glCompressedTexImage3D;
    long glCompressedTexImage2D;
    long glCompressedTexImage1D;
    long glCompressedTexSubImage3D;
    long glCompressedTexSubImage2D;
    long glCompressedTexSubImage1D;
    long glGetCompressedTexImage;
    long glBlendFuncSeparate;
    long glFogCoordf;
    long glFogCoordfv;
    long glFogCoordd;
    long glFogCoorddv;
    long glFogCoordPointer;
    long glMultiDrawArrays;
    long glMultiDrawElements;
    long glPointParameterf;
    long glPointParameterfv;
    long glPointParameteri;
    long glPointParameteriv;
    long glSecondaryColor3b;
    long glSecondaryColor3bv;
    long glSecondaryColor3d;
    long glSecondaryColor3dv;
    long glSecondaryColor3f;
    long glSecondaryColor3fv;
    long glSecondaryColor3i;
    long glSecondaryColor3iv;
    long glSecondaryColor3s;
    long glSecondaryColor3sv;
    long glSecondaryColor3ub;
    long glSecondaryColor3ubv;
    long glSecondaryColor3ui;
    long glSecondaryColor3uiv;
    long glSecondaryColor3us;
    long glSecondaryColor3usv;
    long glSecondaryColorPointer;
    long glWindowPos2d;
    long glWindowPos2dv;
    long glWindowPos2f;
    long glWindowPos2fv;
    long glWindowPos2i;
    long glWindowPos2iv;
    long glWindowPos2s;
    long glWindowPos2sv;
    long glWindowPos3d;
    long glWindowPos3dv;
    long glWindowPos3f;
    long glWindowPos3fv;
    long glWindowPos3i;
    long glWindowPos3iv;
    long glWindowPos3s;
    long glWindowPos3sv;
    long glGenQueries;
    long glDeleteQueries;
    long glIsQuery;
    long glBeginQuery;
    long glEndQuery;
    long glGetQueryiv;
    long glGetQueryObjectiv;
    long glGetQueryObjectuiv;
    long glBindBuffer;
    long glDeleteBuffers;
    long glGenBuffers;
    long glIsBuffer;
    long glBufferData;
    long glBufferSubData;
    long glGetBufferSubData;
    long glMapBuffer;
    long glUnmapBuffer;
    long glGetBufferParameteriv;
    long glGetBufferPointerv;

    public GlContext(Canvas canvas) {
        this._peer = GlContext.makeGlAwtCanvasContext(canvas);
        Check.state(this._peer != 0L, "successfully created OpenGL context peer");
    }

    public void lock() {
        Check.state(this._peer != 0L, "this OpenGL context has not been disposed");
        this._lock.acquire();
        if (this._lock.holds() == 1L) {
            if (Gl.getContext() != null) {
                this._lock.release();
                Check.state(false, "current thread has no other OpenGL context locked");
            }
            if (!GlContext.lock(this._peer)) {
                this._lock.release();
                Check.state(false, "successfully locked OpenGL context peer");
            }
            this._locked = true;
            Gl.setContext(this);
            this.getProcAddresses();
        }
    }

    public void unlock() {
        Check.state(this._peer != 0L, "this OpenGL context has not been disposed");
        if (this._lock.holds() == 1L) {
            Check.state(Gl.getContext() == this, "this OpenGL context is locked in current thread");
            if (!GlContext.unlock(this._peer)) {
                Check.state(false, "successfully unlocked OpenGL context peer");
            }
            Gl.setContext(null);
            this._locked = false;
        }
        this._lock.release();
    }

    public boolean isLocked() {
        return this._locked;
    }

    public void swapBuffers() {
        Check.state(this._peer != 0L, "this OpenGL context has not been disposed");
        Check.state(Gl.getContext() == this, "this OpenGL context is locked in current thread");
        GlContext.swapBuffers(this._peer);
    }

    public synchronized void dispose() {
        Check.state(this._peer != 0L, "this OpenGL context has not been disposed");
        Check.state(!this._locked, "this OpenGL context is not locked in any thread");
        GlContext.killGlContext(this._peer);
        this._peer = 0L;
        this._gotProcAddresses = false;
    }

    public boolean isDisposed() {
        return this._peer == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private static native void killGlContext(long var0);

    private static native long makeGlAwtCanvasContext(Canvas var0);

    private static native boolean lock(long var0);

    private static native boolean unlock(long var0);

    private static native boolean swapBuffers(long var0);

    private void getProcAddresses() {
        if (this._gotProcAddresses) {
            return;
        }
        this.glBlendColor = GlContext.getProcAddress("glBlendColor");
        this.glBlendEquation = GlContext.getProcAddress("glBlendEquation");
        this.glDrawRangeElements = GlContext.getProcAddress("glDrawRangeElements");
        this.glColorTable = GlContext.getProcAddress("glColorTable");
        this.glColorTableParameterfv = GlContext.getProcAddress("glColorTableParameterfv");
        this.glColorTableParameteriv = GlContext.getProcAddress("glColorTableParameteriv");
        this.glCopyColorTable = GlContext.getProcAddress("glCopyColorTable");
        this.glGetColorTable = GlContext.getProcAddress("glGetColorTable");
        this.glGetColorTableParameterfv = GlContext.getProcAddress("glGetColorTableParameterfv");
        this.glGetColorTableParameteriv = GlContext.getProcAddress("glGetColorTableParameteriv");
        this.glColorSubTable = GlContext.getProcAddress("glColorSubTable");
        this.glCopyColorSubTable = GlContext.getProcAddress("glCopyColorSubTable");
        this.glConvolutionFilter1D = GlContext.getProcAddress("glConvolutionFilter1D");
        this.glConvolutionFilter2D = GlContext.getProcAddress("glConvolutionFilter2D");
        this.glConvolutionParameterf = GlContext.getProcAddress("glConvolutionParameterf");
        this.glConvolutionParameterfv = GlContext.getProcAddress("glConvolutionParameterfv");
        this.glConvolutionParameteri = GlContext.getProcAddress("glConvolutionParameteri");
        this.glConvolutionParameteriv = GlContext.getProcAddress("glConvolutionParameteriv");
        this.glCopyConvolutionFilter1D = GlContext.getProcAddress("glCopyConvolutionFilter1D");
        this.glCopyConvolutionFilter2D = GlContext.getProcAddress("glCopyConvolutionFilter2D");
        this.glGetConvolutionFilter = GlContext.getProcAddress("glGetConvolutionFilter");
        this.glGetConvolutionParameterfv = GlContext.getProcAddress("glGetConvolutionParameterfv");
        this.glGetConvolutionParameteriv = GlContext.getProcAddress("glGetConvolutionParameteriv");
        this.glGetSeparableFilter = GlContext.getProcAddress("glGetSeparableFilter");
        this.glSeparableFilter2D = GlContext.getProcAddress("glSeparableFilter2D");
        this.glGetHistogram = GlContext.getProcAddress("glGetHistogram");
        this.glGetHistogramParameterfv = GlContext.getProcAddress("glGetHistogramParameterfv");
        this.glGetHistogramParameteriv = GlContext.getProcAddress("glGetHistogramParameteriv");
        this.glGetMinmax = GlContext.getProcAddress("glGetMinmax");
        this.glGetMinmaxParameterfv = GlContext.getProcAddress("glGetMinmaxParameterfv");
        this.glGetMinmaxParameteriv = GlContext.getProcAddress("glGetMinmaxParameteriv");
        this.glHistogram = GlContext.getProcAddress("glHistogram");
        this.glMinmax = GlContext.getProcAddress("glMinmax");
        this.glResetHistogram = GlContext.getProcAddress("glResetHistogram");
        this.glResetMinmax = GlContext.getProcAddress("glResetMinmax");
        this.glTexImage3D = GlContext.getProcAddress("glTexImage3D");
        this.glTexSubImage3D = GlContext.getProcAddress("glTexSubImage3D");
        this.glCopyTexSubImage3D = GlContext.getProcAddress("glCopyTexSubImage3D");
        this.glActiveTexture = GlContext.getProcAddress("glActiveTexture");
        this.glClientActiveTexture = GlContext.getProcAddress("glClientActiveTexture");
        this.glMultiTexCoord1d = GlContext.getProcAddress("glMultiTexCoord1d");
        this.glMultiTexCoord1dv = GlContext.getProcAddress("glMultiTexCoord1dv");
        this.glMultiTexCoord1f = GlContext.getProcAddress("glMultiTexCoord1f");
        this.glMultiTexCoord1fv = GlContext.getProcAddress("glMultiTexCoord1fv");
        this.glMultiTexCoord1i = GlContext.getProcAddress("glMultiTexCoord1i");
        this.glMultiTexCoord1iv = GlContext.getProcAddress("glMultiTexCoord1iv");
        this.glMultiTexCoord1s = GlContext.getProcAddress("glMultiTexCoord1s");
        this.glMultiTexCoord1sv = GlContext.getProcAddress("glMultiTexCoord1sv");
        this.glMultiTexCoord2d = GlContext.getProcAddress("glMultiTexCoord2d");
        this.glMultiTexCoord2dv = GlContext.getProcAddress("glMultiTexCoord2dv");
        this.glMultiTexCoord2f = GlContext.getProcAddress("glMultiTexCoord2f");
        this.glMultiTexCoord2fv = GlContext.getProcAddress("glMultiTexCoord2fv");
        this.glMultiTexCoord2i = GlContext.getProcAddress("glMultiTexCoord2i");
        this.glMultiTexCoord2iv = GlContext.getProcAddress("glMultiTexCoord2iv");
        this.glMultiTexCoord2s = GlContext.getProcAddress("glMultiTexCoord2s");
        this.glMultiTexCoord2sv = GlContext.getProcAddress("glMultiTexCoord2sv");
        this.glMultiTexCoord3d = GlContext.getProcAddress("glMultiTexCoord3d");
        this.glMultiTexCoord3dv = GlContext.getProcAddress("glMultiTexCoord3dv");
        this.glMultiTexCoord3f = GlContext.getProcAddress("glMultiTexCoord3f");
        this.glMultiTexCoord3fv = GlContext.getProcAddress("glMultiTexCoord3fv");
        this.glMultiTexCoord3i = GlContext.getProcAddress("glMultiTexCoord3i");
        this.glMultiTexCoord3iv = GlContext.getProcAddress("glMultiTexCoord3iv");
        this.glMultiTexCoord3s = GlContext.getProcAddress("glMultiTexCoord3s");
        this.glMultiTexCoord3sv = GlContext.getProcAddress("glMultiTexCoord3sv");
        this.glMultiTexCoord4d = GlContext.getProcAddress("glMultiTexCoord4d");
        this.glMultiTexCoord4dv = GlContext.getProcAddress("glMultiTexCoord4dv");
        this.glMultiTexCoord4f = GlContext.getProcAddress("glMultiTexCoord4f");
        this.glMultiTexCoord4fv = GlContext.getProcAddress("glMultiTexCoord4fv");
        this.glMultiTexCoord4i = GlContext.getProcAddress("glMultiTexCoord4i");
        this.glMultiTexCoord4iv = GlContext.getProcAddress("glMultiTexCoord4iv");
        this.glMultiTexCoord4s = GlContext.getProcAddress("glMultiTexCoord4s");
        this.glMultiTexCoord4sv = GlContext.getProcAddress("glMultiTexCoord4sv");
        this.glLoadTransposeMatrixf = GlContext.getProcAddress("glLoadTransposeMatrixf");
        this.glLoadTransposeMatrixd = GlContext.getProcAddress("glLoadTransposeMatrixd");
        this.glMultTransposeMatrixf = GlContext.getProcAddress("glMultTransposeMatrixf");
        this.glMultTransposeMatrixd = GlContext.getProcAddress("glMultTransposeMatrixd");
        this.glSampleCoverage = GlContext.getProcAddress("glSampleCoverage");
        this.glCompressedTexImage3D = GlContext.getProcAddress("glCompressedTexImage3D");
        this.glCompressedTexImage2D = GlContext.getProcAddress("glCompressedTexImage2D");
        this.glCompressedTexImage1D = GlContext.getProcAddress("glCompressedTexImage1D");
        this.glCompressedTexSubImage3D = GlContext.getProcAddress("glCompressedTexSubImage3D");
        this.glCompressedTexSubImage2D = GlContext.getProcAddress("glCompressedTexSubImage2D");
        this.glCompressedTexSubImage1D = GlContext.getProcAddress("glCompressedTexSubImage1D");
        this.glGetCompressedTexImage = GlContext.getProcAddress("glGetCompressedTexImage");
        this.glBlendFuncSeparate = GlContext.getProcAddress("glBlendFuncSeparate");
        this.glFogCoordf = GlContext.getProcAddress("glFogCoordf");
        this.glFogCoordfv = GlContext.getProcAddress("glFogCoordfv");
        this.glFogCoordd = GlContext.getProcAddress("glFogCoordd");
        this.glFogCoorddv = GlContext.getProcAddress("glFogCoorddv");
        this.glFogCoordPointer = GlContext.getProcAddress("glFogCoordPointer");
        this.glMultiDrawArrays = GlContext.getProcAddress("glMultiDrawArrays");
        this.glMultiDrawElements = GlContext.getProcAddress("glMultiDrawElements");
        this.glPointParameterf = GlContext.getProcAddress("glPointParameterf");
        this.glPointParameterfv = GlContext.getProcAddress("glPointParameterfv");
        this.glPointParameteri = GlContext.getProcAddress("glPointParameteri");
        this.glPointParameteriv = GlContext.getProcAddress("glPointParameteriv");
        this.glSecondaryColor3b = GlContext.getProcAddress("glSecondaryColor3b");
        this.glSecondaryColor3bv = GlContext.getProcAddress("glSecondaryColor3bv");
        this.glSecondaryColor3d = GlContext.getProcAddress("glSecondaryColor3d");
        this.glSecondaryColor3dv = GlContext.getProcAddress("glSecondaryColor3dv");
        this.glSecondaryColor3f = GlContext.getProcAddress("glSecondaryColor3f");
        this.glSecondaryColor3fv = GlContext.getProcAddress("glSecondaryColor3fv");
        this.glSecondaryColor3i = GlContext.getProcAddress("glSecondaryColor3i");
        this.glSecondaryColor3iv = GlContext.getProcAddress("glSecondaryColor3iv");
        this.glSecondaryColor3s = GlContext.getProcAddress("glSecondaryColor3s");
        this.glSecondaryColor3sv = GlContext.getProcAddress("glSecondaryColor3sv");
        this.glSecondaryColor3ub = GlContext.getProcAddress("glSecondaryColor3ub");
        this.glSecondaryColor3ubv = GlContext.getProcAddress("glSecondaryColor3ubv");
        this.glSecondaryColor3ui = GlContext.getProcAddress("glSecondaryColor3ui");
        this.glSecondaryColor3uiv = GlContext.getProcAddress("glSecondaryColor3uiv");
        this.glSecondaryColor3us = GlContext.getProcAddress("glSecondaryColor3us");
        this.glSecondaryColor3usv = GlContext.getProcAddress("glSecondaryColor3usv");
        this.glSecondaryColorPointer = GlContext.getProcAddress("glSecondaryColorPointer");
        this.glWindowPos2d = GlContext.getProcAddress("glWindowPos2d");
        this.glWindowPos2dv = GlContext.getProcAddress("glWindowPos2dv");
        this.glWindowPos2f = GlContext.getProcAddress("glWindowPos2f");
        this.glWindowPos2fv = GlContext.getProcAddress("glWindowPos2fv");
        this.glWindowPos2i = GlContext.getProcAddress("glWindowPos2i");
        this.glWindowPos2iv = GlContext.getProcAddress("glWindowPos2iv");
        this.glWindowPos2s = GlContext.getProcAddress("glWindowPos2s");
        this.glWindowPos2sv = GlContext.getProcAddress("glWindowPos2sv");
        this.glWindowPos3d = GlContext.getProcAddress("glWindowPos3d");
        this.glWindowPos3dv = GlContext.getProcAddress("glWindowPos3dv");
        this.glWindowPos3f = GlContext.getProcAddress("glWindowPos3f");
        this.glWindowPos3fv = GlContext.getProcAddress("glWindowPos3fv");
        this.glWindowPos3i = GlContext.getProcAddress("glWindowPos3i");
        this.glWindowPos3iv = GlContext.getProcAddress("glWindowPos3iv");
        this.glWindowPos3s = GlContext.getProcAddress("glWindowPos3s");
        this.glWindowPos3sv = GlContext.getProcAddress("glWindowPos3sv");
        this.glGenQueries = GlContext.getProcAddress("glGenQueries");
        this.glDeleteQueries = GlContext.getProcAddress("glDeleteQueries");
        this.glIsQuery = GlContext.getProcAddress("glIsQuery");
        this.glBeginQuery = GlContext.getProcAddress("glBeginQuery");
        this.glEndQuery = GlContext.getProcAddress("glEndQuery");
        this.glGetQueryiv = GlContext.getProcAddress("glGetQueryiv");
        this.glGetQueryObjectiv = GlContext.getProcAddress("glGetQueryObjectiv");
        this.glGetQueryObjectuiv = GlContext.getProcAddress("glGetQueryObjectuiv");
        this.glBindBuffer = GlContext.getProcAddress("glBindBuffer");
        this.glDeleteBuffers = GlContext.getProcAddress("glDeleteBuffers");
        this.glGenBuffers = GlContext.getProcAddress("glGenBuffers");
        this.glIsBuffer = GlContext.getProcAddress("glIsBuffer");
        this.glBufferData = GlContext.getProcAddress("glBufferData");
        this.glBufferSubData = GlContext.getProcAddress("glBufferSubData");
        this.glGetBufferSubData = GlContext.getProcAddress("glGetBufferSubData");
        this.glMapBuffer = GlContext.getProcAddress("glMapBuffer");
        this.glUnmapBuffer = GlContext.getProcAddress("glUnmapBuffer");
        this.glGetBufferParameteriv = GlContext.getProcAddress("glGetBufferParameteriv");
        this.glGetBufferPointerv = GlContext.getProcAddress("glGetBufferPointerv");
        this._gotProcAddresses = true;
    }

    private static native long getProcAddress(String var0);

    static {
        System.loadLibrary("edu_mines_jtk_opengl");
    }

    private static class ReentrantLock {
        private Thread _owner = null;
        private long _holds = 0L;

        private ReentrantLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void acquire() {
            Check.state(!Thread.interrupted(), "thread is not interrupted");
            Thread caller = Thread.currentThread();
            ReentrantLock reentrantLock = this;
            synchronized (reentrantLock) {
                if (this._owner == caller) {
                    ++this._holds;
                } else {
                    try {
                        while (this._owner != null) {
                            this.wait();
                        }
                        this._owner = caller;
                        this._holds = 1L;
                    }
                    catch (InterruptedException ex) {
                        this.notify();
                        Check.state(false, "thread is not interrupted");
                    }
                }
            }
        }

        public synchronized void release() {
            Check.state(this._owner == Thread.currentThread(), "thread owns the lock");
            if (--this._holds == 0L) {
                this._owner = null;
                this.notify();
            }
        }

        public synchronized long holds() {
            return this._holds;
        }
    }
}

