/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.opengl;

import edu.mines.jtk.opengl.GlContext;
import edu.mines.jtk.opengl.GlPainter;
import java.awt.Canvas;
import java.awt.Graphics;

public class GlCanvas
extends Canvas {
    private static final long serialVersionUID = 1L;
    private GlPainter _painter;
    private GlContext _context;
    private boolean _inited;
    private int _width;
    private int _height;
    private boolean _autoRepaint;

    public GlCanvas() {
        this((GlPainter)null);
    }

    public GlCanvas(GlPainter painter) {
        this._painter = painter;
        this._context = new GlContext(this);
    }

    public GlContext getContext() {
        return this._context;
    }

    public void setAutoRepaint(boolean autoRepaint) {
        this._autoRepaint = autoRepaint;
    }

    public synchronized void dispose() {
        this._context.dispose();
    }

    public void glInit() {
        if (this._painter != null) {
            this._painter.glInit();
        }
    }

    public void glResize(int width, int height, int widthBefore, int heightBefore) {
        if (this._painter != null) {
            this._painter.glResize(width, height, widthBefore, heightBefore);
        }
    }

    public void glPaint() {
        if (this._painter != null) {
            this._painter.glPaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics g) {
        this._context.lock();
        try {
            if (!this._inited) {
                this.glInit();
                this._inited = true;
            }
            int width = this.getWidth();
            int height = this.getHeight();
            if (this._width != width || this._height != height) {
                this.glResize(width, height, this._width, this._height);
                this._width = width;
                this._height = height;
            }
            this.glPaint();
            this._context.swapBuffers();
            if (this._autoRepaint) {
                this.repaint();
            }
        }
        finally {
            this._context.unlock();
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }
}

