/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.ogl.test;

import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.ogl.GlCanvas;
import edu.mines.jtk.ogl.test.TestSimple;
import edu.mines.jtk.util.Stopwatch;
import java.util.Random;

public class Circle {
    private static GlCanvas canvas = new GlCanvas(){
        private int _nsides = 10;
        private int _nvert = 14;
        private double _r = 1.5707963267948966 / (double)this._nvert * 0.4;
        private boolean _wild;
        private Random _random = new Random();
        private Stopwatch _stopwatch = new Stopwatch();
        private int _npaint;
        private static final int X = 0;
        private static final int Y = 1;
        private static final int Z = 2;
        private static final double RFRAC = 0.4;
        private static final int UNIT_CIRCLE = 1;
        private static final int SIMPLE_CIRCLE = 0;
        private static final int LIST_CIRCLE = 1;
        private int _imode;
        private String[] _modes = new String[]{"simple", "display list"};

        public void glInit() {
            Gl.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
            Gl.glEnable(2929);
            this.listCircleInit(this._nsides);
            this._stopwatch.start();
        }

        public void glResize(int x, int y, int width, int height) {
            Gl.glViewport(0, 0, width, height);
            Gl.glMatrixMode(5889);
            Gl.glLoadIdentity();
            Gl.glFrustum(-0.03, 0.03, -0.03, 0.03, 0.1, 20.0);
            Gl.glMatrixMode(5888);
            Gl.glLoadIdentity();
            Gl.glTranslated(0.0, 0.0, -4.0);
            Gl.glRotated(-80.0, 1.0, 0.0, 0.0);
        }

        public void glPaint() {
            Gl.glClear(16640);
            boolean bl = this._wild = !this._wild;
            if (!this._wild) {
                Gl.glColor3f(1.0f, 1.0f, 1.0f);
            }
            double[] n = new double[3];
            for (int lat = 0; lat < this._nvert; ++lat) {
                double theta = Math.PI * (double)lat / (double)this._nvert;
                n[2] = Math.cos(theta);
                double nxy = Math.sin(theta);
                block5: for (int lon = 0; lon < 2 * this._nvert; ++lon) {
                    double phi = Math.PI * 2 * (double)lon / (double)(2 * this._nvert);
                    n[0] = nxy * Math.sin(phi);
                    n[1] = nxy * Math.cos(phi);
                    if (this._wild) {
                        Gl.glColor3f(this._random.nextFloat(), this._random.nextFloat(), this._random.nextFloat());
                    }
                    switch (this._imode) {
                        case 0: {
                            this.simpleCircle(n, n, this._r, this._nsides);
                            continue block5;
                        }
                        case 1: {
                            this.listCircle(n, n, this._r);
                        }
                    }
                }
            }
            Gl.glRotated(1.0, 0.0, 0.0, 1.0);
            Gl.glFlush();
            ++this._npaint;
            if (this._stopwatch.time() > 2.0) {
                this._stopwatch.stop();
                int rate = (int)((double)this._npaint / this._stopwatch.time());
                System.out.println(this._modes[this._imode] + ": frames/sec = " + rate);
                this._npaint = 0;
                this._stopwatch.restart();
                ++this._imode;
                if (this._imode == this._modes.length) {
                    this._imode = 0;
                }
            }
        }

        private void listCircleInit(int nsides) {
            Gl.glNewList(1, 4864);
            Gl.glBegin(9);
            for (int i = 0; i < nsides; ++i) {
                double ang = Math.PI * 2 * (double)i / (double)nsides;
                double cosang = Math.cos(ang);
                double sinang = Math.sin(ang);
                Gl.glVertex2d(cosang, sinang);
            }
            Gl.glEnd();
            Gl.glEndList();
        }

        private void listCircle(double[] c, double[] n, double r) {
            double tx = -Math.asin(n[1]);
            double ty = Math.atan2(n[0], n[2]);
            Gl.glPushMatrix();
            Gl.glTranslated(c[0], c[1], c[2]);
            Gl.glRotated(this.radToDeg(ty), 0.0, 1.0, 0.0);
            Gl.glRotated(this.radToDeg(tx), 1.0, 0.0, 0.0);
            Gl.glScaled(r, r, r);
            Gl.glCallList(1);
            Gl.glPopMatrix();
        }

        private void simpleCircle(double[] c, double[] n, double r, int nsides) {
            double[] u = n[0] * n[0] < 0.33 ? this.create(0.0, n[2], -n[1]) : this.create(-n[2], 0.0, n[0]);
            u = this.scale(u, r / this.length(u));
            double[] v = this.cross(n, u);
            v = this.scale(v, r / this.length(v));
            Gl.glBegin(9);
            for (int i = 0; i < nsides; ++i) {
                double ang = Math.PI * 2 * (double)i / (double)nsides;
                double cosang = Math.cos(ang);
                double sinang = Math.sin(ang);
                double x = c[0] + cosang * u[0] + sinang * v[0];
                double y = c[1] + cosang * u[1] + sinang * v[1];
                double z = c[2] + cosang * u[2] + sinang * v[2];
                Gl.glVertex3d(x, y, z);
            }
            Gl.glEnd();
        }

        private double[] create(double x, double y, double z) {
            return new double[]{x, y, z};
        }

        private double length(double[] a) {
            return Math.sqrt(a[0] * a[0] + a[1] * a[1] + a[2] * a[2]);
        }

        private double[] scale(double[] a, double s) {
            return new double[]{s * a[0], s * a[1], s * a[2]};
        }

        private double[] cross(double[] a, double[] b) {
            return new double[]{a[1] * b[2] - b[1] * a[2], a[2] * b[0] - b[2] * a[0], a[0] * b[1] - b[0] * a[1]};
        }

        private double radToDeg(double rad) {
            return 180.0 * rad / Math.PI;
        }
    };

    public static void main(String[] args) {
        TestSimple.run(args, canvas, true);
    }
}

